/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.statistics;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.statistics.Duration;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class DurationBuilder {
    private Counter64 _nanosecond;
    private Counter64 _second;
    private Map<Class<? extends Augmentation<Duration>>, Augmentation<Duration>> augmentation = new HashMap<Class<? extends Augmentation<Duration>>, Augmentation<Duration>>();

    public Counter64 getNanosecond() {
        return this._nanosecond;
    }

    public Counter64 getSecond() {
        return this._second;
    }

    public <E extends Augmentation<Duration>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DurationBuilder setNanosecond(Counter64 value) {
        this._nanosecond = value;
        return this;
    }

    public DurationBuilder setSecond(Counter64 value) {
        this._second = value;
        return this;
    }

    public DurationBuilder addAugmentation(Class<? extends Augmentation<Duration>> augmentationType, Augmentation<Duration> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Duration build() {
        return new DurationImpl(this);
    }

    private static final class DurationImpl
    implements Duration {
        private final Counter64 _nanosecond;
        private final Counter64 _second;
        private Map<Class<? extends Augmentation<Duration>>, Augmentation<Duration>> augmentation = new HashMap<Class<? extends Augmentation<Duration>>, Augmentation<Duration>>();

        public Class<Duration> getImplementedInterface() {
            return Duration.class;
        }

        private DurationImpl(DurationBuilder builder) {
            this._nanosecond = builder.getNanosecond();
            this._second = builder.getSecond();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Counter64 getNanosecond() {
            return this._nanosecond;
        }

        @Override
        public Counter64 getSecond() {
            return this._second;
        }

        public <E extends Augmentation<Duration>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._nanosecond == null ? 0 : this._nanosecond.hashCode());
            result = 31 * result + (this._second == null ? 0 : this._second.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DurationImpl other = (DurationImpl)obj;
            if (this._nanosecond == null ? other._nanosecond != null : !this._nanosecond.equals((Object)other._nanosecond)) {
                return false;
            }
            if (this._second == null ? other._second != null : !this._second.equals((Object)other._second)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Duration [_nanosecond=");
            builder.append(this._nanosecond);
            builder.append(", _second=");
            builder.append(this._second);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

