/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.EthernetMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Icmpv6Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.IpMatch;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer3Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Layer4Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.ProtocolMatchFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.Tunnel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.match.VlanMatch;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MatchBuilder {
    private EthernetMatch _ethernetMatch;
    private Icmpv4Match _icmpv4Match;
    private Icmpv6Match _icmpv6Match;
    private NodeConnectorId _inPhyPort;
    private NodeConnectorId _inPort;
    private IpMatch _ipMatch;
    private Layer3Match _layer3Match;
    private Layer4Match _layer4Match;
    private Metadata _metadata;
    private ProtocolMatchFields _protocolMatchFields;
    private Tunnel _tunnel;
    private VlanMatch _vlanMatch;
    private Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>();

    public MatchBuilder() {
    }

    public MatchBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match arg) {
        this._ethernetMatch = arg.getEthernetMatch();
        this._icmpv4Match = arg.getIcmpv4Match();
        this._icmpv6Match = arg.getIcmpv6Match();
        this._inPhyPort = arg.getInPhyPort();
        this._inPort = arg.getInPort();
        this._ipMatch = arg.getIpMatch();
        this._layer3Match = arg.getLayer3Match();
        this._layer4Match = arg.getLayer4Match();
        this._metadata = arg.getMetadata();
        this._protocolMatchFields = arg.getProtocolMatchFields();
        this._tunnel = arg.getTunnel();
        this._vlanMatch = arg.getVlanMatch();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match) {
            this._ethernetMatch = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getEthernetMatch();
            this._icmpv4Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getIcmpv4Match();
            this._icmpv6Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getIcmpv6Match();
            this._inPhyPort = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getInPhyPort();
            this._inPort = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getInPort();
            this._ipMatch = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getIpMatch();
            this._layer3Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getLayer3Match();
            this._layer4Match = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getLayer4Match();
            this._metadata = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getMetadata();
            this._protocolMatchFields = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getProtocolMatchFields();
            this._tunnel = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getTunnel();
            this._vlanMatch = ((org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match)arg).getVlanMatch();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.model.match.types.rev131026.Match] \nbut was: " + arg);
        }
    }

    public EthernetMatch getEthernetMatch() {
        return this._ethernetMatch;
    }

    public Icmpv4Match getIcmpv4Match() {
        return this._icmpv4Match;
    }

    public Icmpv6Match getIcmpv6Match() {
        return this._icmpv6Match;
    }

    public NodeConnectorId getInPhyPort() {
        return this._inPhyPort;
    }

    public NodeConnectorId getInPort() {
        return this._inPort;
    }

    public IpMatch getIpMatch() {
        return this._ipMatch;
    }

    public Layer3Match getLayer3Match() {
        return this._layer3Match;
    }

    public Layer4Match getLayer4Match() {
        return this._layer4Match;
    }

    public Metadata getMetadata() {
        return this._metadata;
    }

    public ProtocolMatchFields getProtocolMatchFields() {
        return this._protocolMatchFields;
    }

    public Tunnel getTunnel() {
        return this._tunnel;
    }

    public VlanMatch getVlanMatch() {
        return this._vlanMatch;
    }

    public <E extends Augmentation<Match>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MatchBuilder setEthernetMatch(EthernetMatch value) {
        this._ethernetMatch = value;
        return this;
    }

    public MatchBuilder setIcmpv4Match(Icmpv4Match value) {
        this._icmpv4Match = value;
        return this;
    }

    public MatchBuilder setIcmpv6Match(Icmpv6Match value) {
        this._icmpv6Match = value;
        return this;
    }

    public MatchBuilder setInPhyPort(NodeConnectorId value) {
        this._inPhyPort = value;
        return this;
    }

    public MatchBuilder setInPort(NodeConnectorId value) {
        this._inPort = value;
        return this;
    }

    public MatchBuilder setIpMatch(IpMatch value) {
        this._ipMatch = value;
        return this;
    }

    public MatchBuilder setLayer3Match(Layer3Match value) {
        this._layer3Match = value;
        return this;
    }

    public MatchBuilder setLayer4Match(Layer4Match value) {
        this._layer4Match = value;
        return this;
    }

    public MatchBuilder setMetadata(Metadata value) {
        this._metadata = value;
        return this;
    }

    public MatchBuilder setProtocolMatchFields(ProtocolMatchFields value) {
        this._protocolMatchFields = value;
        return this;
    }

    public MatchBuilder setTunnel(Tunnel value) {
        this._tunnel = value;
        return this;
    }

    public MatchBuilder setVlanMatch(VlanMatch value) {
        this._vlanMatch = value;
        return this;
    }

    public MatchBuilder addAugmentation(Class<? extends Augmentation<Match>> augmentationType, Augmentation<Match> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Match build() {
        return new MatchImpl(this);
    }

    private static final class MatchImpl
    implements Match {
        private final EthernetMatch _ethernetMatch;
        private final Icmpv4Match _icmpv4Match;
        private final Icmpv6Match _icmpv6Match;
        private final NodeConnectorId _inPhyPort;
        private final NodeConnectorId _inPort;
        private final IpMatch _ipMatch;
        private final Layer3Match _layer3Match;
        private final Layer4Match _layer4Match;
        private final Metadata _metadata;
        private final ProtocolMatchFields _protocolMatchFields;
        private final Tunnel _tunnel;
        private final VlanMatch _vlanMatch;
        private Map<Class<? extends Augmentation<Match>>, Augmentation<Match>> augmentation = new HashMap<Class<? extends Augmentation<Match>>, Augmentation<Match>>();

        public Class<Match> getImplementedInterface() {
            return Match.class;
        }

        private MatchImpl(MatchBuilder builder) {
            this._ethernetMatch = builder.getEthernetMatch();
            this._icmpv4Match = builder.getIcmpv4Match();
            this._icmpv6Match = builder.getIcmpv6Match();
            this._inPhyPort = builder.getInPhyPort();
            this._inPort = builder.getInPort();
            this._ipMatch = builder.getIpMatch();
            this._layer3Match = builder.getLayer3Match();
            this._layer4Match = builder.getLayer4Match();
            this._metadata = builder.getMetadata();
            this._protocolMatchFields = builder.getProtocolMatchFields();
            this._tunnel = builder.getTunnel();
            this._vlanMatch = builder.getVlanMatch();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public EthernetMatch getEthernetMatch() {
            return this._ethernetMatch;
        }

        @Override
        public Icmpv4Match getIcmpv4Match() {
            return this._icmpv4Match;
        }

        @Override
        public Icmpv6Match getIcmpv6Match() {
            return this._icmpv6Match;
        }

        @Override
        public NodeConnectorId getInPhyPort() {
            return this._inPhyPort;
        }

        @Override
        public NodeConnectorId getInPort() {
            return this._inPort;
        }

        @Override
        public IpMatch getIpMatch() {
            return this._ipMatch;
        }

        @Override
        public Layer3Match getLayer3Match() {
            return this._layer3Match;
        }

        @Override
        public Layer4Match getLayer4Match() {
            return this._layer4Match;
        }

        @Override
        public Metadata getMetadata() {
            return this._metadata;
        }

        @Override
        public ProtocolMatchFields getProtocolMatchFields() {
            return this._protocolMatchFields;
        }

        @Override
        public Tunnel getTunnel() {
            return this._tunnel;
        }

        @Override
        public VlanMatch getVlanMatch() {
            return this._vlanMatch;
        }

        public <E extends Augmentation<Match>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ethernetMatch == null ? 0 : this._ethernetMatch.hashCode());
            result = 31 * result + (this._icmpv4Match == null ? 0 : this._icmpv4Match.hashCode());
            result = 31 * result + (this._icmpv6Match == null ? 0 : this._icmpv6Match.hashCode());
            result = 31 * result + (this._inPhyPort == null ? 0 : this._inPhyPort.hashCode());
            result = 31 * result + (this._inPort == null ? 0 : this._inPort.hashCode());
            result = 31 * result + (this._ipMatch == null ? 0 : this._ipMatch.hashCode());
            result = 31 * result + (this._layer3Match == null ? 0 : this._layer3Match.hashCode());
            result = 31 * result + (this._layer4Match == null ? 0 : this._layer4Match.hashCode());
            result = 31 * result + (this._metadata == null ? 0 : this._metadata.hashCode());
            result = 31 * result + (this._protocolMatchFields == null ? 0 : this._protocolMatchFields.hashCode());
            result = 31 * result + (this._tunnel == null ? 0 : this._tunnel.hashCode());
            result = 31 * result + (this._vlanMatch == null ? 0 : this._vlanMatch.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchImpl other = (MatchImpl)obj;
            if (this._ethernetMatch == null ? other._ethernetMatch != null : !this._ethernetMatch.equals(other._ethernetMatch)) {
                return false;
            }
            if (this._icmpv4Match == null ? other._icmpv4Match != null : !this._icmpv4Match.equals(other._icmpv4Match)) {
                return false;
            }
            if (this._icmpv6Match == null ? other._icmpv6Match != null : !this._icmpv6Match.equals(other._icmpv6Match)) {
                return false;
            }
            if (this._inPhyPort == null ? other._inPhyPort != null : !this._inPhyPort.equals((Object)other._inPhyPort)) {
                return false;
            }
            if (this._inPort == null ? other._inPort != null : !this._inPort.equals((Object)other._inPort)) {
                return false;
            }
            if (this._ipMatch == null ? other._ipMatch != null : !this._ipMatch.equals(other._ipMatch)) {
                return false;
            }
            if (this._layer3Match == null ? other._layer3Match != null : !this._layer3Match.equals(other._layer3Match)) {
                return false;
            }
            if (this._layer4Match == null ? other._layer4Match != null : !this._layer4Match.equals(other._layer4Match)) {
                return false;
            }
            if (this._metadata == null ? other._metadata != null : !this._metadata.equals(other._metadata)) {
                return false;
            }
            if (this._protocolMatchFields == null ? other._protocolMatchFields != null : !this._protocolMatchFields.equals(other._protocolMatchFields)) {
                return false;
            }
            if (this._tunnel == null ? other._tunnel != null : !this._tunnel.equals(other._tunnel)) {
                return false;
            }
            if (this._vlanMatch == null ? other._vlanMatch != null : !this._vlanMatch.equals(other._vlanMatch)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Match [_ethernetMatch=");
            builder.append(this._ethernetMatch);
            builder.append(", _icmpv4Match=");
            builder.append(this._icmpv4Match);
            builder.append(", _icmpv6Match=");
            builder.append(this._icmpv6Match);
            builder.append(", _inPhyPort=");
            builder.append(this._inPhyPort);
            builder.append(", _inPort=");
            builder.append(this._inPort);
            builder.append(", _ipMatch=");
            builder.append(this._ipMatch);
            builder.append(", _layer3Match=");
            builder.append(this._layer3Match);
            builder.append(", _layer4Match=");
            builder.append(this._layer4Match);
            builder.append(", _metadata=");
            builder.append(this._metadata);
            builder.append(", _protocolMatchFields=");
            builder.append(this._protocolMatchFields);
            builder.append(", _tunnel=");
            builder.append(this._tunnel);
            builder.append(", _vlanMatch=");
            builder.append(this._vlanMatch);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

