/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.InstructionList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.flow.Instructions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.instruction.list.Instruction;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class InstructionsBuilder {
    private List<Instruction> _instruction;
    private Map<Class<? extends Augmentation<Instructions>>, Augmentation<Instructions>> augmentation = new HashMap<Class<? extends Augmentation<Instructions>>, Augmentation<Instructions>>();

    public InstructionsBuilder() {
    }

    public InstructionsBuilder(InstructionList arg) {
        this._instruction = arg.getInstruction();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof InstructionList) {
            this._instruction = ((InstructionList)arg).getInstruction();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.InstructionList] \nbut was: " + arg);
        }
    }

    public List<Instruction> getInstruction() {
        return this._instruction;
    }

    public <E extends Augmentation<Instructions>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public InstructionsBuilder setInstruction(List<Instruction> value) {
        this._instruction = value;
        return this;
    }

    public InstructionsBuilder addAugmentation(Class<? extends Augmentation<Instructions>> augmentationType, Augmentation<Instructions> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Instructions build() {
        return new InstructionsImpl(this);
    }

    private static final class InstructionsImpl
    implements Instructions {
        private final List<Instruction> _instruction;
        private Map<Class<? extends Augmentation<Instructions>>, Augmentation<Instructions>> augmentation = new HashMap<Class<? extends Augmentation<Instructions>>, Augmentation<Instructions>>();

        public Class<Instructions> getImplementedInterface() {
            return Instructions.class;
        }

        private InstructionsImpl(InstructionsBuilder builder) {
            this._instruction = builder.getInstruction();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<Instruction> getInstruction() {
            return this._instruction;
        }

        public <E extends Augmentation<Instructions>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._instruction == null ? 0 : this._instruction.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstructionsImpl other = (InstructionsImpl)obj;
            if (this._instruction == null ? other._instruction != null : !this._instruction.equals(other._instruction)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Instructions [_instruction=");
            builder.append(this._instruction);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

