/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.Queue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.queues.QueueKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.CommonQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueuePacket;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class QueueBuilder {
    private QueueKey _key;
    private Long _port;
    private QueueId _queueId;
    private Integer _property;
    private Map<Class<? extends Augmentation<Queue>>, Augmentation<Queue>> augmentation = new HashMap<Class<? extends Augmentation<Queue>>, Augmentation<Queue>>();

    public QueueBuilder() {
    }

    public QueueBuilder(QueuePacket arg) {
        this._port = arg.getPort();
        this._queueId = arg.getQueueId();
        this._property = arg.getProperty();
    }

    public QueueBuilder(CommonQueue arg) {
        this._property = arg.getProperty();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof QueuePacket) {
            this._port = ((QueuePacket)arg).getPort();
            this._queueId = ((QueuePacket)arg).getQueueId();
            isValidArg = true;
        }
        if (arg instanceof CommonQueue) {
            this._property = ((CommonQueue)arg).getProperty();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.QueuePacket, org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.queue.rev130925.CommonQueue] \nbut was: " + arg);
        }
    }

    public QueueKey getKey() {
        return this._key;
    }

    public Long getPort() {
        return this._port;
    }

    public QueueId getQueueId() {
        return this._queueId;
    }

    public Integer getProperty() {
        return this._property;
    }

    public <E extends Augmentation<Queue>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public QueueBuilder setKey(QueueKey value) {
        this._key = value;
        return this;
    }

    public QueueBuilder setPort(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._port = value;
        return this;
    }

    public QueueBuilder setQueueId(QueueId value) {
        this._queueId = value;
        return this;
    }

    public QueueBuilder setProperty(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._property = value;
        return this;
    }

    public QueueBuilder addAugmentation(Class<? extends Augmentation<Queue>> augmentationType, Augmentation<Queue> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Queue build() {
        return new QueueImpl(this);
    }

    private static final class QueueImpl
    implements Queue {
        private final QueueKey _key;
        private final Long _port;
        private final QueueId _queueId;
        private final Integer _property;
        private Map<Class<? extends Augmentation<Queue>>, Augmentation<Queue>> augmentation = new HashMap<Class<? extends Augmentation<Queue>>, Augmentation<Queue>>();

        public Class<Queue> getImplementedInterface() {
            return Queue.class;
        }

        private QueueImpl(QueueBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new QueueKey(builder.getQueueId());
                this._queueId = builder.getQueueId();
            } else {
                this._key = builder.getKey();
                this._queueId = this._key.getQueueId();
            }
            this._port = builder.getPort();
            this._property = builder.getProperty();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public QueueKey getKey() {
            return this._key;
        }

        @Override
        public Long getPort() {
            return this._port;
        }

        @Override
        public QueueId getQueueId() {
            return this._queueId;
        }

        @Override
        public Integer getProperty() {
            return this._property;
        }

        public <E extends Augmentation<Queue>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._port == null ? 0 : this._port.hashCode());
            result = 31 * result + (this._queueId == null ? 0 : this._queueId.hashCode());
            result = 31 * result + (this._property == null ? 0 : this._property.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueImpl other = (QueueImpl)obj;
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._port == null ? other._port != null : !this._port.equals(other._port)) {
                return false;
            }
            if (this._queueId == null ? other._queueId != null : !this._queueId.equals((Object)other._queueId)) {
                return false;
            }
            if (this._property == null ? other._property != null : !this._property.equals(other._property)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Queue [_key=");
            builder.append(this._key);
            builder.append(", _port=");
            builder.append(this._port);
            builder.append(", _queueId=");
            builder.append((Object)this._queueId);
            builder.append(", _property=");
            builder.append(this._property);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

