/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.port.mod.port;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.CommonPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.port.mod.port.Port;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.port.mod.port.PortKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PortBuilder {
    private Boolean _barrier;
    private String _containerName;
    private PortConfig _mask;
    private Long _portModOrder;
    private String _portName;
    private PortKey _key;
    private PortFeatures _advertisedFeatures;
    private PortConfig _configuration;
    private MacAddress _hardwareAddress;
    private Long _portNumber;
    private Map<Class<? extends Augmentation<Port>>, Augmentation<Port>> augmentation = new HashMap<Class<? extends Augmentation<Port>>, Augmentation<Port>>();

    public PortBuilder() {
    }

    public PortBuilder(CommonPort arg) {
        this._advertisedFeatures = arg.getAdvertisedFeatures();
        this._configuration = arg.getConfiguration();
        this._hardwareAddress = arg.getHardwareAddress();
        this._portNumber = arg.getPortNumber();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof CommonPort) {
            this._advertisedFeatures = ((CommonPort)arg).getAdvertisedFeatures();
            this._configuration = ((CommonPort)arg).getConfiguration();
            this._hardwareAddress = ((CommonPort)arg).getHardwareAddress();
            this._portNumber = ((CommonPort)arg).getPortNumber();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.CommonPort] \nbut was: " + arg);
        }
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public PortConfig getMask() {
        return this._mask;
    }

    public Long getPortModOrder() {
        return this._portModOrder;
    }

    public String getPortName() {
        return this._portName;
    }

    public PortKey getKey() {
        return this._key;
    }

    public PortFeatures getAdvertisedFeatures() {
        return this._advertisedFeatures;
    }

    public PortConfig getConfiguration() {
        return this._configuration;
    }

    public MacAddress getHardwareAddress() {
        return this._hardwareAddress;
    }

    public Long getPortNumber() {
        return this._portNumber;
    }

    public <E extends Augmentation<Port>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PortBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public PortBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public PortBuilder setMask(PortConfig value) {
        this._mask = value;
        return this;
    }

    public PortBuilder setPortModOrder(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._portModOrder = value;
        return this;
    }

    public PortBuilder setPortName(String value) {
        this._portName = value;
        return this;
    }

    public PortBuilder setKey(PortKey value) {
        this._key = value;
        return this;
    }

    public PortBuilder setAdvertisedFeatures(PortFeatures value) {
        this._advertisedFeatures = value;
        return this;
    }

    public PortBuilder setConfiguration(PortConfig value) {
        this._configuration = value;
        return this;
    }

    public PortBuilder setHardwareAddress(MacAddress value) {
        this._hardwareAddress = value;
        return this;
    }

    public PortBuilder setPortNumber(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._portNumber = value;
        return this;
    }

    public PortBuilder addAugmentation(Class<? extends Augmentation<Port>> augmentationType, Augmentation<Port> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Port build() {
        return new PortImpl(this);
    }

    private static final class PortImpl
    implements Port {
        private final Boolean _barrier;
        private final String _containerName;
        private final PortConfig _mask;
        private final Long _portModOrder;
        private final String _portName;
        private final PortKey _key;
        private final PortFeatures _advertisedFeatures;
        private final PortConfig _configuration;
        private final MacAddress _hardwareAddress;
        private final Long _portNumber;
        private Map<Class<? extends Augmentation<Port>>, Augmentation<Port>> augmentation = new HashMap<Class<? extends Augmentation<Port>>, Augmentation<Port>>();

        public Class<Port> getImplementedInterface() {
            return Port.class;
        }

        private PortImpl(PortBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new PortKey(builder.getPortModOrder());
                this._portModOrder = builder.getPortModOrder();
            } else {
                this._key = builder.getKey();
                this._portModOrder = this._key.getPortModOrder();
            }
            this._barrier = builder.isBarrier();
            this._containerName = builder.getContainerName();
            this._mask = builder.getMask();
            this._portName = builder.getPortName();
            this._advertisedFeatures = builder.getAdvertisedFeatures();
            this._configuration = builder.getConfiguration();
            this._hardwareAddress = builder.getHardwareAddress();
            this._portNumber = builder.getPortNumber();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Boolean isBarrier() {
            return this._barrier;
        }

        @Override
        public String getContainerName() {
            return this._containerName;
        }

        @Override
        public PortConfig getMask() {
            return this._mask;
        }

        @Override
        public Long getPortModOrder() {
            return this._portModOrder;
        }

        @Override
        public String getPortName() {
            return this._portName;
        }

        @Override
        public PortKey getKey() {
            return this._key;
        }

        @Override
        public PortFeatures getAdvertisedFeatures() {
            return this._advertisedFeatures;
        }

        @Override
        public PortConfig getConfiguration() {
            return this._configuration;
        }

        @Override
        public MacAddress getHardwareAddress() {
            return this._hardwareAddress;
        }

        @Override
        public Long getPortNumber() {
            return this._portNumber;
        }

        public <E extends Augmentation<Port>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._barrier == null ? 0 : this._barrier.hashCode());
            result = 31 * result + (this._containerName == null ? 0 : this._containerName.hashCode());
            result = 31 * result + (this._mask == null ? 0 : this._mask.hashCode());
            result = 31 * result + (this._portModOrder == null ? 0 : this._portModOrder.hashCode());
            result = 31 * result + (this._portName == null ? 0 : this._portName.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this._advertisedFeatures == null ? 0 : this._advertisedFeatures.hashCode());
            result = 31 * result + (this._configuration == null ? 0 : this._configuration.hashCode());
            result = 31 * result + (this._hardwareAddress == null ? 0 : this._hardwareAddress.hashCode());
            result = 31 * result + (this._portNumber == null ? 0 : this._portNumber.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PortImpl other = (PortImpl)obj;
            if (this._barrier == null ? other._barrier != null : !this._barrier.equals(other._barrier)) {
                return false;
            }
            if (this._containerName == null ? other._containerName != null : !this._containerName.equals(other._containerName)) {
                return false;
            }
            if (this._mask == null ? other._mask != null : !this._mask.equals(other._mask)) {
                return false;
            }
            if (this._portModOrder == null ? other._portModOrder != null : !this._portModOrder.equals(other._portModOrder)) {
                return false;
            }
            if (this._portName == null ? other._portName != null : !this._portName.equals(other._portName)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            if (this._advertisedFeatures == null ? other._advertisedFeatures != null : !this._advertisedFeatures.equals(other._advertisedFeatures)) {
                return false;
            }
            if (this._configuration == null ? other._configuration != null : !this._configuration.equals(other._configuration)) {
                return false;
            }
            if (this._hardwareAddress == null ? other._hardwareAddress != null : !this._hardwareAddress.equals((Object)other._hardwareAddress)) {
                return false;
            }
            if (this._portNumber == null ? other._portNumber != null : !this._portNumber.equals(other._portNumber)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Port [_barrier=");
            builder.append(this._barrier);
            builder.append(", _containerName=");
            builder.append(this._containerName);
            builder.append(", _mask=");
            builder.append(this._mask);
            builder.append(", _portModOrder=");
            builder.append(this._portModOrder);
            builder.append(", _portName=");
            builder.append(this._portName);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", _advertisedFeatures=");
            builder.append(this._advertisedFeatures);
            builder.append(", _configuration=");
            builder.append(this._configuration);
            builder.append(", _hardwareAddress=");
            builder.append(this._hardwareAddress);
            builder.append(", _portNumber=");
            builder.append(this._portNumber);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

