/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.flow.capable.port;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.flow.capable.port.State;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private Boolean _blocked;
    private Boolean _linkDown;
    private Boolean _live;
    private Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();

    public StateBuilder() {
    }

    public StateBuilder(PortState arg) {
        this._blocked = arg.isBlocked();
        this._linkDown = arg.isLinkDown();
        this._live = arg.isLive();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof PortState) {
            this._blocked = ((PortState)arg).isBlocked();
            this._linkDown = ((PortState)arg).isLinkDown();
            this._live = ((PortState)arg).isLive();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.port.rev130925.PortState] \nbut was: " + arg);
        }
    }

    public Boolean isBlocked() {
        return this._blocked;
    }

    public Boolean isLinkDown() {
        return this._linkDown;
    }

    public Boolean isLive() {
        return this._live;
    }

    public <E extends Augmentation<State>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public StateBuilder setBlocked(Boolean value) {
        this._blocked = value;
        return this;
    }

    public StateBuilder setLinkDown(Boolean value) {
        this._linkDown = value;
        return this;
    }

    public StateBuilder setLive(Boolean value) {
        this._live = value;
        return this;
    }

    public StateBuilder addAugmentation(Class<? extends Augmentation<State>> augmentationType, Augmentation<State> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
    implements State {
        private final Boolean _blocked;
        private final Boolean _linkDown;
        private final Boolean _live;
        private Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();

        public Class<State> getImplementedInterface() {
            return State.class;
        }

        private StateImpl(StateBuilder builder) {
            this._blocked = builder.isBlocked();
            this._linkDown = builder.isLinkDown();
            this._live = builder.isLive();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Boolean isBlocked() {
            return this._blocked;
        }

        @Override
        public Boolean isLinkDown() {
            return this._linkDown;
        }

        @Override
        public Boolean isLive() {
            return this._live;
        }

        public <E extends Augmentation<State>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._blocked == null ? 0 : this._blocked.hashCode());
            result = 31 * result + (this._linkDown == null ? 0 : this._linkDown.hashCode());
            result = 31 * result + (this._live == null ? 0 : this._live.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            if (this._blocked == null ? other._blocked != null : !this._blocked.equals(other._blocked)) {
                return false;
            }
            if (this._linkDown == null ? other._linkDown != null : !this._linkDown.equals(other._linkDown)) {
                return false;
            }
            if (this._live == null ? other._live != null : !this._live.equals(other._live)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("State [_blocked=");
            builder.append(this._blocked);
            builder.append(", _linkDown=");
            builder.append(this._linkDown);
            builder.append(", _live=");
            builder.append(this._live);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

