/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.address.address;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.address.address.Ipv6;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class Ipv6Builder {
    private Ipv6Prefix _ipv6Address;
    private Map<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>();

    public Ipv6Prefix getIpv6Address() {
        return this._ipv6Address;
    }

    public <E extends Augmentation<Ipv6>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv6Builder setIpv6Address(Ipv6Prefix value) {
        this._ipv6Address = value;
        return this;
    }

    public Ipv6Builder addAugmentation(Class<? extends Augmentation<Ipv6>> augmentationType, Augmentation<Ipv6> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ipv6 build() {
        return new Ipv6Impl(this);
    }

    private static final class Ipv6Impl
    implements Ipv6 {
        private final Ipv6Prefix _ipv6Address;
        private Map<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>> augmentation = new HashMap<Class<? extends Augmentation<Ipv6>>, Augmentation<Ipv6>>();

        public Class<Ipv6> getImplementedInterface() {
            return Ipv6.class;
        }

        private Ipv6Impl(Ipv6Builder builder) {
            this._ipv6Address = builder.getIpv6Address();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Ipv6Prefix getIpv6Address() {
            return this._ipv6Address;
        }

        public <E extends Augmentation<Ipv6>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ipv6Address == null ? 0 : this._ipv6Address.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ipv6Impl other = (Ipv6Impl)obj;
            if (this._ipv6Address == null ? other._ipv6Address != null : !this._ipv6Address.equals((Object)other._ipv6Address)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Ipv6 [_ipv6Address=");
            builder.append(this._ipv6Address);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

