/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.address.address;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.address.address.Ipv4;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class Ipv4Builder {
    private Ipv4Prefix _ipv4Address;
    private Map<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> augmentation = new HashMap<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>>();

    public Ipv4Prefix getIpv4Address() {
        return this._ipv4Address;
    }

    public <E extends Augmentation<Ipv4>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public Ipv4Builder setIpv4Address(Ipv4Prefix value) {
        this._ipv4Address = value;
        return this;
    }

    public Ipv4Builder addAugmentation(Class<? extends Augmentation<Ipv4>> augmentationType, Augmentation<Ipv4> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Ipv4 build() {
        return new Ipv4Impl(this);
    }

    private static final class Ipv4Impl
    implements Ipv4 {
        private final Ipv4Prefix _ipv4Address;
        private Map<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>> augmentation = new HashMap<Class<? extends Augmentation<Ipv4>>, Augmentation<Ipv4>>();

        public Class<Ipv4> getImplementedInterface() {
            return Ipv4.class;
        }

        private Ipv4Impl(Ipv4Builder builder) {
            this._ipv4Address = builder.getIpv4Address();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Ipv4Prefix getIpv4Address() {
            return this._ipv4Address;
        }

        public <E extends Augmentation<Ipv4>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._ipv4Address == null ? 0 : this._ipv4Address.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Ipv4Impl other = (Ipv4Impl)obj;
            if (this._ipv4Address == null ? other._ipv4Address != null : !this._ipv4Address.equals((Object)other._ipv4Address)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Ipv4 [_ipv4Address=");
            builder.append(this._ipv4Address);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

