/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.push.vlan.action._case;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.VlanCfi;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.push.vlan.action._case.PushVlanAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.l2.types.rev130827.VlanId;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class PushVlanActionBuilder {
    private VlanCfi _cfi;
    private Integer _ethernetType;
    private Integer _pcp;
    private Integer _tag;
    private VlanId _vlanId;
    private Map<Class<? extends Augmentation<PushVlanAction>>, Augmentation<PushVlanAction>> augmentation = new HashMap<Class<? extends Augmentation<PushVlanAction>>, Augmentation<PushVlanAction>>();

    public VlanCfi getCfi() {
        return this._cfi;
    }

    public Integer getEthernetType() {
        return this._ethernetType;
    }

    public Integer getPcp() {
        return this._pcp;
    }

    public Integer getTag() {
        return this._tag;
    }

    public VlanId getVlanId() {
        return this._vlanId;
    }

    public <E extends Augmentation<PushVlanAction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PushVlanActionBuilder setCfi(VlanCfi value) {
        this._cfi = value;
        return this;
    }

    public PushVlanActionBuilder setEthernetType(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._ethernetType = value;
        return this;
    }

    public PushVlanActionBuilder setPcp(Integer value) {
        this._pcp = value;
        return this;
    }

    public PushVlanActionBuilder setTag(Integer value) {
        this._tag = value;
        return this;
    }

    public PushVlanActionBuilder setVlanId(VlanId value) {
        this._vlanId = value;
        return this;
    }

    public PushVlanActionBuilder addAugmentation(Class<? extends Augmentation<PushVlanAction>> augmentationType, Augmentation<PushVlanAction> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PushVlanAction build() {
        return new PushVlanActionImpl(this);
    }

    private static final class PushVlanActionImpl
    implements PushVlanAction {
        private final VlanCfi _cfi;
        private final Integer _ethernetType;
        private final Integer _pcp;
        private final Integer _tag;
        private final VlanId _vlanId;
        private Map<Class<? extends Augmentation<PushVlanAction>>, Augmentation<PushVlanAction>> augmentation = new HashMap<Class<? extends Augmentation<PushVlanAction>>, Augmentation<PushVlanAction>>();

        public Class<PushVlanAction> getImplementedInterface() {
            return PushVlanAction.class;
        }

        private PushVlanActionImpl(PushVlanActionBuilder builder) {
            this._cfi = builder.getCfi();
            this._ethernetType = builder.getEthernetType();
            this._pcp = builder.getPcp();
            this._tag = builder.getTag();
            this._vlanId = builder.getVlanId();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public VlanCfi getCfi() {
            return this._cfi;
        }

        @Override
        public Integer getEthernetType() {
            return this._ethernetType;
        }

        @Override
        public Integer getPcp() {
            return this._pcp;
        }

        @Override
        public Integer getTag() {
            return this._tag;
        }

        @Override
        public VlanId getVlanId() {
            return this._vlanId;
        }

        public <E extends Augmentation<PushVlanAction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._cfi == null ? 0 : this._cfi.hashCode());
            result = 31 * result + (this._ethernetType == null ? 0 : this._ethernetType.hashCode());
            result = 31 * result + (this._pcp == null ? 0 : this._pcp.hashCode());
            result = 31 * result + (this._tag == null ? 0 : this._tag.hashCode());
            result = 31 * result + (this._vlanId == null ? 0 : this._vlanId.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PushVlanActionImpl other = (PushVlanActionImpl)obj;
            if (this._cfi == null ? other._cfi != null : !this._cfi.equals(other._cfi)) {
                return false;
            }
            if (this._ethernetType == null ? other._ethernetType != null : !this._ethernetType.equals(other._ethernetType)) {
                return false;
            }
            if (this._pcp == null ? other._pcp != null : !this._pcp.equals(other._pcp)) {
                return false;
            }
            if (this._tag == null ? other._tag != null : !this._tag.equals(other._tag)) {
                return false;
            }
            if (this._vlanId == null ? other._vlanId != null : !this._vlanId.equals((Object)other._vlanId)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PushVlanAction [_cfi=");
            builder.append(this._cfi);
            builder.append(", _ethernetType=");
            builder.append(this._ethernetType);
            builder.append(", _pcp=");
            builder.append(this._pcp);
            builder.append(", _tag=");
            builder.append(this._tag);
            builder.append(", _vlanId=");
            builder.append(this._vlanId);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

