/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.output.action._case;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.output.action._case.OutputAction;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class OutputActionBuilder {
    private Integer _maxLength;
    private Uri _outputNodeConnector;
    private Map<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>> augmentation = new HashMap<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>>();

    public Integer getMaxLength() {
        return this._maxLength;
    }

    public Uri getOutputNodeConnector() {
        return this._outputNodeConnector;
    }

    public <E extends Augmentation<OutputAction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public OutputActionBuilder setMaxLength(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxLength = value;
        return this;
    }

    public OutputActionBuilder setOutputNodeConnector(Uri value) {
        this._outputNodeConnector = value;
        return this;
    }

    public OutputActionBuilder addAugmentation(Class<? extends Augmentation<OutputAction>> augmentationType, Augmentation<OutputAction> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public OutputAction build() {
        return new OutputActionImpl(this);
    }

    private static final class OutputActionImpl
    implements OutputAction {
        private final Integer _maxLength;
        private final Uri _outputNodeConnector;
        private Map<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>> augmentation = new HashMap<Class<? extends Augmentation<OutputAction>>, Augmentation<OutputAction>>();

        public Class<OutputAction> getImplementedInterface() {
            return OutputAction.class;
        }

        private OutputActionImpl(OutputActionBuilder builder) {
            this._maxLength = builder.getMaxLength();
            this._outputNodeConnector = builder.getOutputNodeConnector();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Integer getMaxLength() {
            return this._maxLength;
        }

        @Override
        public Uri getOutputNodeConnector() {
            return this._outputNodeConnector;
        }

        public <E extends Augmentation<OutputAction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._maxLength == null ? 0 : this._maxLength.hashCode());
            result = 31 * result + (this._outputNodeConnector == null ? 0 : this._outputNodeConnector.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OutputActionImpl other = (OutputActionImpl)obj;
            if (this._maxLength == null ? other._maxLength != null : !this._maxLength.equals(other._maxLength)) {
                return false;
            }
            if (this._outputNodeConnector == null ? other._outputNodeConnector != null : !this._outputNodeConnector.equals((Object)other._outputNodeConnector)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("OutputAction [_maxLength=");
            builder.append(this._maxLength);
            builder.append(", _outputNodeConnector=");
            builder.append(this._outputNodeConnector);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

