/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.group.action._case;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.group.action._case.GroupAction;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class GroupActionBuilder {
    private String _group;
    private Long _groupId;
    private Map<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>> augmentation = new HashMap<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>>();

    public String getGroup() {
        return this._group;
    }

    public Long getGroupId() {
        return this._groupId;
    }

    public <E extends Augmentation<GroupAction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupActionBuilder setGroup(String value) {
        this._group = value;
        return this;
    }

    public GroupActionBuilder setGroupId(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._groupId = value;
        return this;
    }

    public GroupActionBuilder addAugmentation(Class<? extends Augmentation<GroupAction>> augmentationType, Augmentation<GroupAction> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupAction build() {
        return new GroupActionImpl(this);
    }

    private static final class GroupActionImpl
    implements GroupAction {
        private final String _group;
        private final Long _groupId;
        private Map<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>> augmentation = new HashMap<Class<? extends Augmentation<GroupAction>>, Augmentation<GroupAction>>();

        public Class<GroupAction> getImplementedInterface() {
            return GroupAction.class;
        }

        private GroupActionImpl(GroupActionBuilder builder) {
            this._group = builder.getGroup();
            this._groupId = builder.getGroupId();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public String getGroup() {
            return this._group;
        }

        @Override
        public Long getGroupId() {
            return this._groupId;
        }

        public <E extends Augmentation<GroupAction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._group == null ? 0 : this._group.hashCode());
            result = 31 * result + (this._groupId == null ? 0 : this._groupId.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupActionImpl other = (GroupActionImpl)obj;
            if (this._group == null ? other._group != null : !this._group.equals(other._group)) {
                return false;
            }
            if (this._groupId == null ? other._groupId != null : !this._groupId.equals(other._groupId)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GroupAction [_group=");
            builder.append(this._group);
            builder.append(", _groupId=");
            builder.append(this._groupId);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

