/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.controller.action._case;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.action.controller.action._case.ControllerAction;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ControllerActionBuilder {
    private Integer _maxLength;
    private Map<Class<? extends Augmentation<ControllerAction>>, Augmentation<ControllerAction>> augmentation = new HashMap<Class<? extends Augmentation<ControllerAction>>, Augmentation<ControllerAction>>();

    public Integer getMaxLength() {
        return this._maxLength;
    }

    public <E extends Augmentation<ControllerAction>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ControllerActionBuilder setMaxLength(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxLength = value;
        return this;
    }

    public ControllerActionBuilder addAugmentation(Class<? extends Augmentation<ControllerAction>> augmentationType, Augmentation<ControllerAction> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ControllerAction build() {
        return new ControllerActionImpl(this);
    }

    private static final class ControllerActionImpl
    implements ControllerAction {
        private final Integer _maxLength;
        private Map<Class<? extends Augmentation<ControllerAction>>, Augmentation<ControllerAction>> augmentation = new HashMap<Class<? extends Augmentation<ControllerAction>>, Augmentation<ControllerAction>>();

        public Class<ControllerAction> getImplementedInterface() {
            return ControllerAction.class;
        }

        private ControllerActionImpl(ControllerActionBuilder builder) {
            this._maxLength = builder.getMaxLength();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Integer getMaxLength() {
            return this._maxLength;
        }

        public <E extends Augmentation<ControllerAction>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._maxLength == null ? 0 : this._maxLength.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ControllerActionImpl other = (ControllerActionImpl)obj;
            if (this._maxLength == null ? other._maxLength != null : !this._maxLength.equals(other._maxLength)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ControllerAction [_maxLength=");
            builder.append(this._maxLength);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

