/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112;

import com.google.common.collect.Range;
import java.beans.ConstructorProperties;
import java.util.ArrayList;

public class VlanCfi {
    private final Integer _value;

    @ConstructorProperties(value={"value"})
    public VlanCfi(Integer _value) {
        if (_value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("-2147483648"), (Comparable)new Integer("2147483647")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)_value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", _value, rangeConstraints));
            }
        }
        this._value = _value;
    }

    public VlanCfi(VlanCfi source) {
        this._value = source._value;
    }

    public static VlanCfi getDefaultInstance(String defaultValue) {
        return new VlanCfi(new Integer(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VlanCfi other = (VlanCfi)obj;
        return !(this._value == null ? other._value != null : !this._value.equals(other._value));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("VlanCfi [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(this._value);
        }
        return builder.append(']').toString();
    }
}

