/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl.util;

import com.google.common.collect.Maps;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.util.messages.SendErrorExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeserializerExceptionHandler
implements ChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(DeserializerExceptionHandler.class);

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.warn("An exception occured during message handling", cause);
        this.handleDeserializerException(ctx, cause);
    }

    private void handleDeserializerException(ChannelHandlerContext ctx, Throwable cause) {
        HashMap info = Maps.newHashMap();
        info.put("cause", cause.getMessage());
        NetconfDocumentedException ex = new NetconfDocumentedException(cause.getMessage(), NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.malformed_message, NetconfDocumentedException.ErrorSeverity.error, (Map)info);
        SendErrorExceptionUtil.sendErrorMessage((Channel)ctx.channel(), (NetconfDocumentedException)ex);
    }
}

