/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl.util;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.controller.netconf.impl.NetconfServerSessionNegotiator;

public class AdditionalHeaderUtil {
    private static final Pattern pattern = Pattern.compile("\\[(?<username>[^;]+);(?<address>[0-9\\.]+)[:/](?<port>[0-9]+);(?<transport>[a-z]+)[^\\]]+\\]");
    private static final Pattern customHeaderPattern = Pattern.compile("\\[(?<username>[^;]+);(?<address>[0-9\\.]+)[:/](?<port>[0-9]+);(?<transport>[a-z]+);(?<sessionIdentifier>[a-z]+)[^\\]]+\\]");

    public static NetconfServerSessionNegotiator.AdditionalHeader fromString(String additionalHeader) {
        additionalHeader = additionalHeader.trim();
        Matcher matcher = pattern.matcher(additionalHeader);
        Matcher matcher2 = customHeaderPattern.matcher(additionalHeader);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Additional header in wrong format %s, expected %s", (Object[])new Object[]{additionalHeader, pattern});
        String username = matcher.group("username");
        String address = matcher.group("address");
        String transport = matcher.group("transport");
        String sessionIdentifier = "client";
        if (matcher2.matches()) {
            sessionIdentifier = matcher2.group("sessionIdentifier");
        }
        return new NetconfServerSessionNegotiator.AdditionalHeader(username, address, transport, sessionIdentifier);
    }
}

