/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl.osgi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationService;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfOperationServiceSnapshot
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(NetconfOperationServiceSnapshot.class);
    private final Set<NetconfOperationService> services;
    private final String netconfSessionIdForReporting;

    public NetconfOperationServiceSnapshot(Set<NetconfOperationServiceFactory> factories, long sessionId) {
        HashSet<NetconfOperationService> services = new HashSet<NetconfOperationService>();
        this.netconfSessionIdForReporting = NetconfOperationServiceSnapshot.getNetconfSessionIdForReporting(sessionId);
        for (NetconfOperationServiceFactory factory : factories) {
            services.add(factory.createService(sessionId, this.netconfSessionIdForReporting));
        }
        this.services = Collections.unmodifiableSet(services);
    }

    private static String getNetconfSessionIdForReporting(long sessionId) {
        return "netconf session id " + sessionId;
    }

    public String getNetconfSessionIdForReporting() {
        return this.netconfSessionIdForReporting;
    }

    public Set<NetconfOperationService> getServices() {
        return this.services;
    }

    @Override
    public void close() {
        RuntimeException firstException = null;
        for (NetconfOperationService service : this.services) {
            try {
                service.close();
            }
            catch (RuntimeException e) {
                logger.warn("Got exception while closing {}", (Object)service, (Object)e);
                if (firstException == null) {
                    firstException = e;
                    continue;
                }
                firstException.addSuppressed(e);
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public String toString() {
        return "NetconfOperationServiceSnapshot{" + this.netconfSessionIdForReporting + '}';
    }
}

