/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl.osgi;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfOperationRouter;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.impl.DefaultCommitNotificationProducer;
import org.opendaylight.controller.netconf.impl.mapping.CapabilityProvider;
import org.opendaylight.controller.netconf.impl.mapping.operations.DefaultCloseSession;
import org.opendaylight.controller.netconf.impl.mapping.operations.DefaultCommit;
import org.opendaylight.controller.netconf.impl.mapping.operations.DefaultGetSchema;
import org.opendaylight.controller.netconf.impl.mapping.operations.DefaultStartExi;
import org.opendaylight.controller.netconf.impl.mapping.operations.DefaultStopExi;
import org.opendaylight.controller.netconf.impl.osgi.NetconfOperationServiceSnapshot;
import org.opendaylight.controller.netconf.mapping.api.DefaultNetconfOperation;
import org.opendaylight.controller.netconf.mapping.api.HandlingPriority;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperation;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationFilter;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationFilterChain;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationService;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class NetconfOperationRouterImpl
implements NetconfOperationRouter {
    private static final Logger logger = LoggerFactory.getLogger(NetconfOperationRouterImpl.class);
    private final NetconfOperationServiceSnapshot netconfOperationServiceSnapshot;
    private final Set<NetconfOperation> allNetconfOperations;
    private final TreeSet<NetconfOperationFilter> allSortedFilters;
    private final CapabilityProvider capabilityProvider;

    public NetconfOperationRouterImpl(NetconfOperationServiceSnapshot netconfOperationServiceSnapshot, CapabilityProvider capabilityProvider, DefaultCommitNotificationProducer commitNotifier) {
        this.netconfOperationServiceSnapshot = netconfOperationServiceSnapshot;
        this.capabilityProvider = capabilityProvider;
        HashSet defaultNetconfOperations = Sets.newHashSet();
        defaultNetconfOperations.add(new DefaultGetSchema(capabilityProvider, netconfOperationServiceSnapshot.getNetconfSessionIdForReporting()));
        defaultNetconfOperations.add(new DefaultCloseSession(netconfOperationServiceSnapshot.getNetconfSessionIdForReporting()));
        defaultNetconfOperations.add(new DefaultStartExi(netconfOperationServiceSnapshot.getNetconfSessionIdForReporting()));
        defaultNetconfOperations.add(new DefaultStopExi(netconfOperationServiceSnapshot.getNetconfSessionIdForReporting()));
        this.allNetconfOperations = NetconfOperationRouterImpl.getAllNetconfOperations(defaultNetconfOperations, netconfOperationServiceSnapshot);
        DefaultCommit defaultCommit = new DefaultCommit(commitNotifier, capabilityProvider, netconfOperationServiceSnapshot.getNetconfSessionIdForReporting());
        HashSet defaultFilters = Sets.newHashSet((Object[])new NetconfOperationFilter[]{defaultCommit});
        this.allSortedFilters = NetconfOperationRouterImpl.getAllNetconfFilters(defaultFilters, netconfOperationServiceSnapshot);
    }

    private static Set<NetconfOperation> getAllNetconfOperations(Set<NetconfOperation> defaultNetconfOperations, NetconfOperationServiceSnapshot netconfOperationServiceSnapshot) {
        HashSet<NetconfOperation> result = new HashSet<NetconfOperation>();
        result.addAll(defaultNetconfOperations);
        for (NetconfOperationService netconfOperationService : netconfOperationServiceSnapshot.getServices()) {
            Set netOpsFromService = netconfOperationService.getNetconfOperations();
            for (NetconfOperation netconfOperation : netOpsFromService) {
                Preconditions.checkState((!result.contains(netconfOperation) ? 1 : 0) != 0, (String)"Netconf operation %s already present", (Object[])new Object[]{netconfOperation});
                result.add(netconfOperation);
            }
        }
        return Collections.unmodifiableSet(result);
    }

    private static TreeSet<NetconfOperationFilter> getAllNetconfFilters(Set<NetconfOperationFilter> defaultFilters, NetconfOperationServiceSnapshot netconfOperationServiceSnapshot) {
        TreeSet<NetconfOperationFilter> result = new TreeSet<NetconfOperationFilter>(defaultFilters);
        for (NetconfOperationService netconfOperationService : netconfOperationServiceSnapshot.getServices()) {
            Set filtersFromService = netconfOperationService.getFilters();
            for (NetconfOperationFilter filter : filtersFromService) {
                Preconditions.checkState((!result.contains(filter) ? 1 : 0) != 0, (String)"Filter %s already present, all filters so far: %s", (Object[])new Object[]{filter, result});
                result.add(filter);
            }
        }
        return result;
    }

    public CapabilityProvider getCapabilityProvider() {
        return this.capabilityProvider;
    }

    public synchronized Document onNetconfMessage(Document message, NetconfSession session) throws NetconfDocumentedException {
        NetconfOperationExecution netconfOperationExecution;
        String messageAsString = XmlUtil.toString((Document)message);
        try {
            netconfOperationExecution = this.getNetconfOperationWithHighestPriority(message, session);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            logger.warn("Unable to handle rpc {} on session {}", new Object[]{messageAsString, session, e});
            String errorMessage = String.format("Unable to handle rpc %s on session %s", messageAsString, session);
            HashMap errorInfo = Maps.newHashMap();
            NetconfDocumentedException.ErrorTag tag = null;
            if (e instanceof IllegalArgumentException) {
                errorInfo.put(NetconfDocumentedException.ErrorTag.operation_not_supported.toString(), e.getMessage());
                tag = NetconfDocumentedException.ErrorTag.operation_not_supported;
            } else if (e instanceof IllegalStateException) {
                errorInfo.put(NetconfDocumentedException.ErrorTag.operation_failed.toString(), e.getMessage());
                tag = NetconfDocumentedException.ErrorTag.operation_failed;
            }
            throw new NetconfDocumentedException(errorMessage, (Exception)e, NetconfDocumentedException.ErrorType.application, tag, NetconfDocumentedException.ErrorSeverity.error, (Map)errorInfo);
        }
        catch (RuntimeException e) {
            throw this.handleUnexpectedEx("Unexpected exception during netconf operation sort", e);
        }
        try {
            return this.executeOperationWithHighestPriority(message, netconfOperationExecution, messageAsString);
        }
        catch (RuntimeException e) {
            throw this.handleUnexpectedEx("Unexpected exception during netconf operation execution", e);
        }
    }

    private NetconfDocumentedException handleUnexpectedEx(String s, Exception e) throws NetconfDocumentedException {
        logger.error(s, (Throwable)e);
        HashMap info = Maps.newHashMap();
        info.put(NetconfDocumentedException.ErrorSeverity.error.toString(), e.toString());
        return new NetconfDocumentedException("Unexpected error", NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, (Map)info);
    }

    private Document executeOperationWithHighestPriority(Document message, NetconfOperationExecution netconfOperationExecution, String messageAsString) throws NetconfDocumentedException {
        logger.debug("Forwarding netconf message {} to {}", (Object)messageAsString, (Object)netconfOperationExecution.operationWithHighestPriority);
        LinkedList<Object> chain = new LinkedList<Object>();
        chain.push(netconfOperationExecution);
        Iterator<NetconfOperationFilter> it = this.allSortedFilters.descendingIterator();
        while (it.hasNext()) {
            final NetconfOperationFilter filter = it.next();
            final NetconfOperationFilterChain prevItem = (NetconfOperationFilterChain)chain.getFirst();
            NetconfOperationFilterChain currentItem = new NetconfOperationFilterChain(){

                public Document execute(Document message, NetconfOperationRouter operationRouter) throws NetconfDocumentedException {
                    logger.trace("Entering {}", (Object)filter);
                    return filter.doFilter(message, operationRouter, prevItem);
                }
            };
            chain.push(currentItem);
        }
        return ((NetconfOperationFilterChain)chain.getFirst()).execute(message, (NetconfOperationRouter)this);
    }

    private NetconfOperationExecution getNetconfOperationWithHighestPriority(Document message, NetconfSession session) {
        TreeMap<HandlingPriority, Set<NetconfOperation>> sortedPriority = this.getSortedNetconfOperationsWithCanHandle(message, session);
        Preconditions.checkArgument((!sortedPriority.isEmpty() ? 1 : 0) != 0, (String)"No %s available to handle message %s", (Object[])new Object[]{NetconfOperation.class.getName(), XmlUtil.toString((Document)message)});
        HandlingPriority highestFoundPriority = sortedPriority.lastKey();
        int netconfOperationsWithHighestPriority = sortedPriority.get(highestFoundPriority).size();
        Preconditions.checkState((netconfOperationsWithHighestPriority == 1 ? 1 : 0) != 0, (String)"Multiple %s available to handle message %s", (Object[])new Object[]{NetconfOperation.class.getName(), message});
        return new NetconfOperationExecution(sortedPriority, highestFoundPriority);
    }

    private TreeMap<HandlingPriority, Set<NetconfOperation>> getSortedNetconfOperationsWithCanHandle(Document message, NetconfSession session) {
        TreeMap sortedPriority = Maps.newTreeMap();
        for (NetconfOperation netconfOperation : this.allNetconfOperations) {
            HandlingPriority handlingPriority = netconfOperation.canHandle(message);
            if (netconfOperation instanceof DefaultNetconfOperation) {
                ((DefaultNetconfOperation)netconfOperation).setNetconfSession(session);
            }
            if (handlingPriority.equals((Object)HandlingPriority.CANNOT_HANDLE)) continue;
            Set<NetconfOperation> netconfOperations = (Set<NetconfOperation>)sortedPriority.get(handlingPriority);
            netconfOperations = this.checkIfNoOperationsOnPriority(sortedPriority, handlingPriority, netconfOperations);
            netconfOperations.add(netconfOperation);
        }
        return sortedPriority;
    }

    private Set<NetconfOperation> checkIfNoOperationsOnPriority(TreeMap<HandlingPriority, Set<NetconfOperation>> sortedPriority, HandlingPriority handlingPriority, Set<NetconfOperation> netconfOperations) {
        if (netconfOperations == null) {
            netconfOperations = Sets.newHashSet();
            sortedPriority.put(handlingPriority, netconfOperations);
        }
        return netconfOperations;
    }

    public void close() {
        this.netconfOperationServiceSnapshot.close();
    }

    public String toString() {
        return "NetconfOperationRouterImpl{netconfOperationServiceSnapshot=" + this.netconfOperationServiceSnapshot + '}';
    }

    private class NetconfOperationExecution
    implements NetconfOperationFilterChain {
        private final NetconfOperation operationWithHighestPriority;

        private NetconfOperationExecution(NetconfOperation operationWithHighestPriority) {
            this.operationWithHighestPriority = operationWithHighestPriority;
        }

        public NetconfOperationExecution(TreeMap<HandlingPriority, Set<NetconfOperation>> sortedPriority, HandlingPriority highestFoundPriority) {
            this.operationWithHighestPriority = sortedPriority.get(highestFoundPriority).iterator().next();
            sortedPriority.remove(highestFoundPriority);
        }

        public Document execute(Document message, NetconfOperationRouter router) throws NetconfDocumentedException {
            return this.operationWithHighestPriority.handle(message, router);
        }
    }
}

