/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl.osgi;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.util.internal.ConcurrentSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.opendaylight.controller.netconf.api.monitoring.NetconfManagementSession;
import org.opendaylight.controller.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.controller.netconf.impl.osgi.NetconfOperationServiceFactoryListener;
import org.opendaylight.controller.netconf.impl.osgi.NetconfOperationServiceSnapshot;
import org.opendaylight.controller.netconf.impl.osgi.SessionMonitoringService;
import org.opendaylight.controller.netconf.mapping.api.Capability;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationService;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Yang;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.SchemasBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.SessionsBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.SchemaBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.SchemaKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfMonitoringServiceImpl
implements NetconfMonitoringService,
SessionMonitoringService {
    private static final Logger logger = LoggerFactory.getLogger(NetconfMonitoringServiceImpl.class);
    private final Set<NetconfManagementSession> sessions = new ConcurrentSet();
    private final NetconfOperationServiceFactoryListener factoriesListener;

    public NetconfMonitoringServiceImpl(NetconfOperationServiceFactoryListener factoriesListener) {
        this.factoriesListener = factoriesListener;
    }

    @Override
    public void onSessionUp(NetconfManagementSession session) {
        logger.debug("Session {} up", (Object)session);
        Preconditions.checkState((!this.sessions.contains(session) ? 1 : 0) != 0, (String)"Session %s was already added", (Object[])new Object[]{session});
        this.sessions.add(session);
    }

    @Override
    public void onSessionDown(NetconfManagementSession session) {
        logger.debug("Session {} down", (Object)session);
        Preconditions.checkState((this.sessions.contains(session) ? 1 : 0) != 0, (String)"Session %s not present", (Object[])new Object[]{session});
        this.sessions.remove(session);
    }

    public Sessions getSessions() {
        return new SessionsBuilder().setSession(this.transformSessions(this.sessions)).build();
    }

    public Schemas getSchemas() {
        return this.transformSchemas(this.factoriesListener.getSnapshot(0L));
    }

    private Schemas transformSchemas(NetconfOperationServiceSnapshot snapshot) {
        HashSet caps = Sets.newHashSet();
        ArrayList schemas = Lists.newArrayList();
        for (NetconfOperationService netconfOperationService : snapshot.getServices()) {
            caps.addAll(netconfOperationService.getCapabilities());
        }
        for (Capability cap : caps) {
            SchemaBuilder builder = new SchemaBuilder();
            if (!cap.getCapabilitySchema().isPresent()) continue;
            Preconditions.checkState((boolean)cap.getModuleNamespace().isPresent());
            builder.setNamespace(new Uri((String)cap.getModuleNamespace().get()));
            Preconditions.checkState((boolean)cap.getRevision().isPresent());
            String version = (String)cap.getRevision().get();
            builder.setVersion(version);
            Preconditions.checkState((boolean)cap.getModuleName().isPresent());
            String identifier = (String)cap.getModuleName().get();
            builder.setIdentifier(identifier);
            builder.setFormat(Yang.class);
            builder.setLocation(this.transformLocations((List)cap.getLocation().or(Collections.emptyList())));
            builder.setKey(new SchemaKey(Yang.class, identifier, version));
            schemas.add(builder.build());
        }
        return new SchemasBuilder().setSchema((List)schemas).build();
    }

    private List<Schema.Location> transformLocations(List<String> locations) {
        ArrayList monitoringLocations = Lists.newArrayList();
        monitoringLocations.add(new Schema.Location(Schema.Location.Enumeration.NETCONF));
        for (String location : locations) {
            monitoringLocations.add(new Schema.Location(new Uri(location)));
        }
        return monitoringLocations;
    }

    private List<Session> transformSessions(Set<NetconfManagementSession> sessions) {
        return Lists.newArrayList((Iterable)Collections2.transform(sessions, (Function)new Function<NetconfManagementSession, Session>(){

            @Nullable
            public Session apply(@Nullable NetconfManagementSession input) {
                return input.toManagementSession();
            }
        }));
    }
}

