/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl.osgi;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import org.opendaylight.controller.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.controller.netconf.impl.DefaultCommitNotificationProducer;
import org.opendaylight.controller.netconf.impl.NetconfServerDispatcher;
import org.opendaylight.controller.netconf.impl.NetconfServerSessionListenerFactory;
import org.opendaylight.controller.netconf.impl.NetconfServerSessionNegotiatorFactory;
import org.opendaylight.controller.netconf.impl.SessionIdProvider;
import org.opendaylight.controller.netconf.impl.osgi.NetconfMonitoringServiceImpl;
import org.opendaylight.controller.netconf.impl.osgi.NetconfOperationServiceFactoryListenerImpl;
import org.opendaylight.controller.netconf.impl.osgi.NetconfOperationServiceFactoryTracker;
import org.opendaylight.controller.netconf.util.osgi.NetconfConfigUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfImplActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(NetconfImplActivator.class);
    private NetconfOperationServiceFactoryTracker factoriesTracker;
    private DefaultCommitNotificationProducer commitNot;
    private NetconfServerDispatcher dispatch;
    private NioEventLoopGroup eventLoopGroup;
    private HashedWheelTimer timer;
    private ServiceRegistration<NetconfMonitoringService> regMonitoring;

    public void start(BundleContext context) throws Exception {
        InetSocketAddress address = NetconfConfigUtil.extractTCPNetconfAddress((BundleContext)context, (String)"TCP is not configured, netconf not available.", (boolean)false);
        NetconfOperationServiceFactoryListenerImpl factoriesListener = new NetconfOperationServiceFactoryListenerImpl();
        this.startOperationServiceFactoryTracker(context, factoriesListener);
        SessionIdProvider idProvider = new SessionIdProvider();
        this.timer = new HashedWheelTimer();
        NetconfServerSessionNegotiatorFactory serverNegotiatorFactory = new NetconfServerSessionNegotiatorFactory((Timer)this.timer, factoriesListener, idProvider);
        this.commitNot = new DefaultCommitNotificationProducer(ManagementFactory.getPlatformMBeanServer());
        NetconfMonitoringServiceImpl monitoringService = this.startMonitoringService(context, factoriesListener);
        NetconfServerSessionListenerFactory listenerFactory = new NetconfServerSessionListenerFactory(factoriesListener, this.commitNot, idProvider, monitoringService);
        this.eventLoopGroup = new NioEventLoopGroup();
        NetconfServerDispatcher.ServerChannelInitializer serverChannelInitializer = new NetconfServerDispatcher.ServerChannelInitializer(serverNegotiatorFactory, listenerFactory);
        this.dispatch = new NetconfServerDispatcher(serverChannelInitializer, (EventLoopGroup)this.eventLoopGroup, (EventLoopGroup)this.eventLoopGroup);
        logger.info("Starting TCP netconf server at {}", (Object)address);
        this.dispatch.createServer(address);
    }

    private void startOperationServiceFactoryTracker(BundleContext context, NetconfOperationServiceFactoryListenerImpl factoriesListener) {
        this.factoriesTracker = new NetconfOperationServiceFactoryTracker(context, factoriesListener);
        this.factoriesTracker.open();
    }

    private NetconfMonitoringServiceImpl startMonitoringService(BundleContext context, NetconfOperationServiceFactoryListenerImpl factoriesListener) {
        NetconfMonitoringServiceImpl netconfMonitoringServiceImpl = new NetconfMonitoringServiceImpl(factoriesListener);
        Hashtable dic = new Hashtable();
        this.regMonitoring = context.registerService(NetconfMonitoringService.class, (Object)netconfMonitoringServiceImpl, dic);
        return netconfMonitoringServiceImpl;
    }

    public void stop(BundleContext context) throws Exception {
        logger.info("Shutting down netconf because YangStoreService service was removed");
        this.commitNot.close();
        this.eventLoopGroup.shutdownGracefully();
        this.timer.stop();
        this.regMonitoring.unregister();
        this.factoriesTracker.close();
    }
}

