/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl.mapping.operations;

import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfOperationRouter;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.impl.mapping.operations.DefaultStartExi;
import org.opendaylight.controller.netconf.mapping.api.DefaultNetconfOperation;
import org.opendaylight.controller.netconf.mapping.api.HandlingPriority;
import org.opendaylight.controller.netconf.util.mapping.AbstractNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultStopExi
extends AbstractNetconfOperation
implements DefaultNetconfOperation {
    public static final String STOP_EXI = "stop-exi";
    private NetconfSession netconfSession;
    private static final Logger logger = LoggerFactory.getLogger(DefaultStartExi.class);

    public DefaultStopExi(String netconfSessionIdForReporting) {
        super(netconfSessionIdForReporting);
    }

    protected HandlingPriority canHandle(String operationName, String netconfOperationNamespace) {
        if (!operationName.equals(STOP_EXI)) {
            return HandlingPriority.CANNOT_HANDLE;
        }
        if (!netconfOperationNamespace.equals("urn:ietf:params:xml:ns:netconf:base:1.0")) {
            return HandlingPriority.CANNOT_HANDLE;
        }
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY;
    }

    protected Element handle(Document document, XmlElement operationElement, NetconfOperationRouter opRouter) throws NetconfDocumentedException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setNetconfSession(NetconfSession s) {
        this.netconfSession = s;
    }

    public NetconfSession getNetconfSession() {
        return this.netconfSession;
    }
}

