/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl.mapping.operations;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfOperationRouter;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.impl.mapping.CapabilityProvider;
import org.opendaylight.controller.netconf.mapping.api.DefaultNetconfOperation;
import org.opendaylight.controller.netconf.mapping.api.HandlingPriority;
import org.opendaylight.controller.netconf.util.mapping.AbstractNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DefaultGetSchema
extends AbstractNetconfOperation
implements DefaultNetconfOperation {
    private final CapabilityProvider cap;
    private NetconfSession netconfSession;
    private static final Logger logger = LoggerFactory.getLogger(DefaultGetSchema.class);
    public static final String GET_SCHEMA = "get-schema";
    public static final String IDENTIFIER = "identifier";
    public static final String VERSION = "version";

    public DefaultGetSchema(CapabilityProvider cap, String netconfSessionIdForReporting) {
        super(netconfSessionIdForReporting);
        this.cap = cap;
    }

    protected HandlingPriority canHandle(String netconfOperationName, String namespace) {
        if (!netconfOperationName.equals(GET_SCHEMA)) {
            return HandlingPriority.CANNOT_HANDLE;
        }
        if (!namespace.equals("urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring")) {
            return HandlingPriority.CANNOT_HANDLE;
        }
        return HandlingPriority.HANDLE_WITH_DEFAULT_PRIORITY;
    }

    protected Element handle(Document document, XmlElement xml, NetconfOperationRouter router) throws NetconfDocumentedException {
        String schema;
        GetSchemaEntry entry;
        try {
            entry = new GetSchemaEntry(xml);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Error parsing xml", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.bad_attribute.name(), e.getMessage());
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.bad_attribute, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        catch (IllegalStateException e) {
            logger.warn("Error parsing xml", (Throwable)e);
            HashMap<String, String> errorInfo = new HashMap<String, String>();
            errorInfo.put(NetconfDocumentedException.ErrorTag.bad_attribute.name(), e.getMessage());
            throw new NetconfDocumentedException(e.getMessage(), (Exception)e, NetconfDocumentedException.ErrorType.rpc, NetconfDocumentedException.ErrorTag.bad_attribute, NetconfDocumentedException.ErrorSeverity.error, errorInfo);
        }
        try {
            schema = this.cap.getSchemaForCapability(entry.identifier, (Optional<String>)entry.version);
        }
        catch (IllegalStateException e) {
            HashMap errorInfo = Maps.newHashMap();
            errorInfo.put(entry.identifier, e.getMessage());
            logger.warn("Rpc error: {}", (Object)NetconfDocumentedException.ErrorTag.operation_failed, (Object)e);
            throw new NetconfDocumentedException(e.getMessage(), NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, (Map)errorInfo);
        }
        Element getSchemaResult = XmlUtil.createTextElement((Document)document, (String)"data", (String)schema);
        XmlUtil.addNamespaceAttr((Element)getSchemaResult, (String)"urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring");
        logger.trace("{} operation successful", (Object)GET_SCHEMA);
        return getSchemaResult;
    }

    public void setNetconfSession(NetconfSession s) {
        this.netconfSession = s;
    }

    public NetconfSession getNetconfSession() {
        return this.netconfSession;
    }

    private static final class GetSchemaEntry {
        private final String identifier;
        private final Optional<String> version;

        GetSchemaEntry(XmlElement getSchemaElement) {
            getSchemaElement.checkName(DefaultGetSchema.GET_SCHEMA);
            getSchemaElement.checkNamespace("urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring");
            XmlElement identifierElement = getSchemaElement.getOnlyChildElementWithSameNamespace(DefaultGetSchema.IDENTIFIER);
            this.identifier = identifierElement.getTextContent();
            Optional versionElement = getSchemaElement.getOnlyChildElementWithSameNamespaceOptionally(DefaultGetSchema.VERSION);
            this.version = versionElement.isPresent() ? Optional.of((Object)((XmlElement)versionElement.get()).getTextContent()) : Optional.absent();
        }
    }
}

