/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl.mapping.operations;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfOperationRouter;
import org.opendaylight.controller.netconf.impl.DefaultCommitNotificationProducer;
import org.opendaylight.controller.netconf.impl.mapping.CapabilityProvider;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationFilter;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationFilterChain;
import org.opendaylight.controller.netconf.util.mapping.AbstractNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultCommit
implements NetconfOperationFilter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCommit.class);
    private static final String NOTIFY_ATTR = "notify";
    private final DefaultCommitNotificationProducer notificationProducer;
    private final CapabilityProvider cap;
    private final String netconfSessionIdForReporting;
    private final Document getConfigMessage;
    public static final String GET_CONFIG_CANDIDATE_XML_LOCATION = "/getConfig_candidate.xml";

    public DefaultCommit(DefaultCommitNotificationProducer notifier, CapabilityProvider cap, String netconfSessionIdForReporting) {
        this.notificationProducer = notifier;
        this.cap = cap;
        this.netconfSessionIdForReporting = netconfSessionIdForReporting;
        this.getConfigMessage = DefaultCommit.loadGetConfigMessage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document loadGetConfigMessage() {
        try (InputStream asStream = DefaultCommit.class.getResourceAsStream(GET_CONFIG_CANDIDATE_XML_LOCATION);){
            Document document = XmlUtil.readXmlToDocument((InputStream)asStream);
            return document;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load getConfig message for notifications from /getConfig_candidate.xml");
        }
    }

    public Document doFilter(Document message, NetconfOperationRouter operationRouter, NetconfOperationFilterChain filterChain) throws NetconfDocumentedException {
        AbstractNetconfOperation.OperationNameAndNamespace operationNameAndNamespace = new AbstractNetconfOperation.OperationNameAndNamespace(message);
        if (this.canHandle(operationNameAndNamespace)) {
            if (this.isCommitWithoutNotification(message)) {
                message = this.removePersisterAttributes(message);
                logger.debug("Skipping commit notification");
            } else {
                Document innerResult = filterChain.execute(message, operationRouter);
                Element cfgSnapshot = this.getConfigSnapshot(operationRouter);
                logger.debug("Config snapshot retrieved successfully {}", (Object)cfgSnapshot);
                this.notificationProducer.sendCommitNotification("ok", cfgSnapshot, this.cap.getCapabilities());
                return innerResult;
            }
        }
        return filterChain.execute(message, operationRouter);
    }

    public int getSortingOrder() {
        return 0;
    }

    public int compareTo(NetconfOperationFilter o) {
        return Integer.compare(this.getSortingOrder(), o.getSortingOrder());
    }

    private boolean canHandle(AbstractNetconfOperation.OperationNameAndNamespace operationNameAndNamespace) {
        if (!operationNameAndNamespace.getOperationName().equals("commit")) {
            return false;
        }
        return operationNameAndNamespace.getNamespace().equals("urn:ietf:params:xml:ns:netconf:base:1.0");
    }

    private Document removePersisterAttributes(Document message) {
        Element documentElement = message.getDocumentElement();
        documentElement.removeAttribute(NOTIFY_ATTR);
        return message;
    }

    private boolean isCommitWithoutNotification(Document message) {
        XmlElement xmlElement = XmlElement.fromDomElementWithExpected((Element)message.getDocumentElement(), (String)"rpc", (String)"urn:ietf:params:xml:ns:netconf:base:1.0");
        String attr = xmlElement.getAttribute(NOTIFY_ATTR);
        if (attr == null || attr.equals("")) {
            return false;
        }
        if (attr.equals(Boolean.toString(false))) {
            logger.debug("Commit operation received with notify=false attribute {}", (Object)message);
            return true;
        }
        return false;
    }

    private Element getConfigSnapshot(NetconfOperationRouter opRouter) throws NetconfDocumentedException {
        XmlElement dataElement;
        Document responseDocument = opRouter.onNetconfMessage(this.getConfigMessage, null);
        try {
            XmlElement xmlElement = XmlElement.fromDomElementWithExpected((Element)responseDocument.getDocumentElement(), (String)"rpc-reply", (String)"urn:ietf:params:xml:ns:netconf:base:1.0");
            dataElement = xmlElement.getOnlyChildElement("data");
        }
        catch (IllegalArgumentException e) {
            String msg = "Unexpected response from get-config operation";
            logger.warn("Unexpected response from get-config operation", (Throwable)e);
            HashMap info = Maps.newHashMap();
            info.put(NetconfDocumentedException.ErrorTag.operation_failed.toString(), e.getMessage());
            throw new NetconfDocumentedException("Unexpected response from get-config operation", (Exception)e, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, (Map)info);
        }
        return dataElement.getDomElement();
    }

    public String toString() {
        return "DefaultCommit{" + this.netconfSessionIdForReporting + '}';
    }
}

