/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl.mapping.operations;

import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfOperationRouter;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.mapping.api.DefaultNetconfOperation;
import org.opendaylight.controller.netconf.mapping.api.HandlingPriority;
import org.opendaylight.controller.netconf.util.mapping.AbstractNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultCloseSession
extends AbstractNetconfOperation
implements DefaultNetconfOperation {
    public static final String CLOSE_SESSION = "close-session";
    private NetconfSession netconfSession;

    public DefaultCloseSession(String netconfSessionIdForReporting) {
        super(netconfSessionIdForReporting);
    }

    protected HandlingPriority canHandle(String operationName, String netconfOperationNamespace) {
        if (!operationName.equals(CLOSE_SESSION)) {
            return HandlingPriority.CANNOT_HANDLE;
        }
        if (!netconfOperationNamespace.equals("urn:ietf:params:xml:ns:netconf:base:1.0")) {
            return HandlingPriority.CANNOT_HANDLE;
        }
        return HandlingPriority.HANDLE_WITH_MAX_PRIORITY;
    }

    protected Element handle(Document document, XmlElement operationElement, NetconfOperationRouter opRouter) throws NetconfDocumentedException {
        opRouter.close();
        return document.createElement("ok");
    }

    public void setNetconfSession(NetconfSession s) {
        this.netconfSession = s;
    }

    public NetconfSession getNetconfSession() {
        return this.netconfSession;
    }
}

