/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.util.Timer;
import io.netty.util.concurrent.Promise;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfServerSessionPreferences;
import org.opendaylight.controller.netconf.impl.CapabilityProviderImpl;
import org.opendaylight.controller.netconf.impl.NetconfServerSession;
import org.opendaylight.controller.netconf.impl.NetconfServerSessionNegotiator;
import org.opendaylight.controller.netconf.impl.SessionIdProvider;
import org.opendaylight.controller.netconf.impl.osgi.NetconfOperationServiceFactoryListener;
import org.opendaylight.controller.netconf.util.NetconfUtil;
import org.opendaylight.controller.netconf.util.xml.XMLNetconfUtil;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.protocol.framework.SessionListenerFactory;
import org.opendaylight.protocol.framework.SessionNegotiator;
import org.opendaylight.protocol.framework.SessionNegotiatorFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NetconfServerSessionNegotiatorFactory
implements SessionNegotiatorFactory {
    public static final String SERVER_HELLO_XML_LOCATION = "/server_hello.xml";
    private final Timer timer;
    private static final Document helloMessageTemplate = NetconfServerSessionNegotiatorFactory.loadHelloMessageTemplate();
    private final SessionIdProvider idProvider;
    private final NetconfOperationServiceFactoryListener factoriesListener;
    private static final XPathExpression sessionIdXPath = XMLNetconfUtil.compileXPath((String)"/netconf:hello/netconf:session-id");
    private static final XPathExpression capabilitiesXPath = XMLNetconfUtil.compileXPath((String)"/netconf:hello/netconf:capabilities");

    public NetconfServerSessionNegotiatorFactory(Timer timer, NetconfOperationServiceFactoryListener factoriesListener, SessionIdProvider idProvider) {
        this.timer = timer;
        this.factoriesListener = factoriesListener;
        this.idProvider = idProvider;
    }

    private static Document loadHelloMessageTemplate() {
        InputStream resourceAsStream = NetconfServerSessionNegotiatorFactory.class.getResourceAsStream(SERVER_HELLO_XML_LOCATION);
        Preconditions.checkNotNull((Object)resourceAsStream, (String)"Unable to load server hello message blueprint from %s", (Object[])new Object[]{SERVER_HELLO_XML_LOCATION});
        return NetconfUtil.createMessage((InputStream)resourceAsStream).getDocument();
    }

    public SessionNegotiator getSessionNegotiator(SessionListenerFactory sessionListenerFactory, Channel channel, Promise promise) {
        long sessionId = this.idProvider.getNextSessionId();
        NetconfServerSessionPreferences proposal = new NetconfServerSessionPreferences(this.createHelloMessage(sessionId), sessionId);
        return new NetconfServerSessionNegotiator(proposal, (Promise<NetconfServerSession>)promise, channel, this.timer, sessionListenerFactory.getSessionListener());
    }

    private NetconfMessage createHelloMessage(long sessionId) {
        Document helloMessageTemplate = this.getHelloTemplateClone();
        Node sessionIdNode = (Node)XmlUtil.evaluateXPath((XPathExpression)sessionIdXPath, (Object)helloMessageTemplate, (QName)XPathConstants.NODE);
        sessionIdNode.setTextContent(String.valueOf(sessionId));
        Element capabilitiesElement = (Element)XmlUtil.evaluateXPath((XPathExpression)capabilitiesXPath, (Object)helloMessageTemplate, (QName)XPathConstants.NODE);
        CapabilityProviderImpl capabilityProvider = new CapabilityProviderImpl(this.factoriesListener.getSnapshot(sessionId));
        for (String capability : capabilityProvider.getCapabilities()) {
            Element capabilityElement = helloMessageTemplate.createElement("capability");
            capabilityElement.setTextContent(capability);
            capabilitiesElement.appendChild(capabilityElement);
        }
        return new NetconfMessage(helloMessageTemplate);
    }

    private synchronized Document getHelloTemplateClone() {
        return (Document)helloMessageTemplate.cloneNode(true);
    }
}

