/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl;

import com.google.common.base.Optional;
import io.netty.channel.Channel;
import io.netty.util.Timer;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfServerSessionPreferences;
import org.opendaylight.controller.netconf.api.NetconfSessionPreferences;
import org.opendaylight.controller.netconf.impl.NetconfServerSession;
import org.opendaylight.controller.netconf.impl.util.AdditionalHeaderUtil;
import org.opendaylight.controller.netconf.util.AbstractNetconfSessionNegotiator;
import org.opendaylight.protocol.framework.SessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfServerSessionNegotiator
extends AbstractNetconfSessionNegotiator<NetconfServerSessionPreferences, NetconfServerSession> {
    static final Logger logger = LoggerFactory.getLogger(NetconfServerSessionNegotiator.class);

    protected NetconfServerSessionNegotiator(NetconfServerSessionPreferences sessionPreferences, Promise<NetconfServerSession> promise, Channel channel, Timer timer, SessionListener sessionListener) {
        super((NetconfSessionPreferences)sessionPreferences, promise, channel, timer, sessionListener);
    }

    protected NetconfServerSession getSession(SessionListener sessionListener, Channel channel, NetconfMessage message) {
        Optional additionalHeader = message.getAdditionalHeader();
        AdditionalHeader parsedHeader = additionalHeader.isPresent() ? AdditionalHeaderUtil.fromString((String)additionalHeader.get()) : new AdditionalHeader("unknown", ((InetSocketAddress)channel.localAddress()).getHostString(), "tcp", "client");
        logger.debug("Additional header from hello parsed as {} from {}", (Object)parsedHeader, (Object)additionalHeader);
        return new NetconfServerSession(sessionListener, channel, ((NetconfServerSessionPreferences)this.sessionPreferences).getSessionId(), parsedHeader);
    }

    public static class AdditionalHeader {
        private final String username;
        private final String address;
        private final String transport;
        private final String sessionIdentifier;

        public AdditionalHeader(String userName, String hostAddress, String transport, String sessionIdentifier) {
            this.address = hostAddress;
            this.username = userName;
            this.transport = transport;
            this.sessionIdentifier = sessionIdentifier;
        }

        String getUsername() {
            return this.username;
        }

        String getAddress() {
            return this.address;
        }

        String getTransport() {
            return this.transport;
        }

        String getSessionType() {
            return this.sessionIdentifier;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("AdditionalHeader{");
            sb.append("username='").append(this.username).append('\'');
            sb.append(", address='").append(this.address).append('\'');
            sb.append(", transport='").append(this.transport).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

