/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl;

import org.opendaylight.controller.netconf.impl.CapabilityProviderImpl;
import org.opendaylight.controller.netconf.impl.DefaultCommitNotificationProducer;
import org.opendaylight.controller.netconf.impl.NetconfServerSessionListener;
import org.opendaylight.controller.netconf.impl.SessionIdProvider;
import org.opendaylight.controller.netconf.impl.osgi.NetconfOperationRouterImpl;
import org.opendaylight.controller.netconf.impl.osgi.NetconfOperationServiceFactoryListener;
import org.opendaylight.controller.netconf.impl.osgi.NetconfOperationServiceSnapshot;
import org.opendaylight.controller.netconf.impl.osgi.SessionMonitoringService;
import org.opendaylight.protocol.framework.SessionListenerFactory;

public class NetconfServerSessionListenerFactory
implements SessionListenerFactory<NetconfServerSessionListener> {
    private final NetconfOperationServiceFactoryListener factoriesListener;
    private final DefaultCommitNotificationProducer commitNotifier;
    private final SessionIdProvider idProvider;
    private final SessionMonitoringService monitor;

    public NetconfServerSessionListenerFactory(NetconfOperationServiceFactoryListener factoriesListener, DefaultCommitNotificationProducer commitNotifier, SessionIdProvider idProvider, SessionMonitoringService monitor) {
        this.factoriesListener = factoriesListener;
        this.commitNotifier = commitNotifier;
        this.idProvider = idProvider;
        this.monitor = monitor;
    }

    public NetconfServerSessionListener getSessionListener() {
        NetconfOperationServiceSnapshot netconfOperationServiceSnapshot = this.factoriesListener.getSnapshot(this.idProvider.getCurrentSessionId());
        CapabilityProviderImpl capabilityProvider = new CapabilityProviderImpl(netconfOperationServiceSnapshot);
        NetconfOperationRouterImpl operationRouter = new NetconfOperationRouterImpl(netconfOperationServiceSnapshot, capabilityProvider, this.commitNotifier);
        return new NetconfServerSessionListener(operationRouter, this.monitor);
    }
}

