/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.api.NetconfTerminationReason;
import org.opendaylight.controller.netconf.impl.NetconfServerSession;
import org.opendaylight.controller.netconf.impl.osgi.NetconfOperationRouterImpl;
import org.opendaylight.controller.netconf.impl.osgi.SessionMonitoringService;
import org.opendaylight.controller.netconf.util.messages.SendErrorExceptionUtil;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.protocol.framework.SessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NetconfServerSessionListener
implements SessionListener<NetconfMessage, NetconfServerSession, NetconfTerminationReason> {
    static final Logger logger = LoggerFactory.getLogger(NetconfServerSessionListener.class);
    public static final String MESSAGE_ID = "message-id";
    private final SessionMonitoringService monitoringService;
    private NetconfOperationRouterImpl operationRouter;

    public NetconfServerSessionListener(NetconfOperationRouterImpl operationRouter, SessionMonitoringService monitoringService) {
        this.operationRouter = operationRouter;
        this.monitoringService = monitoringService;
    }

    public void onSessionUp(NetconfServerSession netconfNetconfServerSession) {
        this.monitoringService.onSessionUp(netconfNetconfServerSession);
    }

    public void onSessionDown(NetconfServerSession netconfNetconfServerSession, Exception e) {
        logger.debug("Session {} down, reason: {}", (Object)netconfNetconfServerSession, (Object)e.getMessage());
        this.monitoringService.onSessionDown(netconfNetconfServerSession);
        this.operationRouter.close();
    }

    public void onSessionTerminated(NetconfServerSession netconfNetconfServerSession, NetconfTerminationReason netconfTerminationReason) {
        logger.debug("Session {} terminated, reason: {}", (Object)netconfNetconfServerSession, (Object)netconfTerminationReason.getErrorMessage());
        this.monitoringService.onSessionDown(netconfNetconfServerSession);
        this.operationRouter.close();
    }

    public void onMessage(NetconfServerSession session, NetconfMessage netconfMessage) {
        try {
            Preconditions.checkState((this.operationRouter != null ? 1 : 0) != 0, (Object)"Cannot handle message, session up was not yet received");
            NetconfMessage message = this.processDocument(netconfMessage, session);
            logger.debug("Responding with message {}", (Object)XmlUtil.toString((Document)message.getDocument()));
            session.sendMessage(message);
            if (NetconfServerSessionListener.isCloseSession(netconfMessage)) {
                this.closeNetconfSession(session);
            }
        }
        catch (RuntimeException e) {
            logger.error("Unexpected exception", (Throwable)e);
            session.onIncommingRpcFail();
            throw new RuntimeException("Unable to process incoming message " + netconfMessage, e);
        }
        catch (NetconfDocumentedException e) {
            session.onOutgoingRpcError();
            session.onIncommingRpcFail();
            SendErrorExceptionUtil.sendErrorMessage((NetconfSession)session, (NetconfDocumentedException)e, (NetconfMessage)netconfMessage);
        }
    }

    private void closeNetconfSession(NetconfServerSession session) {
        session.close();
        logger.info("Session {} closed successfully", (Object)session.getSessionId());
    }

    private NetconfMessage processDocument(NetconfMessage netconfMessage, NetconfServerSession session) throws NetconfDocumentedException {
        Document incommingDocument = netconfMessage.getDocument();
        Element rootNode = incommingDocument.getDocumentElement();
        if (rootNode.getLocalName().equals("rpc")) {
            String messageId = rootNode.getAttributes().getNamedItem(MESSAGE_ID).getTextContent();
            Preconditions.checkState((messageId != null ? 1 : 0) != 0);
            Document responseDocument = XmlUtil.newDocument();
            Document rpcReply = this.operationRouter.onNetconfMessage(incommingDocument, session);
            session.onIncommingRpcSuccess();
            responseDocument.appendChild(responseDocument.importNode(rpcReply.getDocumentElement(), true));
            return new NetconfMessage(responseDocument);
        }
        throw new NetconfDocumentedException("Unknown tag " + rootNode.getNodeName(), NetconfDocumentedException.ErrorType.protocol, NetconfDocumentedException.ErrorTag.unknown_element, NetconfDocumentedException.ErrorSeverity.error, (Map)ImmutableMap.of((Object)"bad-element", (Object)rootNode.getNodeName()));
    }

    private static boolean isCloseSession(NetconfMessage incommingDocument) {
        Document document = incommingDocument.getDocument();
        XmlElement rpcElement = XmlElement.fromDomDocument((Document)document);
        return rpcElement.getOnlyChildElementOptionally("close-session").isPresent();
    }
}

