/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.api.monitoring.NetconfManagementSession;
import org.opendaylight.controller.netconf.impl.NetconfServerSessionNegotiator;
import org.opendaylight.protocol.framework.SessionListener;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.DomainName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Host;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.extension.rev131210.NetconfTcp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.extension.rev131210.Session1;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.extension.rev131210.Session1Builder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.NetconfSsh;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Transport;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.SessionBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.SessionKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.ZeroBasedCounter32;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfServerSession
extends NetconfSession
implements NetconfManagementSession {
    private static final Logger logger = LoggerFactory.getLogger(NetconfServerSession.class);
    private final NetconfServerSessionNegotiator.AdditionalHeader header;
    private Date loginTime;
    private long inRpcSuccess;
    private long inRpcFail;
    private long outRpcError;
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";

    public NetconfServerSession(SessionListener sessionListener, Channel channel, long sessionId, NetconfServerSessionNegotiator.AdditionalHeader header) {
        super(sessionListener, channel, sessionId);
        this.header = header;
        logger.debug("Session {} created", (Object)this.toString());
    }

    protected void sessionUp() {
        super.sessionUp();
        Preconditions.checkState((this.loginTime == null ? 1 : 0) != 0, (Object)"Session is already up");
        this.loginTime = new Date();
    }

    public void onIncommingRpcSuccess() {
        ++this.inRpcSuccess;
    }

    public void onIncommingRpcFail() {
        ++this.inRpcFail;
    }

    public void onOutgoingRpcError() {
        ++this.outRpcError;
    }

    public Session toManagementSession() {
        SessionBuilder builder = new SessionBuilder();
        builder.setSessionId(Long.valueOf(this.getSessionId()));
        builder.setSourceHost(new Host(new DomainName(this.header.getAddress())));
        Preconditions.checkState((DateAndTime.PATTERN_CONSTANTS.size() == 1 ? 1 : 0) != 0);
        String formattedDateTime = this.formatDateTime(this.loginTime);
        String pattern = (String)DateAndTime.PATTERN_CONSTANTS.get(0);
        Matcher matcher = Pattern.compile(pattern).matcher(formattedDateTime);
        Preconditions.checkState((boolean)matcher.matches(), (String)"Formatted datetime %s does not match pattern %s", (Object[])new Object[]{formattedDateTime, pattern});
        builder.setLoginTime(new DateAndTime(formattedDateTime));
        builder.setInBadRpcs(new ZeroBasedCounter32(Long.valueOf(this.inRpcFail)));
        builder.setInRpcs(new ZeroBasedCounter32(Long.valueOf(this.inRpcSuccess)));
        builder.setOutRpcErrors(new ZeroBasedCounter32(Long.valueOf(this.outRpcError)));
        builder.setUsername(this.header.getUsername());
        builder.setTransport(this.getTransportForString(this.header.getTransport()));
        builder.setOutNotifications(new ZeroBasedCounter32(Long.valueOf(0L)));
        builder.setKey(new SessionKey(Long.valueOf(this.getSessionId())));
        Session1Builder builder1 = new Session1Builder();
        builder1.setSessionIdentifier(this.header.getSessionType());
        builder.addAugmentation(Session1.class, (Augmentation)builder1.build());
        return builder.build();
    }

    private Class<? extends Transport> getTransportForString(String transport) {
        switch (transport) {
            case "ssh": {
                return NetconfSsh.class;
            }
            case "tcp": {
                return NetconfTcp.class;
            }
        }
        throw new IllegalArgumentException("Unknown transport type " + transport);
    }

    private String formatDateTime(Date loginTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(ISO_DATE_FORMAT);
        return dateFormat.format(loginTime);
    }
}

