/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.impl.NetconfServerSessionListener;
import org.opendaylight.controller.netconf.impl.NetconfServerSessionListenerFactory;
import org.opendaylight.controller.netconf.impl.NetconfServerSessionNegotiatorFactory;
import org.opendaylight.controller.netconf.impl.util.DeserializerExceptionHandler;
import org.opendaylight.controller.netconf.util.AbstractChannelInitializer;
import org.opendaylight.protocol.framework.AbstractDispatcher;

public class NetconfServerDispatcher
extends AbstractDispatcher<NetconfSession, NetconfServerSessionListener> {
    private final ServerChannelInitializer initializer;

    public NetconfServerDispatcher(ServerChannelInitializer serverChannelInitializer, EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        super(bossGroup, workerGroup);
        this.initializer = serverChannelInitializer;
    }

    public ChannelFuture createServer(InetSocketAddress address) {
        return super.createServer(address, (AbstractDispatcher.PipelineInitializer)new AbstractDispatcher.PipelineInitializer<NetconfSession>(){

            public void initializeChannel(SocketChannel ch, Promise<NetconfSession> promise) {
                NetconfServerDispatcher.this.initializer.initialize(ch, promise);
            }
        });
    }

    public static class ServerChannelInitializer
    extends AbstractChannelInitializer {
        private final NetconfServerSessionNegotiatorFactory negotiatorFactory;
        private final NetconfServerSessionListenerFactory listenerFactory;

        public ServerChannelInitializer(NetconfServerSessionNegotiatorFactory negotiatorFactory, NetconfServerSessionListenerFactory listenerFactory) {
            this.negotiatorFactory = negotiatorFactory;
            this.listenerFactory = listenerFactory;
        }

        protected void initializeAfterDecoder(SocketChannel ch, Promise<? extends NetconfSession> promise) {
            ch.pipeline().addLast("deserializerExHandler", (ChannelHandler)new DeserializerExceptionHandler());
            ch.pipeline().addLast("negotiator", (ChannelHandler)this.negotiatorFactory.getSessionNegotiator(this.listenerFactory, (Channel)ch, promise));
        }
    }
}

