/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl;

import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.opendaylight.controller.netconf.api.jmx.CommitJMXNotification;
import org.opendaylight.controller.netconf.api.jmx.DefaultCommitOperationMXBean;
import org.opendaylight.controller.netconf.api.jmx.NetconfJMXNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DefaultCommitNotificationProducer
extends NotificationBroadcasterSupport
implements DefaultCommitOperationMXBean,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCommitNotificationProducer.class);
    private final MBeanServer mbeanServer;
    private final ObjectName on = DefaultCommitOperationMXBean.objectName;

    public DefaultCommitNotificationProducer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
        DefaultCommitNotificationProducer.registerMBean(this, this.mbeanServer, this.on);
    }

    private static void registerMBean(Object instance, MBeanServer mbs, ObjectName on) {
        try {
            mbs.registerMBean(instance, on);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            throw new RuntimeException("Unable to register " + instance + " as " + on, e);
        }
    }

    public void sendCommitNotification(String message, Element cfgSnapshot, Set<String> capabilities) {
        CommitJMXNotification notif = NetconfJMXNotification.afterCommit((NotificationBroadcasterSupport)this, (String)message, (Element)cfgSnapshot, capabilities);
        logger.debug("Notification about commit {} sent", (Object)notif);
        this.sendNotification((Notification)notif);
    }

    @Override
    public void close() {
        try {
            this.mbeanServer.unregisterMBean(this.on);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            logger.warn("Ignoring exception while unregistering {} as {}", new Object[]{this, this.on, e});
        }
    }
}

