/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.controller.netconf.impl.DefaultCommitNotificationProducer;
import org.opendaylight.controller.netconf.impl.mapping.CapabilityProvider;
import org.opendaylight.controller.netconf.impl.osgi.NetconfOperationServiceSnapshot;
import org.opendaylight.controller.netconf.mapping.api.Capability;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilityProviderImpl
implements CapabilityProvider {
    private final NetconfOperationServiceSnapshot netconfOperationServiceSnapshot;
    private final Set<String> capabilityURIs;
    private static final Logger logger = LoggerFactory.getLogger(DefaultCommitNotificationProducer.class);

    public CapabilityProviderImpl(NetconfOperationServiceSnapshot netconfOperationServiceSnapshot) {
        this.netconfOperationServiceSnapshot = netconfOperationServiceSnapshot;
        Map<String, Capability> urisToCapabilitiesInternalMap = CapabilityProviderImpl.getCapabilitiesInternal(netconfOperationServiceSnapshot);
        ArrayList<String> capabilityURIs = new ArrayList<String>(urisToCapabilitiesInternalMap.keySet());
        Collections.sort(capabilityURIs);
        this.capabilityURIs = Collections.unmodifiableSet(new TreeSet<String>(capabilityURIs));
    }

    private static Map<String, Capability> getCapabilitiesInternal(NetconfOperationServiceSnapshot netconfOperationServiceSnapshot) {
        HashMap capabilityMap = Maps.newHashMap();
        for (NetconfOperationService netconfOperationService : netconfOperationServiceSnapshot.getServices()) {
            Set caps = netconfOperationService.getCapabilities();
            for (Capability cap : caps) {
                if (capabilityMap.containsKey(cap.getCapabilityUri())) {
                    logger.debug("Duplicate capability {} from service {}", (Object)cap.getCapabilityUri(), (Object)netconfOperationService);
                }
                capabilityMap.put(cap.getCapabilityUri(), cap);
            }
        }
        return capabilityMap;
    }

    @Override
    public synchronized String getSchemaForCapability(String moduleName, Optional<String> revision) {
        HashMap mappedModulesToRevisionToSchema = Maps.newHashMap();
        for (NetconfOperationService netconfOperationService : this.netconfOperationServiceSnapshot.getServices()) {
            Set caps = netconfOperationService.getCapabilities();
            for (Capability cap : caps) {
                if (!cap.getModuleName().isPresent() || !cap.getRevision().isPresent() || !cap.getCapabilitySchema().isPresent()) continue;
                String currentModuleName = (String)cap.getModuleName().get();
                Map revisionMap = (Map)mappedModulesToRevisionToSchema.get(currentModuleName);
                if (revisionMap == null) {
                    revisionMap = Maps.newHashMap();
                    mappedModulesToRevisionToSchema.put(currentModuleName, revisionMap);
                }
                String currentRevision = (String)cap.getRevision().get();
                revisionMap.put(currentRevision, cap.getCapabilitySchema().get());
            }
        }
        Map revisionMapRequest = (Map)mappedModulesToRevisionToSchema.get(moduleName);
        Preconditions.checkState((revisionMapRequest != null ? 1 : 0) != 0, (String)"Capability for module %s not present, available modules : %s", (Object[])new Object[]{moduleName, this.capabilityURIs});
        if (revision.isPresent()) {
            String schema = (String)revisionMapRequest.get(revision.get());
            Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Capability for module %s:%s not present, available revisions for module: %s", (Object[])new Object[]{moduleName, revision.get(), revisionMapRequest.keySet()});
            return schema;
        }
        Preconditions.checkState((revisionMapRequest.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 capability for module %s, available revisions : %s", (Object[])new Object[]{moduleName, revisionMapRequest.keySet()});
        return (String)revisionMapRequest.values().iterator().next();
    }

    @Override
    public synchronized Set<String> getCapabilities() {
        return this.capabilityURIs;
    }
}

