/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.controllermanager.northbound;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.configuration.IConfigurationService;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.controllermanager.northbound.ControllerProperties;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.BadRequestException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.switchmanager.ISwitchManager;

@Path(value="/")
public class ControllerManagerNorthbound {
    private String username;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private ISwitchManager getISwitchManagerService(String containerName) {
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        return switchManager;
    }

    @Path(value="/{containerName}/properties/")
    @GET
    @TypeHint(value=Property.class)
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName or property is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public ControllerProperties getControllerProperties(@PathParam(value="containerName") String containerName, @QueryParam(value="propertyName") String propertyName) {
        if (!this.isValidContainer(containerName)) {
            throw new ResourceNotFoundException("Container " + containerName + " does not exist.");
        }
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = this.getISwitchManagerService(containerName);
        if (propertyName == null) {
            Map propertyMap = switchManager.getControllerProperties();
            HashSet<Property> properties = new HashSet<Property>(propertyMap.values());
            return new ControllerProperties(properties);
        }
        HashSet<Property> properties = new HashSet<Property>();
        Property property = switchManager.getControllerProperty(propertyName);
        if (property == null) {
            throw new ResourceNotFoundException("Unable to find property with name: " + propertyName);
        }
        properties.add(property);
        return new ControllerProperties(properties);
    }

    @Path(value="/{containerName}/properties/{propertyName}/{propertyValue}")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Operation successful"), @ResponseCode(code=400, condition="Invalid property parameters"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName or property is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public Response setControllerProperty(@Context UriInfo uriInfo, @PathParam(value="containerName") String containerName, @PathParam(value="propertyName") String propertyName, @PathParam(value="propertyValue") String propertyValue) {
        if (!this.isValidContainer(containerName)) {
            throw new ResourceNotFoundException("Container " + containerName + " does not exist.");
        }
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = this.getISwitchManagerService(containerName);
        Property prop = switchManager.createProperty(propertyName, propertyValue);
        if (prop == null) {
            throw new BadRequestException("Property with name " + propertyName + " cannot be created.");
        }
        Status status = switchManager.setControllerProperty(prop);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Controller Property", (String)this.username, (String)"updated", (String)propertyName);
            return Response.created((URI)uriInfo.getRequestUri()).build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/{containerName}/properties/{propertyName}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="Property removed successfully"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public Response removeControllerProperty(@PathParam(value="containerName") String containerName, @PathParam(value="propertyName") String propertyName) {
        if (!this.isValidContainer(containerName)) {
            throw new ResourceNotFoundException("Container " + containerName + " does not exist.");
        }
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ISwitchManager switchManager = this.getISwitchManagerService(containerName);
        Status status = switchManager.removeControllerProperty(propertyName);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Controller Property", (String)this.username, (String)"removed", (String)propertyName);
            return Response.noContent().build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/configuration")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=204, condition="Operation successful"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=503, condition="Configuration service is unavailable.")})
    public Response saveConfiguration() {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)"default", (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation");
        }
        IConfigurationService configService = (IConfigurationService)ServiceHelper.getGlobalInstance(IConfigurationService.class, (Object)this);
        if (configService == null) {
            throw new ServiceUnavailableException("Configuration Service " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Status status = configService.saveConfigurations();
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Controller Configuration", (String)this.username, (String)"save", (String)"configuration");
            return Response.noContent().build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    private boolean isValidContainer(String containerName) {
        if (containerName.equals(GlobalConstants.DEFAULT.toString())) {
            return true;
        }
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new ServiceUnavailableException("Container Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        return containerManager.getContainerNames().contains(containerName);
    }
}

