/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension;

import java.nio.ByteBuffer;
import org.openflow.protocol.statistics.OFVendorStatistics;

public class V6StatsRequest
extends OFVendorStatistics {
    private static final long serialVersionUID = 1L;
    protected int msgsubtype;
    protected short outPort;
    protected short match_len;
    protected byte tableId;
    public static final int NICIRA_VENDOR_ID = 8992;
    private static final int NXST_FLOW = 0;

    public V6StatsRequest() {
        this.vendor = 8992;
        this.msgsubtype = 0;
        this.match_len = 0;
    }

    public void setVendorId() {
        this.vendor = 8992;
    }

    public int getVendorId() {
        return this.vendor;
    }

    public void setMsgtype() {
        this.msgsubtype = 0;
    }

    public int getMsgtype() {
        return this.msgsubtype;
    }

    public void setOutPort(short outPort) {
        this.outPort = outPort;
    }

    public short getOutPort() {
        return this.outPort;
    }

    public void setMatchLen(short match_len) {
        this.match_len = match_len;
    }

    public short getMatchLen() {
        return this.match_len;
    }

    public void setTableId(byte tableId) {
        this.tableId = tableId;
    }

    public byte getTableId() {
        return this.tableId;
    }

    public int getLength() {
        return 20;
    }

    public void readFrom(ByteBuffer data) {
        this.vendor = data.getInt();
        this.msgsubtype = data.getInt();
        data.getInt();
        this.outPort = data.getShort();
        this.match_len = data.getShort();
        this.tableId = data.get();
        for (int i = 0; i < 3; ++i) {
            data.get();
        }
    }

    public void writeTo(ByteBuffer data) {
        data.putInt(this.vendor);
        data.putInt(this.msgsubtype);
        data.putInt(0);
        data.putShort(this.outPort);
        data.putShort(this.match_len);
        data.put(this.tableId);
        for (int i = 0; i < 3; ++i) {
            data.put((byte)0);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.match_len;
        result = 31 * result + this.msgsubtype;
        result = 31 * result + this.outPort;
        result = 31 * result + this.tableId;
        return result;
    }

    public String toString() {
        return "V6StatsRequest [msgsubtype=" + this.msgsubtype + ", outPort=" + this.outPort + ", match_len=" + this.match_len + ", tableId=" + this.tableId + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        V6StatsRequest other = (V6StatsRequest)((Object)obj);
        if (this.match_len != other.match_len) {
            return false;
        }
        if (this.msgsubtype != other.msgsubtype) {
            return false;
        }
        if (this.outPort != other.outPort) {
            return false;
        }
        return this.tableId == other.tableId;
    }
}

