/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension;

import java.nio.ByteBuffer;
import java.util.List;
import org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension.V6Match;
import org.openflow.protocol.action.OFAction;
import org.openflow.protocol.statistics.OFVendorStatistics;
import org.openflow.util.U16;

public class V6StatsReply
extends OFVendorStatistics {
    private static final long serialVersionUID = 1L;
    public static int MINIMUM_LENGTH = 48;
    protected short length = (short)MINIMUM_LENGTH;
    protected byte tableId;
    protected int durationSeconds;
    protected int durationNanoseconds;
    protected short priority;
    protected short idleTimeout;
    protected short hardTimeout;
    protected short match_len;
    protected short idleAge;
    protected short hardAge;
    protected long cookie;
    protected long packetCount;
    protected long byteCount;
    protected V6Match match;
    protected List<OFAction> actions;

    public int getVendorId() {
        return this.vendor;
    }

    public void setVendorId(int vendor) {
        this.vendor = vendor;
    }

    public byte getTableId() {
        return this.tableId;
    }

    public void setTableId(byte tableId) {
        this.tableId = tableId;
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(int durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public int getDurationNanoseconds() {
        return this.durationNanoseconds;
    }

    public void setDurationNanoseconds(int durationNanoseconds) {
        this.durationNanoseconds = durationNanoseconds;
    }

    public short getPriority() {
        return this.priority;
    }

    public void setPriority(short priority) {
        this.priority = priority;
    }

    public short getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(short idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public short getHardTimeout() {
        return this.hardTimeout;
    }

    public void setHardTimeout(short hardTimeout) {
        this.hardTimeout = hardTimeout;
    }

    public void setMatchLen(short match_len) {
        this.match_len = match_len;
    }

    public short getMatchLen() {
        return this.match_len;
    }

    public short getIdleAge() {
        return this.idleAge;
    }

    public void setIdleAge(short idleAge) {
        this.idleAge = idleAge;
    }

    public short getHardAge() {
        return this.hardAge;
    }

    public void setHardAge(short hardAge) {
        this.hardAge = hardAge;
    }

    public long getCookie() {
        return this.cookie;
    }

    public void setCookie(long cookie) {
        this.cookie = cookie;
    }

    public long getPacketCount() {
        return this.packetCount;
    }

    public void setPacketCount(long packetCount) {
        this.packetCount = packetCount;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(long byteCount) {
        this.byteCount = byteCount;
    }

    public void setLength(short length) {
        this.length = length;
    }

    public int getLength() {
        return U16.f((short)this.length);
    }

    public V6Match getMatch() {
        return this.match;
    }

    public List<OFAction> getActions() {
        return this.actions;
    }

    public void setActions(List<OFAction> actions) {
        this.actions = actions;
    }

    public void readFrom(ByteBuffer data) {
        short i;
        this.length = data.getShort();
        if (this.length < MINIMUM_LENGTH) {
            return;
        }
        this.tableId = data.get();
        data.get();
        this.durationSeconds = data.getInt();
        this.durationNanoseconds = data.getInt();
        this.priority = data.getShort();
        this.idleTimeout = data.getShort();
        this.hardTimeout = data.getShort();
        this.match_len = data.getShort();
        this.idleAge = data.getShort();
        this.hardAge = data.getShort();
        this.cookie = data.getLong();
        this.packetCount = data.getLong();
        this.byteCount = data.getLong();
        if (this.length == MINIMUM_LENGTH) {
            return;
        }
        if (this.match == null) {
            this.match = new V6Match();
        }
        ByteBuffer mbuf = ByteBuffer.allocate(this.match_len);
        for (i = 0; i < this.match_len; i = (short)(i + 1)) {
            mbuf.put(data.get());
        }
        mbuf.rewind();
        this.match.readFrom(mbuf);
        if (this.actionFactory == null) {
            throw new RuntimeException("OFActionFactory not set");
        }
        short pad_size = (short)((this.match_len + 7) / 8 * 8 - this.match_len);
        for (i = 0; i < pad_size; i = (short)(i + 1)) {
            data.get();
        }
        int action_len = this.length - MINIMUM_LENGTH - (this.match_len + pad_size);
        if (action_len > 0) {
            this.actions = this.actionFactory.parseActions(data, action_len);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (int)(this.byteCount ^ this.byteCount >>> 32);
        result = 31 * result + (int)(this.cookie ^ this.cookie >>> 32);
        result = 31 * result + this.durationNanoseconds;
        result = 31 * result + this.durationSeconds;
        result = 31 * result + this.hardAge;
        result = 31 * result + this.hardTimeout;
        result = 31 * result + this.idleAge;
        result = 31 * result + this.idleTimeout;
        result = 31 * result + this.length;
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 31 * result + this.match_len;
        result = 31 * result + (int)(this.packetCount ^ this.packetCount >>> 32);
        result = 31 * result + this.priority;
        result = 31 * result + this.tableId;
        return result;
    }

    public String toString() {
        return "V6StatsReply [length=" + this.length + ", tableId=" + this.tableId + ", durationSeconds=" + this.durationSeconds + ", durationNanoseconds=" + this.durationNanoseconds + ", priority=" + this.priority + ", idleTimeout=" + this.idleTimeout + ", hardTimeout=" + this.hardTimeout + ", match_len=" + this.match_len + ", idleAge=" + this.idleAge + ", hardAge=" + this.hardAge + ", cookie=" + this.cookie + ", packetCount=" + this.packetCount + ", byteCount=" + this.byteCount + ", match=" + this.match + ", actions=" + this.actions + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        V6StatsReply other = (V6StatsReply)((Object)obj);
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        if (this.byteCount != other.byteCount) {
            return false;
        }
        if (this.cookie != other.cookie) {
            return false;
        }
        if (this.durationNanoseconds != other.durationNanoseconds) {
            return false;
        }
        if (this.durationSeconds != other.durationSeconds) {
            return false;
        }
        if (this.hardAge != other.hardAge) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.idleAge != other.idleAge) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        if (this.match_len != other.match_len) {
            return false;
        }
        if (this.packetCount != other.packetCount) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        return this.tableId == other.tableId;
    }
}

