/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.controller.sal.utils.NetUtils;
import org.openflow.protocol.OFMatch;
import org.openflow.util.U16;
import org.openflow.util.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V6Match
extends OFMatch
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(V6Match.class);
    private static final long serialVersionUID = 1L;
    protected Inet6Address nwSrc;
    protected Inet6Address nwDst;
    protected short inputPortMask;
    protected byte[] dataLayerSourceMask;
    protected byte[] dataLayerDestinationMask;
    protected int dataLayerVirtualLanTCIMask;
    protected short dataLayerTypeMask;
    protected byte networkTypeOfServiceMask;
    protected byte networkProtocolMask;
    protected short transportSourceMask;
    protected short transportDestinationMask;
    protected short srcIPv6SubnetMaskbits;
    protected short dstIPv6SubnetMaskbits;
    protected MatchFieldState inputPortState;
    protected MatchFieldState dlSourceState;
    protected MatchFieldState dlDestState;
    protected MatchFieldState dlVlanIDState;
    protected MatchFieldState dlVlanPCPState;
    protected MatchFieldState dlVlanTCIState;
    protected MatchFieldState ethTypeState;
    protected MatchFieldState nwTosState;
    protected MatchFieldState nwProtoState;
    protected MatchFieldState nwSrcState;
    protected MatchFieldState nwDstState;
    protected MatchFieldState tpSrcState;
    protected MatchFieldState tpDstState;
    protected short match_len = 0;
    protected short pad_size = 0;
    private static int IPV6_EXT_MIN_HDR_LEN = 36;

    public V6Match() {
        this.nwSrc = null;
        this.nwDst = null;
        this.inputPortMask = 0;
        this.dataLayerSourceMask = null;
        this.dataLayerDestinationMask = null;
        this.dataLayerTypeMask = 0;
        this.dataLayerVirtualLanTCIMask = 0;
        this.networkTypeOfServiceMask = 0;
        this.networkProtocolMask = 0;
        this.transportSourceMask = 0;
        this.transportDestinationMask = 0;
        this.inputPortState = MatchFieldState.MATCH_ABSENT;
        this.dlSourceState = MatchFieldState.MATCH_ABSENT;
        this.dlDestState = MatchFieldState.MATCH_ABSENT;
        this.dlVlanIDState = MatchFieldState.MATCH_ABSENT;
        this.dlVlanPCPState = MatchFieldState.MATCH_ABSENT;
        this.dlVlanTCIState = MatchFieldState.MATCH_ABSENT;
        this.ethTypeState = MatchFieldState.MATCH_ABSENT;
        this.nwTosState = MatchFieldState.MATCH_ABSENT;
        this.nwProtoState = MatchFieldState.MATCH_ABSENT;
        this.nwSrcState = MatchFieldState.MATCH_ABSENT;
        this.nwDstState = MatchFieldState.MATCH_ABSENT;
        this.tpSrcState = MatchFieldState.MATCH_ABSENT;
        this.tpDstState = MatchFieldState.MATCH_ABSENT;
        this.match_len = 0;
        this.pad_size = 0;
    }

    public V6Match(OFMatch match) {
        InetAddress mask;
        InetAddress address;
        this.match_len = 0;
        this.pad_size = 0;
        if (match.getNetworkSource() != 0) {
            address = NetUtils.getInetAddress((int)match.getNetworkSource());
            mask = NetUtils.getInetNetworkMask((int)match.getNetworkSourceMaskLen(), (boolean)false);
            this.setNetworkSource(address, mask);
        } else {
            this.nwSrcState = MatchFieldState.MATCH_ABSENT;
        }
        if (match.getNetworkDestination() != 0) {
            address = NetUtils.getInetAddress((int)match.getNetworkDestination());
            mask = NetUtils.getInetNetworkMask((int)match.getNetworkDestinationMaskLen(), (boolean)false);
            this.setNetworkDestination(address, mask);
        } else {
            this.nwDstState = MatchFieldState.MATCH_ABSENT;
        }
        this.inputPortMask = 0;
        if (match.getInputPort() != 0) {
            this.setInputPort(match.getInputPort(), (short)0);
        } else {
            this.inputPortMask = 0;
            this.inputPortState = MatchFieldState.MATCH_ABSENT;
        }
        this.dataLayerSourceMask = null;
        if (match.getDataLayerSource() != null && !NetUtils.isZeroMAC((byte[])match.getDataLayerSource())) {
            this.setDataLayerSource(match.getDataLayerSource(), null);
        } else {
            this.dlSourceState = MatchFieldState.MATCH_ABSENT;
        }
        this.dataLayerDestinationMask = null;
        if (match.getDataLayerDestination() != null && !NetUtils.isZeroMAC((byte[])match.getDataLayerDestination())) {
            this.setDataLayerDestination(match.getDataLayerDestination(), null);
        } else {
            this.dlDestState = MatchFieldState.MATCH_ABSENT;
        }
        this.dataLayerTypeMask = 0;
        if (match.getDataLayerType() != 0) {
            this.setDataLayerType(match.getDataLayerType(), (short)0);
        } else {
            this.dataLayerType = 0;
            this.ethTypeState = MatchFieldState.MATCH_ABSENT;
        }
        this.dataLayerVirtualLanTCIMask = 0;
        this.dlVlanTCIState = MatchFieldState.MATCH_ABSENT;
        if (match.getDataLayerVirtualLan() != 0) {
            this.setDataLayerVirtualLan(match.getDataLayerVirtualLan(), (short)0);
        } else {
            this.dataLayerVirtualLan = 0;
            this.dlVlanIDState = MatchFieldState.MATCH_ABSENT;
        }
        if (match.getDataLayerVirtualLanPriorityCodePoint() != 0) {
            this.setDataLayerVirtualLanPriorityCodePoint(match.getDataLayerVirtualLanPriorityCodePoint(), (byte)0);
        } else {
            this.dataLayerVirtualLanPriorityCodePoint = 0;
            this.dlVlanPCPState = MatchFieldState.MATCH_ABSENT;
        }
        this.networkProtocolMask = 0;
        if (match.getNetworkProtocol() != 0) {
            this.networkProtocol = match.getNetworkProtocol();
            this.setNetworkProtocol(this.networkProtocol, (byte)0);
        } else {
            this.networkProtocol = 0;
            this.nwProtoState = MatchFieldState.MATCH_ABSENT;
        }
        this.networkTypeOfServiceMask = 0;
        if (match.getNetworkTypeOfService() != 0) {
            this.networkTypeOfService = match.getNetworkTypeOfService();
            this.setNetworkTypeOfService(this.networkTypeOfService, (byte)0);
        } else {
            this.networkTypeOfService = match.getNetworkTypeOfService();
            this.nwTosState = MatchFieldState.MATCH_ABSENT;
        }
        this.transportSourceMask = 0;
        if (match.getTransportSource() != 0) {
            this.setTransportSource(match.getTransportSource(), (short)0);
        } else {
            this.transportSource = 0;
            this.tpSrcState = MatchFieldState.MATCH_ABSENT;
        }
        this.transportDestinationMask = 0;
        if (match.getTransportDestination() != 0) {
            this.setTransportDestination(match.getTransportDestination(), (short)0);
        } else {
            this.transportDestination = 0;
            this.tpDstState = MatchFieldState.MATCH_ABSENT;
        }
        this.setWildcards(match.getWildcards());
    }

    public short getIPv6MatchLen() {
        return this.match_len;
    }

    public int getIPv6ExtMinHdrLen() {
        return IPV6_EXT_MIN_HDR_LEN;
    }

    public short getPadSize() {
        return (short)((this.match_len + 7) / 8 * 8 - this.match_len);
    }

    private int getIPv6ExtensionMatchHeader(Extension_Types extType, int field, int has_mask, int length) {
        return (extType.getValue() & 0xFFFF) << 16 | (field & 0x7F) << 9 | (has_mask & 1) << 8 | length & 0xFF;
    }

    private byte[] getIPv6ExtensionPortMatchMsg(short port) {
        ByteBuffer ipv6ext_port_msg = ByteBuffer.allocate(6);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_IN_PORT.getValue(), 0, 2);
        ipv6ext_port_msg.putInt(nxm_header);
        ipv6ext_port_msg.putShort(port);
        return ipv6ext_port_msg.array();
    }

    private byte[] getIPv6ExtensionDestMacMatchMsg(byte[] destMac) {
        ByteBuffer ipv6ext_destmac_msg = ByteBuffer.allocate(10);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_ETH_DST.getValue(), 0, 6);
        ipv6ext_destmac_msg.putInt(nxm_header);
        ipv6ext_destmac_msg.put(destMac);
        return ipv6ext_destmac_msg.array();
    }

    private byte[] getIPv6ExtensionSrcMacMatchMsg(byte[] srcMac) {
        ByteBuffer ipv6ext_srcmac_msg = ByteBuffer.allocate(10);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_ETH_SRC.getValue(), 0, 6);
        ipv6ext_srcmac_msg.putInt(nxm_header);
        ipv6ext_srcmac_msg.put(srcMac);
        return ipv6ext_srcmac_msg.array();
    }

    private byte[] getIPv6ExtensionEtherTypeMatchMsg(short EtherType) {
        ByteBuffer ipv6ext_etype_msg = ByteBuffer.allocate(6);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_ETH_TYPE.getValue(), 0, 2);
        ipv6ext_etype_msg.putInt(nxm_header);
        ipv6ext_etype_msg.putShort(EtherType);
        return ipv6ext_etype_msg.array();
    }

    private byte[] getVlanTCI(short dataLayerVirtualLanID, byte dataLayerVirtualLanPriorityCodePoint) {
        ByteBuffer vlan_tci = ByteBuffer.allocate(2);
        int cfi = 4096;
        int pcp = dataLayerVirtualLanPriorityCodePoint << 13;
        int vlan_tci_int = pcp + cfi + dataLayerVirtualLanID;
        vlan_tci.put((byte)(vlan_tci_int >> 8));
        vlan_tci.put((byte)vlan_tci_int);
        return vlan_tci.array();
    }

    private byte[] getIPv6ExtensionVlanTCIMatchMsg(short dataLayerVirtualLanID, byte dataLayerVirtualLanPriorityCodePoint) {
        ByteBuffer ipv6ext_vlan_tci_msg = ByteBuffer.allocate(6);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_VLAN_TCI.getValue(), 0, 2);
        ipv6ext_vlan_tci_msg.putInt(nxm_header);
        ipv6ext_vlan_tci_msg.put(this.getVlanTCI(dataLayerVirtualLanID, dataLayerVirtualLanPriorityCodePoint));
        return ipv6ext_vlan_tci_msg.array();
    }

    private byte[] getIPv6ExtensionVlanTCIMatchWithMaskMsg(short dataLayerVirtualLan, byte dataLayerVirtualLanPriorityCodePoint, int dataLayerVirtualLanTCIMask) {
        ByteBuffer ipv6ext_vlan_tci_msg = ByteBuffer.allocate(8);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_VLAN_TCI.getValue(), 1, 4);
        ipv6ext_vlan_tci_msg.putInt(nxm_header);
        ipv6ext_vlan_tci_msg.put(this.getVlanTCI(dataLayerVirtualLan, dataLayerVirtualLanPriorityCodePoint));
        ipv6ext_vlan_tci_msg.put((byte)(dataLayerVirtualLanTCIMask >> 8));
        ipv6ext_vlan_tci_msg.put((byte)dataLayerVirtualLanTCIMask);
        return ipv6ext_vlan_tci_msg.array();
    }

    private byte[] getIPv6ExtensionSrcIPv6MatchMsg(byte[] srcIpv6) {
        ByteBuffer ipv6ext_ipv6_msg = ByteBuffer.allocate(20);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.IPV6EXT, IPv6Extension_Match_Types.MATCH_IPV6EXT_IPV6_SRC.getValue(), 0, 16);
        ipv6ext_ipv6_msg.putInt(nxm_header);
        ipv6ext_ipv6_msg.put(srcIpv6);
        return ipv6ext_ipv6_msg.array();
    }

    private byte[] getIPv6ExtensionSrcIPv6MatchwithMaskMsg(byte[] srcIpv6, short masklen) {
        ByteBuffer ipv6ext_ipv6_msg = ByteBuffer.allocate(36);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.IPV6EXT, IPv6Extension_Match_Types.MATCH_IPV6EXT_IPV6_SRC.getValue(), 1, 32);
        ipv6ext_ipv6_msg.putInt(nxm_header);
        ipv6ext_ipv6_msg.put(srcIpv6);
        byte[] ipv6_mask = this.getIPv6NetworkMaskinBytes(masklen);
        ipv6ext_ipv6_msg.put(ipv6_mask);
        return ipv6ext_ipv6_msg.array();
    }

    private byte[] getIPv6ExtensionDstIPv6MatchMsg(byte[] dstIpv6) {
        ByteBuffer ipv6ext_ipv6_msg = ByteBuffer.allocate(20);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.IPV6EXT, IPv6Extension_Match_Types.MATCH_IPV6EXT_IPV6_DST.getValue(), 0, 16);
        ipv6ext_ipv6_msg.putInt(nxm_header);
        ipv6ext_ipv6_msg.put(dstIpv6);
        return ipv6ext_ipv6_msg.array();
    }

    private byte[] getIPv6ExtensionDstIPv6MatchwithMaskMsg(byte[] dstIpv6, short masklen) {
        ByteBuffer ipv6ext_ipv6_msg = ByteBuffer.allocate(36);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.IPV6EXT, IPv6Extension_Match_Types.MATCH_IPV6EXT_IPV6_DST.getValue(), 1, 32);
        ipv6ext_ipv6_msg.putInt(nxm_header);
        ipv6ext_ipv6_msg.put(dstIpv6);
        byte[] ipv6_mask = this.getIPv6NetworkMaskinBytes(masklen);
        ipv6ext_ipv6_msg.put(ipv6_mask);
        return ipv6ext_ipv6_msg.array();
    }

    private byte[] getIPv6ExtensionProtocolMatchMsg(byte protocol) {
        ByteBuffer ipv6ext_proto_msg = ByteBuffer.allocate(5);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_IP_PROTO.getValue(), 0, 1);
        if (protocol == 0) {
            return null;
        }
        ipv6ext_proto_msg.putInt(nxm_header);
        if (protocol == IPProtocols.ICMP.getValue()) {
            protocol = IPProtocols.ICMPV6.getValue();
        }
        ipv6ext_proto_msg.put(protocol);
        return ipv6ext_proto_msg.array();
    }

    private byte[] getIPv6ExtensionTOSMatchMsg(byte tos) {
        ByteBuffer ipv6ext_tos_msg = ByteBuffer.allocate(5);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_IP_TOS.getValue(), 0, 1);
        ipv6ext_tos_msg.putInt(nxm_header);
        ipv6ext_tos_msg.put(tos);
        return ipv6ext_tos_msg.array();
    }

    private byte[] getIPv6ExtensionTCPSrcPortMatchMsg(short src_port) {
        ByteBuffer ipv6ext_tcp_srcport_msg = ByteBuffer.allocate(6);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_TCP_SRC.getValue(), 0, 2);
        ipv6ext_tcp_srcport_msg.putInt(nxm_header);
        ipv6ext_tcp_srcport_msg.putShort(src_port);
        return ipv6ext_tcp_srcport_msg.array();
    }

    private byte[] getIPv6ExtensionTCPDstPortMatchMsg(short dst_port) {
        ByteBuffer ipv6ext_tcp_dstport_msg = ByteBuffer.allocate(6);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_TCP_DST.getValue(), 0, 2);
        ipv6ext_tcp_dstport_msg.putInt(nxm_header);
        ipv6ext_tcp_dstport_msg.putShort(dst_port);
        return ipv6ext_tcp_dstport_msg.array();
    }

    private byte[] getIPv6ExtensionUDPSrcPortMatchMsg(short src_port) {
        ByteBuffer ipv6ext_udp_srcport_msg = ByteBuffer.allocate(6);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_UDP_SRC.getValue(), 0, 2);
        ipv6ext_udp_srcport_msg.putInt(nxm_header);
        ipv6ext_udp_srcport_msg.putShort(src_port);
        return ipv6ext_udp_srcport_msg.array();
    }

    private byte[] getIPv6ExtensionUDPDstPortMatchMsg(short dst_port) {
        ByteBuffer ipv6ext_udp_dstport_msg = ByteBuffer.allocate(6);
        int nxm_header = this.getIPv6ExtensionMatchHeader(Extension_Types.OF_10, OF_Match_Types.MATCH_OF_UDP_DST.getValue(), 0, 2);
        ipv6ext_udp_dstport_msg.putInt(nxm_header);
        ipv6ext_udp_dstport_msg.putShort(dst_port);
        return ipv6ext_udp_dstport_msg.array();
    }

    public void fromString(String match) throws IllegalArgumentException {
        if (match.equals("") || match.equalsIgnoreCase("any") || match.equalsIgnoreCase("all") || match.equals("[]")) {
            match = "OFMatch[]";
        }
        String[] tokens = match.split("[\\[,\\]]");
        int initArg = 0;
        if (tokens[0].equals("OFMatch")) {
            initArg = 1;
        }
        this.wildcards = 0x3FFFFF;
        for (int i = initArg; i < tokens.length; ++i) {
            int masklen;
            String[] addressString;
            InetAddress mask;
            InetAddress address;
            String[] values = tokens[i].split("=");
            if (values.length != 2) {
                throw new IllegalArgumentException("Token " + tokens[i] + " does not have form 'key=value' parsing " + match);
            }
            values[0] = values[0].toLowerCase();
            if (values[0].equals("in_port") || values[0].equals("input_port")) {
                this.inputPort = U16.t((int)Integer.valueOf(values[1]));
                this.inputPortState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + 6);
                continue;
            }
            if (values[0].equals("dl_dst") || values[0].equals("eth_dst")) {
                this.dataLayerDestination = HexEncode.bytesFromHexString((String)values[1]);
                this.dlDestState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + 10);
                continue;
            }
            if (values[0].equals("dl_src") || values[0].equals("eth_src")) {
                this.dataLayerSource = HexEncode.bytesFromHexString((String)values[1]);
                this.dlSourceState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + 10);
                this.wildcards &= 0xFFFFFFFB;
                continue;
            }
            if (values[0].equals("dl_type") || values[0].equals("eth_type")) {
                this.dataLayerType = values[1].startsWith("0x") ? U16.t((int)Integer.valueOf(values[1].replaceFirst("0x", ""), 16)) : U16.t((int)Integer.valueOf(values[1]));
                this.ethTypeState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + 6);
                continue;
            }
            if (values[0].equals("dl_vlan")) {
                this.dataLayerVirtualLan = U16.t((int)Integer.valueOf(values[1]));
                this.dlVlanIDState = MatchFieldState.MATCH_FIELD_ONLY;
                if (this.dlVlanPCPState != MatchFieldState.MATCH_ABSENT) {
                    this.dlVlanTCIState = MatchFieldState.MATCH_FIELD_ONLY;
                    this.match_len = (short)(this.match_len - 2);
                } else {
                    this.dlVlanTCIState = MatchFieldState.MATCH_FIELD_WITH_MASK;
                    this.dataLayerVirtualLanTCIMask = 8191;
                    this.match_len = (short)(this.match_len + 8);
                }
                this.wildcards &= 0xFFFFFFFD;
                continue;
            }
            if (values[0].equals("dl_vpcp")) {
                this.dataLayerVirtualLanPriorityCodePoint = U8.t((short)Short.valueOf(values[1]));
                this.dlVlanPCPState = MatchFieldState.MATCH_FIELD_ONLY;
                if (this.dlVlanIDState != MatchFieldState.MATCH_ABSENT) {
                    this.dlVlanTCIState = MatchFieldState.MATCH_FIELD_ONLY;
                    this.match_len = (short)(this.match_len - 2);
                } else {
                    this.dlVlanTCIState = MatchFieldState.MATCH_FIELD_WITH_MASK;
                    this.dataLayerVirtualLanTCIMask = 61440;
                    this.match_len = (short)(this.match_len + 8);
                }
                this.wildcards &= 0xFFEFFFFF;
                continue;
            }
            if (values[0].equals("nw_dst") || values[0].equals("ip_dst")) {
                try {
                    address = null;
                    mask = null;
                    if (values[1].contains("/")) {
                        addressString = values[1].split("/");
                        address = InetAddress.getByName(addressString[0]);
                        masklen = Integer.valueOf(addressString[1]);
                        mask = NetUtils.getInetNetworkMask((int)masklen, (boolean)(address instanceof Inet6Address));
                    } else {
                        address = InetAddress.getByName(values[1]);
                    }
                    this.setNetworkDestination(address, mask);
                }
                catch (UnknownHostException e) {
                    logger.error("", (Throwable)e);
                }
                continue;
            }
            if (values[0].equals("nw_src") || values[0].equals("ip_src")) {
                try {
                    address = null;
                    mask = null;
                    if (values[1].contains("/")) {
                        addressString = values[1].split("/");
                        address = InetAddress.getByName(addressString[0]);
                        masklen = Integer.valueOf(addressString[1]);
                        mask = NetUtils.getInetNetworkMask((int)masklen, (boolean)(address instanceof Inet6Address));
                    } else {
                        address = InetAddress.getByName(values[1]);
                    }
                    this.setNetworkSource(address, mask);
                }
                catch (UnknownHostException e) {
                    logger.error("", (Throwable)e);
                }
                continue;
            }
            if (values[0].equals("nw_proto")) {
                this.networkProtocol = U8.t((short)Short.valueOf(values[1]));
                if (this.networkProtocol == 0) continue;
                this.nwProtoState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + 5);
                continue;
            }
            if (values[0].equals("nw_tos")) {
                this.networkTypeOfService = U8.t((short)Short.valueOf(values[1]));
                this.nwTosState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + 5);
                continue;
            }
            if (values[0].equals("tp_dst")) {
                this.transportDestination = U16.t((int)Integer.valueOf(values[1]));
                this.tpDstState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + 6);
                continue;
            }
            if (values[0].equals("tp_src")) {
                this.transportSource = U16.t((int)Integer.valueOf(values[1]));
                this.tpSrcState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + 6);
                continue;
            }
            throw new IllegalArgumentException("unknown token " + tokens[i] + " parsing " + match);
        }
        this.pad_size = (short)((this.match_len + 7) / 8 * 8 - this.match_len);
    }

    public void writeTo(ByteBuffer data) {
        byte[] ipv6ext_protocol_msg;
        if (this.inputPortState == MatchFieldState.MATCH_FIELD_ONLY) {
            byte[] ipv6ext_ingress_port_msg = this.getIPv6ExtensionPortMatchMsg(this.inputPort);
            data.put(ipv6ext_ingress_port_msg);
        }
        if (this.ethTypeState == MatchFieldState.MATCH_FIELD_ONLY) {
            byte[] ipv6ext_ether_type_msg = this.getIPv6ExtensionEtherTypeMatchMsg(this.dataLayerType);
            data.put(ipv6ext_ether_type_msg);
        }
        if (this.dlDestState == MatchFieldState.MATCH_FIELD_ONLY) {
            byte[] ipv6ext_destmac_msg = this.getIPv6ExtensionDestMacMatchMsg(this.dataLayerDestination);
            data.put(ipv6ext_destmac_msg);
        }
        if (this.dlSourceState == MatchFieldState.MATCH_FIELD_ONLY) {
            byte[] ipv6ext_srcmac_msg = this.getIPv6ExtensionSrcMacMatchMsg(this.dataLayerSource);
            data.put(ipv6ext_srcmac_msg);
        }
        if (this.dlVlanTCIState == MatchFieldState.MATCH_FIELD_ONLY) {
            byte[] ipv6ext_vlan_tci_msg = this.getIPv6ExtensionVlanTCIMatchMsg(this.dataLayerVirtualLan, this.dataLayerVirtualLanPriorityCodePoint);
            data.put(ipv6ext_vlan_tci_msg);
        } else if (this.dlVlanTCIState == MatchFieldState.MATCH_FIELD_WITH_MASK) {
            byte[] ipv6ext_vlan_tci_msg_with_mask = this.getIPv6ExtensionVlanTCIMatchWithMaskMsg(this.dataLayerVirtualLan, this.dataLayerVirtualLanPriorityCodePoint, this.dataLayerVirtualLanTCIMask);
            data.put(ipv6ext_vlan_tci_msg_with_mask);
        }
        if (this.nwSrcState == MatchFieldState.MATCH_FIELD_ONLY) {
            byte[] ipv6ext_src_ipv6_msg = this.getIPv6ExtensionSrcIPv6MatchMsg(this.nwSrc.getAddress());
            data.put(ipv6ext_src_ipv6_msg);
        } else if (this.nwSrcState == MatchFieldState.MATCH_FIELD_WITH_MASK) {
            byte[] ipv6ext_src_ipv6_with_mask_msg = this.getIPv6ExtensionSrcIPv6MatchwithMaskMsg(this.nwSrc.getAddress(), this.srcIPv6SubnetMaskbits);
            data.put(ipv6ext_src_ipv6_with_mask_msg);
        }
        if (this.nwDstState == MatchFieldState.MATCH_FIELD_ONLY) {
            byte[] ipv6ext_dst_ipv6_msg = this.getIPv6ExtensionDstIPv6MatchMsg(this.nwDst.getAddress());
            data.put(ipv6ext_dst_ipv6_msg);
        } else if (this.nwDstState == MatchFieldState.MATCH_FIELD_WITH_MASK) {
            byte[] ipv6ext_dst_ipv6_with_mask_msg = this.getIPv6ExtensionDstIPv6MatchwithMaskMsg(this.nwDst.getAddress(), this.dstIPv6SubnetMaskbits);
            data.put(ipv6ext_dst_ipv6_with_mask_msg);
        }
        if (this.nwProtoState == MatchFieldState.MATCH_FIELD_ONLY && (ipv6ext_protocol_msg = this.getIPv6ExtensionProtocolMatchMsg(this.networkProtocol)) != null) {
            data.put(ipv6ext_protocol_msg);
        }
        if (this.nwTosState == MatchFieldState.MATCH_FIELD_ONLY) {
            byte[] ipv6ext_tos_msg = this.getIPv6ExtensionTOSMatchMsg(this.networkTypeOfService);
            data.put(ipv6ext_tos_msg);
        }
        if (this.tpSrcState == MatchFieldState.MATCH_FIELD_ONLY) {
            byte[] ipv6ext_srcport_msg = null;
            if (this.networkProtocol == IPProtocols.TCP.getValue()) {
                ipv6ext_srcport_msg = this.getIPv6ExtensionTCPSrcPortMatchMsg(this.transportSource);
            } else if (this.networkProtocol == IPProtocols.UDP.getValue()) {
                ipv6ext_srcport_msg = this.getIPv6ExtensionUDPSrcPortMatchMsg(this.transportSource);
            }
            if (ipv6ext_srcport_msg != null) {
                data.put(ipv6ext_srcport_msg);
            }
        }
        if (this.tpDstState == MatchFieldState.MATCH_FIELD_ONLY) {
            byte[] ipv6ext_dstport_msg = null;
            if (this.networkProtocol == IPProtocols.TCP.getValue()) {
                ipv6ext_dstport_msg = this.getIPv6ExtensionTCPDstPortMatchMsg(this.transportDestination);
            } else if (this.networkProtocol == IPProtocols.UDP.getValue()) {
                ipv6ext_dstport_msg = this.getIPv6ExtensionUDPDstPortMatchMsg(this.transportDestination);
            }
            if (ipv6ext_dstport_msg != null) {
                data.put(ipv6ext_dstport_msg);
            }
        }
        logger.trace("{}", (Object)this);
    }

    private void readInPort(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (nxmLen != 2 || data.remaining() < 2 || hasMask) {
            return;
        }
        super.setInputPort(data.getShort());
        this.inputPortState = MatchFieldState.MATCH_FIELD_ONLY;
        this.wildcards ^= 1;
        this.match_len = (short)(this.match_len + 6);
    }

    private void readDataLinkDestination(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (hasMask) {
            if (nxmLen != 12 || data.remaining() < 12) {
                return;
            }
            byte[] bytes = new byte[6];
            data.get(bytes);
            super.setDataLayerDestination(bytes);
            this.dataLayerDestinationMask = new byte[6];
            data.get(this.dataLayerDestinationMask);
            this.dlDestState = MatchFieldState.MATCH_FIELD_WITH_MASK;
            this.match_len = (short)(this.match_len + 16);
        } else {
            if (nxmLen != 6 || data.remaining() < 6) {
                return;
            }
            byte[] bytes = new byte[6];
            data.get(bytes);
            super.setDataLayerDestination(bytes);
            this.dlDestState = MatchFieldState.MATCH_FIELD_ONLY;
            this.match_len = (short)(this.match_len + 10);
        }
        this.wildcards ^= 8;
    }

    private void readDataLinkSource(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (nxmLen != 6 || data.remaining() < 6 || hasMask) {
            return;
        }
        byte[] bytes = new byte[6];
        data.get(bytes);
        super.setDataLayerSource(bytes);
        this.dlSourceState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 10);
        this.wildcards ^= 4;
    }

    private void readEtherType(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (nxmLen != 2 || data.remaining() < 2 || hasMask) {
            return;
        }
        super.setDataLayerType(data.getShort());
        this.ethTypeState = MatchFieldState.MATCH_FIELD_ONLY;
        this.wildcards ^= 0x10;
        this.match_len = (short)(this.match_len + 6);
    }

    private short getVlanID(byte firstByte, byte secondByte) {
        int vlan_id_mask_firstByte = 15;
        int vlan_id_mask_secondByte = 255;
        int vlanPart1 = (firstByte & vlan_id_mask_firstByte) << 8;
        int vlanPart2 = secondByte & vlan_id_mask_secondByte;
        return (short)(vlanPart1 + vlanPart2);
    }

    private byte getVlanPCP(byte pcpByte) {
        int vlan_pcp_mask = 224;
        int pcp_int = pcpByte & vlan_pcp_mask;
        return (byte)(pcp_int >> 5);
    }

    private void readVlanTci(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (hasMask) {
            if (nxmLen != 4 || data.remaining() < 4) {
                return;
            }
            byte firstByte = data.get();
            byte secondByte = data.get();
            this.dataLayerVirtualLanTCIMask = data.getShort() & 0xFFFF;
            if ((this.dataLayerVirtualLanTCIMask & 0xFFF) != 0) {
                super.setDataLayerVirtualLan(this.getVlanID(firstByte, secondByte));
            } else {
                this.wildcards ^= 2;
            }
            if ((this.dataLayerVirtualLanTCIMask & 0xE000) != 0) {
                super.setDataLayerVirtualLanPriorityCodePoint(this.getVlanPCP(firstByte));
            } else {
                this.wildcards ^= 0x100000;
            }
            this.dlVlanTCIState = MatchFieldState.MATCH_FIELD_WITH_MASK;
            this.match_len = (short)(this.match_len + 8);
        } else {
            if (nxmLen != 2 || data.remaining() < 2) {
                return;
            }
            byte firstByte = data.get();
            byte secondByte = data.get();
            super.setDataLayerVirtualLanPriorityCodePoint(this.getVlanPCP(firstByte));
            super.setDataLayerVirtualLan(this.getVlanID(firstByte, secondByte));
            this.dlVlanTCIState = MatchFieldState.MATCH_FIELD_ONLY;
            this.match_len = (short)(this.match_len + 6);
        }
    }

    private void readIpTos(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (nxmLen != 1 || data.remaining() < 1 || hasMask) {
            return;
        }
        super.setNetworkTypeOfService(data.get());
        this.nwTosState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 5);
        this.wildcards ^= 0x200000;
    }

    private void readIpProto(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (nxmLen != 1 || data.remaining() < 1 || hasMask) {
            return;
        }
        super.setNetworkProtocol(data.get());
        this.nwProtoState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 5);
        this.wildcards ^= 0x20;
    }

    private void readIpv4Src(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (hasMask) {
            if (nxmLen != 8 || data.remaining() < 8) {
                return;
            }
            byte[] sbytes = new byte[4];
            data.get(sbytes);
            int address = NetUtils.byteArray4ToInt((byte[])sbytes);
            super.setNetworkSource(address);
            byte[] mbytes = new byte[4];
            data.get(mbytes);
            this.nwSrcState = MatchFieldState.MATCH_FIELD_WITH_MASK;
            this.match_len = (short)(this.match_len + 12);
            int prefixlen = this.getNetworkMaskPrefixLength(mbytes);
            this.wildcards ^= 0x3F00;
            this.wildcards |= 32 - prefixlen << 8;
        } else {
            if (nxmLen != 4 || data.remaining() < 4) {
                return;
            }
            byte[] sbytes = new byte[4];
            data.get(sbytes);
            int address = NetUtils.byteArray4ToInt((byte[])sbytes);
            super.setNetworkSource(address);
            this.nwSrcState = MatchFieldState.MATCH_FIELD_ONLY;
            this.match_len = (short)(this.match_len + 8);
            this.wildcards ^= 0x3F00;
        }
    }

    private void readIpv4Dst(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (hasMask) {
            if (nxmLen != 8 || data.remaining() < 8) {
                return;
            }
            byte[] dbytes = new byte[4];
            data.get(dbytes);
            int address = NetUtils.byteArray4ToInt((byte[])dbytes);
            super.setNetworkDestination(address);
            byte[] mbytes = new byte[4];
            data.get(mbytes);
            this.nwDstState = MatchFieldState.MATCH_FIELD_WITH_MASK;
            this.match_len = (short)(this.match_len + 12);
            int prefixlen = this.getNetworkMaskPrefixLength(mbytes);
            this.wildcards ^= 0xFC000;
            this.wildcards |= 32 - prefixlen << 14;
        } else {
            if (nxmLen != 4 || data.remaining() < 4) {
                return;
            }
            byte[] dbytes = new byte[4];
            data.get(dbytes);
            int address = NetUtils.byteArray4ToInt((byte[])dbytes);
            super.setNetworkDestination(address);
            this.nwDstState = MatchFieldState.MATCH_FIELD_ONLY;
            this.wildcards ^= 0xFC000;
            this.match_len = (short)(this.match_len + 8);
        }
    }

    private void readTcpSrc(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (nxmLen != 2 || data.remaining() < 2 || hasMask) {
            return;
        }
        super.setTransportSource(data.getShort());
        this.tpSrcState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 6);
        this.wildcards ^= 0x40;
    }

    private void readTcpDst(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (nxmLen != 2 || data.remaining() < 2 || hasMask) {
            return;
        }
        super.setTransportDestination(data.getShort());
        this.tpDstState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 6);
        this.wildcards ^= 0x80;
    }

    private void readUdpSrc(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (nxmLen != 2 || data.remaining() < 2 || hasMask) {
            return;
        }
        super.setTransportSource(data.getShort());
        this.tpSrcState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 6);
        this.wildcards ^= 0x40;
    }

    private void readUdpDst(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (nxmLen != 2 || data.remaining() < 2 || hasMask) {
            return;
        }
        super.setTransportDestination(data.getShort());
        this.tpDstState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 6);
        this.wildcards ^= 0x80;
    }

    private void readIpv6Src(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (hasMask) {
            if (nxmLen != 32 || data.remaining() < 32) {
                return;
            }
            byte[] sbytes = new byte[16];
            data.get(sbytes);
            try {
                this.nwSrc = (Inet6Address)InetAddress.getByAddress(sbytes);
            }
            catch (UnknownHostException e) {
                return;
            }
            byte[] mbytes = new byte[16];
            data.get(mbytes);
            this.srcIPv6SubnetMaskbits = (short)NetUtils.getSubnetMaskLength((byte[])mbytes);
            this.nwSrcState = MatchFieldState.MATCH_FIELD_WITH_MASK;
            this.match_len = (short)(this.match_len + 36);
        } else {
            if (nxmLen != 16 || data.remaining() < 16) {
                return;
            }
            byte[] sbytes = new byte[16];
            data.get(sbytes);
            try {
                this.nwSrc = (Inet6Address)InetAddress.getByAddress(sbytes);
            }
            catch (UnknownHostException e) {
                return;
            }
            this.nwSrcState = MatchFieldState.MATCH_FIELD_ONLY;
            this.match_len = (short)(this.match_len + 20);
        }
    }

    private void readIpv6Dst(ByteBuffer data, int nxmLen, boolean hasMask) {
        if (hasMask) {
            if (nxmLen != 32 || data.remaining() < 32) {
                return;
            }
            byte[] dbytes = new byte[16];
            data.get(dbytes);
            try {
                this.nwDst = (Inet6Address)InetAddress.getByAddress(dbytes);
            }
            catch (UnknownHostException e) {
                return;
            }
            byte[] mbytes = new byte[16];
            data.get(mbytes);
            this.dstIPv6SubnetMaskbits = (short)NetUtils.getSubnetMaskLength((byte[])mbytes);
            this.nwDstState = MatchFieldState.MATCH_FIELD_WITH_MASK;
            this.match_len = (short)(this.match_len + 36);
        } else {
            if (nxmLen != 16 || data.remaining() < 16) {
                return;
            }
            byte[] dbytes = new byte[16];
            data.get(dbytes);
            try {
                this.nwDst = (Inet6Address)InetAddress.getByAddress(dbytes);
            }
            catch (UnknownHostException e) {
                return;
            }
            this.nwDstState = MatchFieldState.MATCH_FIELD_ONLY;
            this.match_len = (short)(this.match_len + 20);
        }
    }

    public String toString() {
        return "V6Match [nwSrc=" + this.nwSrc + ", nwDst=" + this.nwDst + ", inputPortMask=" + this.inputPortMask + ", dataLayerSourceMask=" + HexEncode.bytesToHexStringFormat((byte[])this.dataLayerSourceMask) + ", dataLayerDestinationMask=" + HexEncode.bytesToHexStringFormat((byte[])this.dataLayerDestinationMask) + ", dataLayerVirtualLanTCIMask=" + this.dataLayerVirtualLanTCIMask + ", dataLayerTypeMask=" + this.dataLayerTypeMask + ", networkTypeOfServiceMask=" + this.networkTypeOfServiceMask + ", networkProtocolMask=" + this.networkProtocolMask + ", transportSourceMask=" + this.transportSourceMask + ", transportDestinationMask=" + this.transportDestinationMask + ", srcIPv6SubnetMaskbits=" + this.srcIPv6SubnetMaskbits + ", dstIPv6SubnetMaskbits=" + this.dstIPv6SubnetMaskbits + ", inputPortState=" + (Object)((Object)this.inputPortState) + ", dlSourceState=" + (Object)((Object)this.dlSourceState) + ", dlDestState=" + (Object)((Object)this.dlDestState) + ", dlVlanTCIState=" + (Object)((Object)this.dlVlanTCIState) + ", ethTypeState=" + (Object)((Object)this.ethTypeState) + ", nwTosState=" + (Object)((Object)this.nwTosState) + ", nwProtoState=" + (Object)((Object)this.nwProtoState) + ", nwSrcState=" + (Object)((Object)this.nwSrcState) + ", nwDstState=" + (Object)((Object)this.nwDstState) + ", tpSrcState=" + (Object)((Object)this.tpSrcState) + ", tpDstState=" + (Object)((Object)this.tpDstState) + ", match_len=" + this.match_len + ", pad_size=" + this.pad_size + "]";
    }

    public void readFrom(ByteBuffer data) {
        this.readFromInternal(data);
        this.postprocessWildCardInfo();
    }

    private void readFromInternal(ByteBuffer data) {
        this.match_len = 0;
        while (data.remaining() > 0) {
            if (data.remaining() < 4) {
                logger.error("Invalid Vendor Extension Header. Size {}", (Object)data.remaining());
                return;
            }
            short nxmVendor = data.getShort();
            byte b = data.get();
            int nxmField = b >> 1;
            boolean hasMask = (b & 1) == 1;
            byte nxmLen = data.get();
            if (nxmVendor == Extension_Types.OF_10.getValue()) {
                if (nxmField == OF_Match_Types.MATCH_OF_IN_PORT.getValue()) {
                    this.readInPort(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_ETH_DST.getValue()) {
                    this.readDataLinkDestination(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_ETH_SRC.getValue()) {
                    this.readDataLinkSource(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_ETH_TYPE.getValue()) {
                    this.readEtherType(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_VLAN_TCI.getValue()) {
                    this.readVlanTci(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_IP_TOS.getValue()) {
                    this.readIpTos(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_IP_PROTO.getValue()) {
                    this.readIpProto(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_IP_SRC.getValue()) {
                    this.readIpv4Src(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_IP_DST.getValue()) {
                    this.readIpv4Dst(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_TCP_SRC.getValue()) {
                    this.readTcpSrc(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_TCP_DST.getValue()) {
                    this.readTcpDst(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_UDP_SRC.getValue()) {
                    this.readUdpSrc(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == OF_Match_Types.MATCH_OF_UDP_DST.getValue()) {
                    this.readUdpDst(data, nxmLen, hasMask);
                    continue;
                }
                return;
            }
            if (nxmVendor == Extension_Types.IPV6EXT.getValue()) {
                if (nxmField == IPv6Extension_Match_Types.MATCH_IPV6EXT_IPV6_SRC.getValue()) {
                    this.readIpv6Src(data, nxmLen, hasMask);
                    continue;
                }
                if (nxmField == IPv6Extension_Match_Types.MATCH_IPV6EXT_IPV6_DST.getValue()) {
                    this.readIpv6Dst(data, nxmLen, hasMask);
                    continue;
                }
                return;
            }
            return;
        }
    }

    private void postprocessWildCardInfo() {
        if (super.getDataLayerType() == 2048) {
            if ((this.wildcards >> 8 & 0x3F) == 63) {
                this.wildcards ^= 0x1F00;
            }
            if ((this.wildcards >> 14 & 0x3F) == 63) {
                this.wildcards ^= 0x7C000;
            }
        } else {
            this.wildcards = 0;
        }
    }

    public V6Match clone() {
        V6Match ret = (V6Match)super.clone();
        try {
            if (this.nwSrc != null) {
                ret.nwSrc = (Inet6Address)InetAddress.getByAddress(this.nwSrc.getAddress());
            }
            if (this.nwDst != null) {
                ret.nwDst = (Inet6Address)InetAddress.getByAddress(this.nwDst.getAddress());
            }
            return ret;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public Inet6Address getNetworkDest() {
        return this.nwDst;
    }

    public Inet6Address getNetworkSrc() {
        return this.nwSrc;
    }

    private int getNetworkMaskPrefixLength(byte[] netMask) {
        ByteBuffer nm = ByteBuffer.wrap(netMask);
        int trailingZeros = Integer.numberOfTrailingZeros(nm.getInt());
        return 32 - trailingZeros;
    }

    public short getInputPortMask() {
        return this.inputPortMask;
    }

    public void setInputPort(short port, short mask) {
        this.inputPort = port;
        this.inputPortState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 6);
    }

    public byte[] getDataLayerSourceMask() {
        return this.dataLayerSourceMask;
    }

    public void setDataLayerSource(byte[] mac, byte[] mask) {
        if (mac != null) {
            System.arraycopy(mac, 0, this.dataLayerSource, 0, mac.length);
        }
        if (mask == null) {
            this.dlSourceState = MatchFieldState.MATCH_FIELD_ONLY;
            this.match_len = (short)(this.match_len + 10);
        } else {
            if (this.dataLayerSourceMask == null) {
                this.dataLayerSourceMask = new byte[mask.length];
            }
            System.arraycopy(mask, 0, this.dataLayerSourceMask, 0, mask.length);
            this.dlSourceState = MatchFieldState.MATCH_FIELD_WITH_MASK;
            this.match_len = (short)(this.match_len + 16);
        }
    }

    public byte[] getDataLayerDestinationMask() {
        return this.dataLayerDestinationMask;
    }

    public void setDataLayerDestination(byte[] mac, byte[] mask) {
        if (mac != null) {
            System.arraycopy(mac, 0, this.dataLayerDestination, 0, mac.length);
        }
        if (mask == null) {
            this.dlDestState = MatchFieldState.MATCH_FIELD_ONLY;
            this.match_len = (short)(this.match_len + 10);
        } else {
            if (this.dataLayerDestinationMask == null) {
                this.dataLayerDestinationMask = new byte[mask.length];
            }
            System.arraycopy(mask, 0, this.dataLayerDestinationMask, 0, mask.length);
            this.dlDestState = MatchFieldState.MATCH_FIELD_WITH_MASK;
            this.match_len = (short)(this.match_len + 16);
        }
    }

    public void setDataLayerVirtualLan(short vlan, short mask) {
        this.dataLayerVirtualLan = vlan;
        this.dlVlanIDState = MatchFieldState.MATCH_FIELD_ONLY;
        if (this.dlVlanPCPState != MatchFieldState.MATCH_ABSENT) {
            this.dlVlanTCIState = MatchFieldState.MATCH_FIELD_ONLY;
            this.match_len = (short)(this.match_len - 2);
        } else {
            this.dlVlanTCIState = MatchFieldState.MATCH_FIELD_WITH_MASK;
            this.dataLayerVirtualLanTCIMask = 8191;
            this.match_len = (short)(this.match_len + 8);
        }
    }

    public void setDataLayerVirtualLanPriorityCodePoint(byte pcp, byte mask) {
        this.dataLayerVirtualLanPriorityCodePoint = pcp;
        this.dlVlanPCPState = MatchFieldState.MATCH_FIELD_ONLY;
        if (this.dlVlanIDState != MatchFieldState.MATCH_ABSENT) {
            this.dlVlanTCIState = MatchFieldState.MATCH_FIELD_ONLY;
            this.match_len = (short)(this.match_len - 2);
        } else {
            this.dlVlanTCIState = MatchFieldState.MATCH_FIELD_WITH_MASK;
            this.dataLayerVirtualLanTCIMask = 61440;
            this.match_len = (short)(this.match_len + 8);
        }
    }

    public void setDataLayerType(short ethType, short mask) {
        this.dataLayerType = ethType;
        this.ethTypeState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 6);
    }

    public void setNetworkTypeOfService(byte tos, byte mask) {
        this.networkTypeOfService = tos;
        this.nwTosState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 5);
    }

    public void setNetworkProtocol(byte ipProto, byte mask) {
        this.networkProtocol = ipProto;
        this.nwProtoState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 5);
    }

    public Inet6Address getNetworkSourceMask() {
        return this.nwSrcState == MatchFieldState.MATCH_FIELD_WITH_MASK ? (Inet6Address)NetUtils.getInetNetworkMask((int)this.srcIPv6SubnetMaskbits, (boolean)true) : null;
    }

    public void setNetworkSource(InetAddress address, InetAddress mask) {
        if (address instanceof Inet6Address) {
            this.nwSrc = (Inet6Address)address;
            if (mask == null) {
                this.nwSrcState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + (address instanceof Inet6Address ? 20 : 8));
            } else {
                this.srcIPv6SubnetMaskbits = (short)NetUtils.getSubnetMaskLength((InetAddress)mask);
                this.nwSrcState = MatchFieldState.MATCH_FIELD_WITH_MASK;
                this.match_len = (short)(this.match_len + (address instanceof Inet6Address ? 36 : 12));
            }
        } else {
            super.setNetworkSource(NetUtils.byteArray4ToInt((byte[])address.getAddress()));
            this.wildcards ^= 0x3F00;
            if (mask == null) {
                this.nwSrcState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + 8);
            } else {
                this.nwSrcState = MatchFieldState.MATCH_FIELD_WITH_MASK;
                this.match_len = (short)(this.match_len + 12);
                this.wildcards |= 32 - NetUtils.getSubnetMaskLength((InetAddress)mask) << 8;
            }
        }
    }

    public Inet6Address getNetworkDestinationMask() {
        return this.nwDstState == MatchFieldState.MATCH_FIELD_WITH_MASK ? (Inet6Address)NetUtils.getInetNetworkMask((int)this.dstIPv6SubnetMaskbits, (boolean)true) : null;
    }

    public void setNetworkDestination(InetAddress address, InetAddress mask) {
        if (address instanceof Inet6Address) {
            this.nwDst = (Inet6Address)address;
            if (mask == null) {
                this.nwDstState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + (address instanceof Inet6Address ? 20 : 8));
            } else {
                this.dstIPv6SubnetMaskbits = (short)NetUtils.getSubnetMaskLength((InetAddress)mask);
                this.nwDstState = MatchFieldState.MATCH_FIELD_WITH_MASK;
                this.match_len = (short)(this.match_len + (address instanceof Inet6Address ? 36 : 12));
            }
        } else {
            this.setNetworkDestination(NetUtils.byteArray4ToInt((byte[])address.getAddress()));
            this.wildcards ^= 0xFC000;
            if (mask == null) {
                this.nwDstState = MatchFieldState.MATCH_FIELD_ONLY;
                this.match_len = (short)(this.match_len + 8);
            } else {
                this.nwDstState = MatchFieldState.MATCH_FIELD_WITH_MASK;
                this.match_len = (short)(this.match_len + 12);
                this.wildcards |= 32 - NetUtils.getSubnetMaskLength((InetAddress)mask) << 14;
            }
        }
    }

    public void setTransportSource(short tpSrc, short mask) {
        this.transportSource = tpSrc;
        this.tpSrcState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 6);
    }

    public short getTransportDestinationMask() {
        return this.transportDestinationMask;
    }

    public void setTransportDestination(short tpDst, short mask) {
        this.transportDestination = tpDst;
        this.tpDstState = MatchFieldState.MATCH_FIELD_ONLY;
        this.match_len = (short)(this.match_len + 6);
    }

    private byte[] getIPv6NetworkMaskinBytes(short num) {
        int i;
        byte[] nbytes = new byte[16];
        int quot = num / 8;
        int bits = num % 8;
        for (i = 0; i < quot; ++i) {
            nbytes[i] = -1;
        }
        if (bits > 0) {
            nbytes[i] = -1;
            int n = i;
            nbytes[n] = (byte)(nbytes[n] << 8 - bits);
        }
        return nbytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.dataLayerDestinationMask);
        result = 31 * result + Arrays.hashCode(this.dataLayerSourceMask);
        result = 31 * result + this.dataLayerTypeMask;
        result = 31 * result + this.dataLayerVirtualLanTCIMask;
        result = 31 * result + (this.dlDestState == null ? 0 : this.dlDestState.hashCode());
        result = 31 * result + (this.dlSourceState == null ? 0 : this.dlSourceState.hashCode());
        result = 31 * result + (this.dlVlanTCIState == null ? 0 : this.dlVlanTCIState.hashCode());
        result = 31 * result + this.dstIPv6SubnetMaskbits;
        result = 31 * result + (this.ethTypeState == null ? 0 : this.ethTypeState.hashCode());
        result = 31 * result + this.inputPortMask;
        result = 31 * result + (this.inputPortState == null ? 0 : this.inputPortState.hashCode());
        result = 31 * result + this.match_len;
        result = 31 * result + this.networkProtocolMask;
        result = 31 * result + this.networkTypeOfServiceMask;
        result = 31 * result + (this.nwDst == null ? 0 : this.nwDst.hashCode());
        result = 31 * result + (this.nwDstState == null ? 0 : this.nwDstState.hashCode());
        result = 31 * result + (this.nwProtoState == null ? 0 : this.nwProtoState.hashCode());
        result = 31 * result + (this.nwSrc == null ? 0 : this.nwSrc.hashCode());
        result = 31 * result + (this.nwSrcState == null ? 0 : this.nwSrcState.hashCode());
        result = 31 * result + (this.nwTosState == null ? 0 : this.nwTosState.hashCode());
        result = 31 * result + this.pad_size;
        result = 31 * result + this.srcIPv6SubnetMaskbits;
        result = 31 * result + (this.tpDstState == null ? 0 : this.tpDstState.hashCode());
        result = 31 * result + (this.tpSrcState == null ? 0 : this.tpSrcState.hashCode());
        result = 31 * result + this.transportDestinationMask;
        result = 31 * result + this.transportSourceMask;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        V6Match other = (V6Match)obj;
        if (!Arrays.equals(this.dataLayerDestinationMask, other.dataLayerDestinationMask)) {
            return false;
        }
        if (!Arrays.equals(this.dataLayerSourceMask, other.dataLayerSourceMask)) {
            return false;
        }
        if (this.dataLayerTypeMask != other.dataLayerTypeMask) {
            return false;
        }
        if (this.dataLayerVirtualLanTCIMask != other.dataLayerVirtualLanTCIMask) {
            return false;
        }
        if (this.dlVlanTCIState != other.dlVlanTCIState) {
            return false;
        }
        if (this.dlSourceState != other.dlSourceState) {
            return false;
        }
        if (this.dstIPv6SubnetMaskbits != other.dstIPv6SubnetMaskbits) {
            return false;
        }
        if (this.ethTypeState != other.ethTypeState) {
            return false;
        }
        if (this.inputPortMask != other.inputPortMask) {
            return false;
        }
        if (this.inputPortState != other.inputPortState) {
            return false;
        }
        if (this.match_len != other.match_len) {
            return false;
        }
        if (this.networkProtocolMask != other.networkProtocolMask) {
            return false;
        }
        if (this.networkTypeOfServiceMask != other.networkTypeOfServiceMask) {
            return false;
        }
        if (this.nwDst == null ? other.nwDst != null : !this.nwDst.equals(other.nwDst)) {
            return false;
        }
        if (this.nwDstState != other.nwDstState) {
            return false;
        }
        if (this.nwProtoState != other.nwProtoState) {
            return false;
        }
        if (this.nwSrc == null ? other.nwSrc != null : !this.nwSrc.equals(other.nwSrc)) {
            return false;
        }
        if (this.nwSrcState != other.nwSrcState) {
            return false;
        }
        if (this.nwTosState != other.nwTosState) {
            return false;
        }
        if (this.pad_size != other.pad_size) {
            return false;
        }
        if (this.srcIPv6SubnetMaskbits != other.srcIPv6SubnetMaskbits) {
            return false;
        }
        if (this.tpDstState != other.tpDstState) {
            return false;
        }
        if (this.tpSrcState != other.tpSrcState) {
            return false;
        }
        if (this.transportDestinationMask != other.transportDestinationMask) {
            return false;
        }
        return this.transportSourceMask == other.transportSourceMask;
    }

    private static enum IPProtocols {
        ICMP(1),
        TCP(6),
        UDP(17),
        ICMPV6(58);

        private int protocol;

        private IPProtocols(int value) {
            this.protocol = value;
        }

        private byte getValue() {
            return (byte)this.protocol;
        }
    }

    public static enum Extension_Types {
        OF_10(0),
        IPV6EXT(1);

        protected int value;

        private Extension_Types(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static enum IPv6Extension_Match_Types {
        MATCH_IPV6EXT_TUN_ID(16),
        MATCH_IPV6EXT_ARP_SHA(17),
        MATCH_IPV6EXT_ARP_THA(18),
        MATCH_IPV6EXT_IPV6_SRC(19),
        MATCH_IPV6EXT_IPV6_DST(20);

        private int value;

        private IPv6Extension_Match_Types(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static enum OF_Match_Types {
        MATCH_OF_IN_PORT(0),
        MATCH_OF_ETH_DST(1),
        MATCH_OF_ETH_SRC(2),
        MATCH_OF_ETH_TYPE(3),
        MATCH_OF_VLAN_TCI(4),
        MATCH_OF_IP_TOS(5),
        MATCH_OF_IP_PROTO(6),
        MATCH_OF_IP_SRC(7),
        MATCH_OF_IP_DST(8),
        MATCH_OF_TCP_SRC(9),
        MATCH_OF_TCP_DST(10),
        MATCH_OF_UDP_SRC(11),
        MATCH_OF_UDP_DST(12),
        MATCH_OF_ICMTP_TYPE(13),
        MATCH_OF_ICMP_CODE(14),
        MATCH_OF_ARP_OP(15);

        private int value;

        private OF_Match_Types(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static enum MatchFieldState {
        MATCH_ABSENT,
        MATCH_FIELD_ONLY,
        MATCH_FIELD_WITH_MASK;

    }
}

