/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension.V6Match;
import org.openflow.protocol.OFPacketOut;
import org.openflow.protocol.OFPort;
import org.openflow.protocol.OFVendor;
import org.openflow.protocol.action.OFAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V6FlowMod
extends OFVendor
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(V6FlowMod.class);
    private static final long serialVersionUID = 1L;
    protected V6Match match;
    protected long cookie;
    protected short command;
    protected short idleTimeout;
    protected short hardTimeout;
    protected short priority;
    protected int bufferId;
    protected short outPort;
    protected short flags;
    protected List<OFAction> actions;
    short match_len;
    short actions_len;
    short pad_size;
    private static int IPV6EXT_ADD_FLOW_MSG_TYPE = 13;
    private static int IPV6_EXT_MIN_HDR_LEN = 36;

    public void setMatch(V6Match match) {
        this.match = match;
    }

    public void setActions(List<OFAction> actions) {
        this.actions = actions;
    }

    public void setPriority(short priority) {
        this.priority = priority;
    }

    public void setCookie(long cookie) {
        this.cookie = cookie;
    }

    public V6FlowMod setCommand(short command) {
        this.command = command;
        return this;
    }

    public V6FlowMod setOutPort(OFPort port) {
        this.outPort = port.getValue();
        return this;
    }

    public void setIdleTimeout(short idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setHardTimeout(short hardTimeout) {
        this.hardTimeout = hardTimeout;
    }

    private int getIPv6ExtensionFlowModAddSubType() {
        return IPV6EXT_ADD_FLOW_MSG_TYPE;
    }

    public int getV6FlowModMinHdrSize() {
        return IPV6_EXT_MIN_HDR_LEN;
    }

    public void setVendor() {
        super.setVendor(8992);
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putInt(this.getIPv6ExtensionFlowModAddSubType());
        data.putLong(this.cookie);
        data.putShort(this.command);
        data.putShort(this.idleTimeout);
        data.putShort(this.hardTimeout);
        data.putShort(this.priority);
        data.putInt(OFPacketOut.BUFFER_ID_NONE);
        data.putShort(this.outPort);
        data.putShort(this.flags);
        this.match_len = this.match.getIPv6MatchLen();
        data.putShort(this.match_len);
        byte[] pad = new byte[6];
        data.put(pad);
        this.match.writeTo(data);
        this.pad_size = (short)((this.match_len + 7) / 8 * 8 - this.match_len);
        byte[] pad2 = new byte[this.pad_size];
        data.put(pad2);
        if (this.actions != null) {
            for (OFAction action : this.actions) {
                this.actions_len = (short)(this.actions_len + action.getLength());
                action.writeTo(data);
            }
        }
        logger.trace("{}", (Object)this);
    }

    public V6FlowMod clone() {
        try {
            V6Match neoMatch = this.match.clone();
            V6FlowMod v6flowMod = (V6FlowMod)super.clone();
            v6flowMod.setMatch(neoMatch);
            LinkedList<OFAction> neoActions = new LinkedList<OFAction>();
            for (OFAction action : this.actions) {
                neoActions.add(action.clone());
            }
            v6flowMod.setActions(neoActions);
            return v6flowMod;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "V6FlowMod [match=" + this.match + ", cookie=" + this.cookie + ", command=" + this.command + ", idleTimeout=" + this.idleTimeout + ", hardTimeout=" + this.hardTimeout + ", priority=" + this.priority + ", bufferId=" + this.bufferId + ", outPort=" + this.outPort + ", flags=" + this.flags + ", actions=" + this.actions + ", match_len=" + this.match_len + ", actions_len=" + this.actions_len + ", pad_size=" + this.pad_size + "]";
    }
}

