/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.openflow.protocol.OFError;

public class V6Error
extends OFError {
    private static final long serialVersionUID = 1L;
    public static int MINIMUM_LENGTH = 20;
    public static final short NICIRA_VENDOR_ERRORTYPE = -20286;
    protected int V6VendorId;
    protected short V6VendorErrorType;
    protected short V6VendorErrorCode;
    protected byte[] V6ErrorData;

    public V6Error(OFError e) {
        this.length = (short)e.getLengthU();
        this.errorType = e.getErrorType();
        this.errorCode = e.getErrorCode();
        this.xid = e.getXid();
    }

    public void readFrom(ByteBuffer data) {
        this.V6VendorId = data.getInt();
        this.V6VendorErrorType = data.getShort();
        this.V6VendorErrorCode = data.getShort();
        int dataLength = this.getLengthU() - MINIMUM_LENGTH;
        if (dataLength > 0) {
            this.V6ErrorData = new byte[dataLength];
            data.get(this.V6ErrorData);
        }
    }

    public int getVendorId() {
        return this.V6VendorId;
    }

    public short getVendorErrorType() {
        return this.V6VendorErrorType;
    }

    public short getVendorErrorCode() {
        return this.V6VendorErrorCode;
    }

    public byte[] getError() {
        return this.V6ErrorData;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.V6ErrorData);
        result = 31 * result + this.V6VendorErrorCode;
        result = 31 * result + this.V6VendorErrorType;
        result = 31 * result + this.V6VendorId;
        return result;
    }

    public String toString() {
        return "V6Error [V6VendorId=" + this.V6VendorId + ", V6VendorErrorType=" + this.V6VendorErrorType + ", V6VendorErrorCode=" + this.V6VendorErrorCode + ", V6ErrorData=" + Arrays.toString(this.V6ErrorData) + ", errorType=" + this.errorType + ", errorCode=" + this.errorCode + ", factory=" + this.factory + ", error=" + Arrays.toString(this.error) + ", errorIsAscii=" + this.errorIsAscii + ", version=" + this.version + ", type=" + this.type + ", length=" + this.length + ", xid=" + this.xid + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        V6Error other = (V6Error)((Object)obj);
        if (!Arrays.equals(this.V6ErrorData, other.V6ErrorData)) {
            return false;
        }
        if (this.V6VendorErrorCode != other.V6VendorErrorCode) {
            return false;
        }
        if (this.V6VendorErrorType != other.V6VendorErrorType) {
            return false;
        }
        return this.V6VendorId == other.V6VendorId;
    }
}

