/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.nio.ByteBuffer;
import org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension.V6Error;
import org.openflow.protocol.OFError;

public final class Utils {
    private Utils() {
        throw new AssertionError();
    }

    static String getOFErrorString(OFError error) {
        if (error.getErrorType() == -20286) {
            V6Error er = new V6Error(error);
            byte[] b = error.getError();
            ByteBuffer bb = ByteBuffer.allocate(b.length);
            bb.put(b);
            bb.rewind();
            er.readFrom(bb);
            return er.toString();
        }
        OFError.OFErrorType et = OFError.OFErrorType.values()[0xFFFF & error.getErrorType()];
        String errorStr = "Error : " + et.toString();
        switch (et) {
            case OFPET_HELLO_FAILED: {
                OFError.OFHelloFailedCode hfc = OFError.OFHelloFailedCode.values()[0xFFFF & error.getErrorCode()];
                errorStr = errorStr + " " + hfc.toString();
                break;
            }
            case OFPET_BAD_REQUEST: {
                OFError.OFBadRequestCode brc = OFError.OFBadRequestCode.values()[0xFFFF & error.getErrorCode()];
                errorStr = errorStr + " " + brc.toString();
                break;
            }
            case OFPET_BAD_ACTION: {
                OFError.OFBadActionCode bac = OFError.OFBadActionCode.values()[0xFFFF & error.getErrorCode()];
                errorStr = errorStr + " " + bac.toString();
                break;
            }
            case OFPET_FLOW_MOD_FAILED: {
                OFError.OFFlowModFailedCode fmfc = OFError.OFFlowModFailedCode.values()[0xFFFF & error.getErrorCode()];
                errorStr = errorStr + " " + fmfc.toString();
                break;
            }
            case OFPET_PORT_MOD_FAILED: {
                OFError.OFPortModFailedCode pmfc = OFError.OFPortModFailedCode.values()[0xFFFF & error.getErrorCode()];
                errorStr = errorStr + " " + pmfc.toString();
                break;
            }
            case OFPET_QUEUE_OP_FAILED: {
                OFError.OFQueueOpFailedCode qofc = OFError.OFQueueOpFailedCode.values()[0xFFFF & error.getErrorCode()];
                errorStr = errorStr + " " + qofc.toString();
                break;
            }
        }
        return errorStr;
    }
}

