/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.Dictionary;
import java.util.List;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.protocol_plugin.openflow.IRefreshInternalProvider;
import org.opendaylight.controller.protocol_plugin.openflow.ITopologyServiceShimListener;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.topology.IPluginInTopologyService;
import org.opendaylight.controller.sal.topology.IPluginOutTopologyService;
import org.opendaylight.controller.sal.topology.TopoEdgeUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyServices
implements ITopologyServiceShimListener,
IPluginInTopologyService {
    protected static final Logger logger = LoggerFactory.getLogger(TopologyServices.class);
    private IPluginOutTopologyService salTopoService = null;
    private IRefreshInternalProvider topoRefreshService = null;
    private String containerName;

    void init(Component c) {
        logger.trace("INIT called!");
        Dictionary props = c.getServiceProperties();
        this.containerName = props != null ? (String)props.get("containerName") : null;
    }

    void destroy() {
        logger.trace("DESTROY called!");
    }

    void start() {
        logger.trace("START called!");
    }

    void stop() {
        logger.trace("STOP called!");
    }

    public void setPluginOutTopologyService(IPluginOutTopologyService s) {
        logger.trace("Setting IPluginOutTopologyService to: {}", (Object)s);
        this.salTopoService = s;
    }

    public void unsetPluginOutTopologyService(IPluginOutTopologyService s) {
        if (this.salTopoService == s) {
            logger.trace("UNSetting IPluginOutTopologyService from: {}", (Object)s);
            this.salTopoService = null;
        }
    }

    public void setRefreshInternalProvider(IRefreshInternalProvider s) {
        logger.trace("Setting IRefreshInternalProvider to: {}", (Object)s);
        this.topoRefreshService = s;
    }

    public void unsetRefreshInternalProvider(IRefreshInternalProvider s) {
        if (this.topoRefreshService == s) {
            logger.trace("UNSetting IRefreshInternalProvider from: {}", (Object)s);
            this.topoRefreshService = null;
        }
    }

    @Override
    public void edgeUpdate(List<TopoEdgeUpdate> topoedgeupdateList) {
        if (this.salTopoService != null) {
            this.salTopoService.edgeUpdate(topoedgeupdateList);
        }
    }

    public void sollicitRefresh() {
        logger.debug("Got a request to refresh topology");
        this.topoRefreshService.requestRefresh(this.containerName);
    }

    @Override
    public void edgeOverUtilized(Edge edge) {
        if (this.salTopoService != null) {
            this.salTopoService.edgeOverUtilized(edge);
        }
    }

    @Override
    public void edgeUtilBackToNormal(Edge edge) {
        if (this.salTopoService != null) {
            this.salTopoService.edgeUtilBackToNormal(edge);
        }
    }
}

