/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.protocol_plugin.openflow.IDiscoveryListener;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryShimExternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.IOFStatisticsManager;
import org.opendaylight.controller.protocol_plugin.openflow.IRefreshInternalProvider;
import org.opendaylight.controller.protocol_plugin.openflow.ITopologyServiceShimListener;
import org.opendaylight.controller.sal.core.Bandwidth;
import org.opendaylight.controller.sal.core.Config;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.IContainerAware;
import org.opendaylight.controller.sal.core.IContainerListener;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.State;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.topology.TopoEdgeUpdate;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyServiceShim
implements IDiscoveryListener,
IContainerListener,
CommandProvider,
IRefreshInternalProvider,
IInventoryShimExternalListener,
IContainerAware {
    protected static final Logger logger = LoggerFactory.getLogger(TopologyServiceShim.class);
    private ConcurrentMap<String, ITopologyServiceShimListener> topologyServiceShimListeners = new ConcurrentHashMap<String, ITopologyServiceShimListener>();
    private ConcurrentMap<NodeConnector, List<String>> containerMap = new ConcurrentHashMap<NodeConnector, List<String>>();
    private ConcurrentMap<String, ConcurrentMap<NodeConnector, Pair<Edge, Set<Property>>>> edgeMap = new ConcurrentHashMap<String, ConcurrentMap<NodeConnector, Pair<Edge, Set<Property>>>>();
    private BlockingQueue<NotifyEntry> notifyQ;
    private Thread notifyThread;
    private BlockingQueue<String> bulkNotifyQ;
    private Thread ofPluginTopoBulkUpdate;
    private volatile Boolean shuttingDown = false;
    private IOFStatisticsManager statsMgr;
    private Timer pollTimer;
    private TimerTask txRatePoller;
    private Thread bwUtilNotifyThread;
    private BlockingQueue<UtilizationUpdate> bwUtilNotifyQ;
    private List<NodeConnector> connectorsOverUtilized;
    private float bwThresholdFactor = 0.8f;

    void init() {
        logger.trace("Init called");
        this.connectorsOverUtilized = new ArrayList<NodeConnector>();
        this.notifyQ = new LinkedBlockingQueue<NotifyEntry>();
        this.notifyThread = new Thread(new TopologyNotify(this.notifyQ));
        this.bwUtilNotifyQ = new LinkedBlockingQueue<UtilizationUpdate>();
        this.bwUtilNotifyThread = new Thread(new BwUtilizationNotify(this.bwUtilNotifyQ));
        this.bulkNotifyQ = new LinkedBlockingQueue<String>();
        this.ofPluginTopoBulkUpdate = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            String containerName = (String)TopologyServiceShim.this.bulkNotifyQ.take();
                            logger.debug("Bulk Notify container:{}", (Object)containerName);
                            TopologyServiceShim.this.TopologyBulkUpdate(containerName);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.warn("Topology Bulk update thread interrupted");
                        if (!TopologyServiceShim.this.shuttingDown.booleanValue()) continue;
                        return;
                    }
                    break;
                }
            }
        }, "Topology Bulk Update");
        this.pollTimer = new Timer();
        this.txRatePoller = new TimerTask(){

            @Override
            public void run() {
                TopologyServiceShim.this.pollTxBitRates();
            }
        };
        this.registerWithOSGIConsole();
    }

    protected void pollTxBitRates() {
        Map globalContainerEdges = (Map)this.edgeMap.get(GlobalConstants.DEFAULT.toString());
        if (globalContainerEdges == null) {
            return;
        }
        for (NodeConnector connector : globalContainerEdges.keySet()) {
            Set propSet;
            Pair props;
            if (connector.getType().equals(NodeConnector.NodeConnectorIDType.PRODUCTION) || (props = (Pair)((ConcurrentMap)this.edgeMap.get(GlobalConstants.DEFAULT.toString())).get(connector)) == null || (propSet = (Set)props.getRight()) == null) continue;
            float bw = 0.0f;
            for (Property prop : propSet) {
                if (!(prop instanceof Bandwidth)) continue;
                bw = ((Bandwidth)prop).getValue();
                break;
            }
            if (bw == 0.0f) continue;
            Long switchId = (Long)connector.getNode().getID();
            Short port = (Short)connector.getID();
            if (this.statsMgr == null) continue;
            float rate = this.statsMgr.getTransmitRate(switchId, port);
            if (rate > this.bwThresholdFactor * bw) {
                if (this.connectorsOverUtilized.contains(connector)) continue;
                this.connectorsOverUtilized.add(connector);
                this.bwUtilNotifyQ.add(new UtilizationUpdate(connector, UpdateType.ADDED));
                continue;
            }
            if (!this.connectorsOverUtilized.contains(connector)) continue;
            this.connectorsOverUtilized.remove(connector);
            this.bwUtilNotifyQ.add(new UtilizationUpdate(connector, UpdateType.REMOVED));
        }
    }

    void destroy() {
        logger.trace("DESTROY called!");
        this.notifyQ = null;
        this.notifyThread = null;
    }

    void start() {
        logger.trace("START called!");
        this.notifyThread.start();
        this.bwUtilNotifyThread.start();
        this.ofPluginTopoBulkUpdate.start();
        this.pollTimer.scheduleAtFixedRate(this.txRatePoller, 10000L, 5000L);
    }

    void stop() {
        logger.trace("STOP called!");
        this.shuttingDown = true;
        this.notifyThread.interrupt();
    }

    void setTopologyServiceShimListener(Map<?, ?> props, ITopologyServiceShimListener s) {
        if (props == null) {
            logger.error("Didn't receive the service properties");
            return;
        }
        String containerName = (String)props.get("containerName");
        if (containerName == null) {
            logger.error("containerName not supplied");
            return;
        }
        if (this.topologyServiceShimListeners != null && !this.topologyServiceShimListeners.containsKey(containerName)) {
            this.topologyServiceShimListeners.put(containerName, s);
            logger.trace("Added topologyServiceShimListener for container: {}", (Object)containerName);
        }
    }

    void unsetTopologyServiceShimListener(Map<?, ?> props, ITopologyServiceShimListener s) {
        if (props == null) {
            logger.error("Didn't receive the service properties");
            return;
        }
        String containerName = (String)props.get("containerName");
        if (containerName == null) {
            logger.error("containerName not supplied");
            return;
        }
        if (this.topologyServiceShimListeners != null && this.topologyServiceShimListeners.containsKey(containerName) && ((ITopologyServiceShimListener)this.topologyServiceShimListeners.get(containerName)).equals(s)) {
            this.topologyServiceShimListeners.remove(containerName);
            logger.trace("Removed topologyServiceShimListener for container: {}", (Object)containerName);
        }
    }

    void setStatisticsManager(IOFStatisticsManager s) {
        this.statsMgr = s;
    }

    void unsetStatisticsManager(IOFStatisticsManager s) {
        if (this.statsMgr == s) {
            this.statsMgr = null;
        }
    }

    private void updateContainerMap(List<String> containers, NodeConnector p) {
        if (containers.isEmpty()) {
            this.containerMap.remove(p);
        } else {
            this.containerMap.put(p, containers);
        }
    }

    private Edge addEdge(String container, NodeConnector nodeConnector, Map<NodeConnector, Pair<Edge, Set<Property>>> edges) {
        logger.debug("Search edge sourced by port {} in container {}", (Object)nodeConnector, (Object)container);
        Pair<Edge, Set<Property>> edgeProps = edges.get(nodeConnector);
        if (edgeProps == null) {
            logger.debug("edgePros is null for port {} in container {}", (Object)nodeConnector, (Object)container);
            return null;
        }
        Edge edge = (Edge)edgeProps.getLeft();
        if (edge == null) {
            logger.debug("edge is null for port {} in container {}", (Object)nodeConnector, (Object)container);
            return null;
        }
        NodeConnector peerConnector = edge.getHeadNodeConnector();
        List containers = (List)this.containerMap.get(peerConnector);
        if (containers == null || !containers.contains(container)) {
            logger.debug("peer port {} of edge {} is not part of the container {}", new Object[]{peerConnector, edge, container});
            return null;
        }
        this.updateLocalEdgeMap(container, edge, UpdateType.ADDED, (Set)edgeProps.getRight());
        logger.debug("Added edge {} to local cache in container {}", (Object)edge, (Object)container);
        return edge;
    }

    private void addNodeConnector(String container, NodeConnector nodeConnector) {
        Map globalEdgeMap = (Map)this.edgeMap.get(GlobalConstants.DEFAULT.toString());
        if (globalEdgeMap == null) {
            return;
        }
        Edge edge1 = this.addEdge(container, nodeConnector, globalEdgeMap);
        if (edge1 == null) {
            return;
        }
        NodeConnector peerConnector = edge1.getHeadNodeConnector();
        Edge edge2 = this.addEdge(container, peerConnector, globalEdgeMap);
        ArrayList<TopoEdgeUpdate> teuList = new ArrayList<TopoEdgeUpdate>();
        teuList.add(new TopoEdgeUpdate(edge1, null, UpdateType.ADDED));
        logger.debug("Notify edge1: {} in container {}", (Object)edge1, (Object)container);
        if (edge2 != null) {
            teuList.add(new TopoEdgeUpdate(edge2, null, UpdateType.ADDED));
            logger.debug("Notify edge2: {} in container {}", (Object)edge2, (Object)container);
        }
        this.notifyEdge(container, teuList);
    }

    private void removeNodeConnector(String container, NodeConnector nodeConnector) {
        ArrayList<TopoEdgeUpdate> teuList = new ArrayList<TopoEdgeUpdate>();
        Map edgePropsMap = (Map)this.edgeMap.get(container);
        if (edgePropsMap == null) {
            return;
        }
        Pair edgeProps = (Pair)edgePropsMap.get(nodeConnector);
        if (edgeProps == null) {
            return;
        }
        teuList.add(new TopoEdgeUpdate((Edge)edgeProps.getLeft(), null, UpdateType.REMOVED));
        edgeProps = (Pair)edgePropsMap.get(((Edge)edgeProps.getLeft()).getHeadNodeConnector());
        if (edgeProps == null) {
            return;
        }
        teuList.add(new TopoEdgeUpdate((Edge)edgeProps.getLeft(), null, UpdateType.REMOVED));
        this.notifyEdge(container, teuList);
    }

    private boolean updateLocalEdgeMap(String container, Edge edge, UpdateType type, Set<Property> props) {
        ConcurrentHashMap<NodeConnector, ImmutablePair> edgePropsMap = (ConcurrentHashMap<NodeConnector, ImmutablePair>)this.edgeMap.get(container);
        NodeConnector src = edge.getTailNodeConnector();
        ImmutablePair edgeProps = new ImmutablePair((Object)edge, props);
        boolean rv = false;
        switch (type) {
            case ADDED: 
            case CHANGED: {
                if (edgePropsMap == null) {
                    edgePropsMap = new ConcurrentHashMap<NodeConnector, ImmutablePair>();
                    rv = true;
                } else {
                    rv = !edgePropsMap.containsKey(src) || !((Pair)edgePropsMap.get(src)).equals((Object)edgeProps);
                }
                if (!rv) break;
                edgePropsMap.put(src, edgeProps);
                this.edgeMap.put(container, edgePropsMap);
                break;
            }
            case REMOVED: {
                if (edgePropsMap == null || !edgePropsMap.containsKey(src)) break;
                edgePropsMap.remove(src);
                if (edgePropsMap.isEmpty()) {
                    this.edgeMap.remove(container);
                } else {
                    this.edgeMap.put(container, edgePropsMap);
                }
                rv = true;
                break;
            }
            default: {
                logger.debug("notifyLocalEdgeMap: invalid {} for Edge {} in container {}", new Object[]{type.getName(), edge, container});
            }
        }
        if (rv) {
            logger.debug("notifyLocalEdgeMap: {} for Edge {} in container {}", new Object[]{type.getName(), edge, container});
        }
        return rv;
    }

    private void notifyEdge(String container, Edge edge, UpdateType type, Set<Property> props) {
        boolean notifyListeners = this.updateLocalEdgeMap(container, edge, type, props);
        if (notifyListeners) {
            this.notifyQ.add(new NotifyEntry(container, new TopoEdgeUpdate(edge, props, type)));
            logger.debug("notifyEdge: {} Edge {} in container {}", new Object[]{type.getName(), edge, container});
        }
    }

    private void notifyEdge(String container, List<TopoEdgeUpdate> etuList) {
        if (etuList == null) {
            return;
        }
        ArrayList<TopoEdgeUpdate> etuNotifyList = new ArrayList<TopoEdgeUpdate>();
        boolean notifyListeners = false;
        for (TopoEdgeUpdate etu : etuList) {
            UpdateType type;
            Edge edge = etu.getEdge();
            boolean rv = this.updateLocalEdgeMap(container, edge, type = etu.getUpdateType(), etu.getProperty());
            if (!rv) continue;
            if (!notifyListeners) {
                notifyListeners = true;
            }
            etuNotifyList.add(etu);
            logger.debug("notifyEdge(TopoEdgeUpdate): {} Edge {} in container {}", new Object[]{type.getName(), edge, container});
        }
        if (notifyListeners) {
            this.notifyQ.add(new NotifyEntry(container, etuNotifyList));
            logger.debug("notifyEdge(TopoEdgeUpdate): add notifyQ");
        }
    }

    public void notifyEdge(Edge edge, UpdateType type, Set<Property> props) {
        if (edge == null || type == null) {
            return;
        }
        this.notifyEdge(GlobalConstants.DEFAULT.toString(), edge, type, props);
        List<String> containers = this.getEdgeContainers(edge);
        if (containers != null) {
            for (String container : containers) {
                this.notifyEdge(container, edge, type, props);
            }
        }
    }

    private List<String> getEdgeContainers(Edge edge) {
        NodeConnector src = edge.getTailNodeConnector();
        NodeConnector dst = edge.getHeadNodeConnector();
        if (!src.getType().equals(NodeConnector.NodeConnectorIDType.PRODUCTION)) {
            List srcContainers = (List)this.containerMap.get(src);
            List dstContainers = (List)this.containerMap.get(dst);
            ArrayList cmnContainers = null;
            if (srcContainers != null && dstContainers != null) {
                cmnContainers = new ArrayList(srcContainers);
                cmnContainers.retainAll(dstContainers);
            }
            return cmnContainers;
        }
        return (List)this.containerMap.get(dst);
    }

    public void tagUpdated(String containerName, Node n, short oldTag, short newTag, UpdateType t) {
    }

    public void containerFlowUpdated(String containerName, ContainerFlow previousFlow, ContainerFlow currentFlow, UpdateType t) {
    }

    public void nodeConnectorUpdated(String containerName, NodeConnector p, UpdateType t) {
        if (this.containerMap == null) {
            logger.error("containerMap is NULL");
            return;
        }
        CopyOnWriteArrayList<String> containers = (CopyOnWriteArrayList<String>)this.containerMap.get(p);
        if (containers == null) {
            containers = new CopyOnWriteArrayList<String>();
        }
        switch (t) {
            case ADDED: {
                if (containers.contains(containerName)) break;
                containers.add(containerName);
                this.updateContainerMap(containers, p);
                this.addNodeConnector(containerName, p);
                break;
            }
            case REMOVED: {
                if (!containers.contains(containerName)) break;
                containers.remove(containerName);
                this.updateContainerMap(containers, p);
                this.removeNodeConnector(containerName, p);
                break;
            }
        }
    }

    public void containerModeUpdated(UpdateType t) {
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---Topology Service Shim---\n");
        help.append("\t pem [container]               - Print edgeMap entries");
        help.append(" for a given container\n");
        return help.toString();
    }

    public void _pem(CommandInterpreter ci) {
        String container = ci.nextArgument();
        if (container == null) {
            container = GlobalConstants.DEFAULT.toString();
        }
        ci.println((Object)("Container: " + container));
        ci.println((Object)"                             Edge                                          Bandwidth");
        Map edgePropsMap = (Map)this.edgeMap.get(container);
        if (edgePropsMap == null) {
            return;
        }
        int count = 0;
        for (Pair edgeProps : edgePropsMap.values()) {
            if (edgeProps == null) continue;
            long bw = 0L;
            Set props = (Set)edgeProps.getRight();
            if (props != null) {
                for (Property prop : props) {
                    if (!prop.getName().equals("bandwidth")) continue;
                    bw = ((Bandwidth)prop).getValue();
                }
            }
            ++count;
            ci.println((Object)(edgeProps.getLeft() + "          " + bw));
        }
        ci.println((Object)("Total number of Edges: " + count));
    }

    public void _bwfactor(CommandInterpreter ci) {
        String factorString = ci.nextArgument();
        if (factorString == null) {
            ci.println((Object)("Bw threshold: " + this.bwThresholdFactor));
            ci.println((Object)"Insert a non null bw threshold");
            return;
        }
        this.bwThresholdFactor = Float.parseFloat(factorString);
        ci.println((Object)("New Bw threshold: " + this.bwThresholdFactor));
    }

    @Override
    public void requestRefresh(String containerName) {
        this.bulkNotifyQ.add(containerName);
    }

    private Collection<Pair<Edge, Set<Property>>> getEdgeProps(String containerName) {
        Map edgePropMap = null;
        edgePropMap = (Map)this.edgeMap.get(containerName);
        if (edgePropMap == null) {
            return null;
        }
        return edgePropMap.values();
    }

    private void TopologyBulkUpdate(String containerName) {
        Collection<Pair<Edge, Set<Property>>> edgeProps = null;
        logger.debug("Try bulk update for container:{}", (Object)containerName);
        edgeProps = this.getEdgeProps(containerName);
        if (edgeProps == null) {
            logger.debug("No edges known for container:{}", (Object)containerName);
            return;
        }
        ITopologyServiceShimListener topologServiceShimListener = (ITopologyServiceShimListener)this.topologyServiceShimListeners.get(containerName);
        if (topologServiceShimListener == null) {
            logger.debug("No topology service shim listener for container:{}", (Object)containerName);
            return;
        }
        int i = 0;
        ArrayList<TopoEdgeUpdate> teuList = new ArrayList<TopoEdgeUpdate>();
        for (Pair<Edge, Set<Property>> edgeProp : edgeProps) {
            if (edgeProp == null) continue;
            ++i;
            teuList.add(new TopoEdgeUpdate((Edge)edgeProp.getLeft(), (Set)edgeProp.getRight(), UpdateType.ADDED));
            logger.trace("Add edge {}", edgeProp.getLeft());
        }
        if (i > 0) {
            topologServiceShimListener.edgeUpdate(teuList);
        }
        logger.debug("Sent {} updates", (Object)i);
    }

    @Override
    public void updateNode(Node node, UpdateType type, Set<Property> props) {
    }

    @Override
    public void updateNodeConnector(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
        ArrayList<String> containers = new ArrayList<String>();
        List conList = (List)this.containerMap.get(nodeConnector);
        containers.add(GlobalConstants.DEFAULT.toString());
        if (conList != null) {
            containers.addAll(conList);
        }
        switch (type) {
            case ADDED: {
                break;
            }
            case CHANGED: {
                if (props == null) break;
                boolean rmEdge = false;
                for (Property prop : props) {
                    if ((!(prop instanceof Config) || ((Config)prop).getValue() == 1) && (!(prop instanceof State) || ((State)prop).getValue() == 1)) continue;
                    rmEdge = true;
                    break;
                }
                if (!rmEdge) break;
                for (String cName : containers) {
                    this.removeNodeConnector(cName, nodeConnector);
                }
                break;
            }
            case REMOVED: {
                for (String cName : containers) {
                    this.removeNodeConnector(cName, nodeConnector);
                }
                break;
            }
        }
    }

    public void containerCreate(String containerName) {
    }

    public void containerDestroy(String containerName) {
        List ncContainers;
        HashSet<NodeConnector> removeNodeConnectorSet = new HashSet<NodeConnector>();
        for (Map.Entry entry : this.containerMap.entrySet()) {
            ncContainers = (List)entry.getValue();
            if (!ncContainers.contains(containerName)) continue;
            NodeConnector nodeConnector = (NodeConnector)entry.getKey();
            removeNodeConnectorSet.add(nodeConnector);
        }
        for (NodeConnector nodeConnector : removeNodeConnectorSet) {
            ncContainers = (List)this.containerMap.get(nodeConnector);
            ncContainers.remove(containerName);
            if (!ncContainers.isEmpty()) continue;
            this.containerMap.remove(nodeConnector);
        }
        this.edgeMap.remove(containerName);
    }

    class BwUtilizationNotify
    implements Runnable {
        private final BlockingQueue<UtilizationUpdate> notifyQ;

        BwUtilizationNotify(BlockingQueue<UtilizationUpdate> notifyQ) {
            this.notifyQ = notifyQ;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block4: while (true) {
                        UtilizationUpdate update = this.notifyQ.take();
                        NodeConnector connector = update.connector;
                        Set containerList = TopologyServiceShim.this.edgeMap.keySet();
                        Iterator i$ = containerList.iterator();
                        while (true) {
                            if (!i$.hasNext()) continue block4;
                            String container = (String)i$.next();
                            Map edgePropsMap = (Map)TopologyServiceShim.this.edgeMap.get(container);
                            Edge edge = (Edge)((Pair)edgePropsMap.get(connector)).getLeft();
                            if (!edge.getTailNodeConnector().equals((Object)connector)) continue;
                            ITopologyServiceShimListener topologServiceShimListener = (ITopologyServiceShimListener)TopologyServiceShim.this.topologyServiceShimListeners.get(container);
                            if (update.type == UpdateType.ADDED) {
                                topologServiceShimListener.edgeOverUtilized(edge);
                                continue;
                            }
                            topologServiceShimListener.edgeUtilBackToNormal(edge);
                        }
                        break;
                    }
                }
                catch (InterruptedException e1) {
                    logger.warn("Edge Bandwidth Utilization Notify Thread interrupted {}", (Object)e1.getMessage());
                    if (!TopologyServiceShim.this.shuttingDown.booleanValue()) continue;
                    return;
                }
                catch (Exception e2) {
                    logger.error("", (Throwable)e2);
                    continue;
                }
                break;
            }
        }
    }

    class UtilizationUpdate {
        NodeConnector connector;
        UpdateType type;

        UtilizationUpdate(NodeConnector connector, UpdateType type) {
            this.connector = connector;
            this.type = type;
        }
    }

    class TopologyNotify
    implements Runnable {
        private final BlockingQueue<NotifyEntry> notifyQ;
        private NotifyEntry entry;
        private Map<String, List<TopoEdgeUpdate>> teuMap = new HashMap<String, List<TopoEdgeUpdate>>();
        private List<TopoEdgeUpdate> teuList;
        private boolean notifyListeners;

        TopologyNotify(BlockingQueue<NotifyEntry> notifyQ) {
            this.notifyQ = notifyQ;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.teuMap.clear();
                        this.notifyListeners = false;
                        while (!this.notifyQ.isEmpty()) {
                            this.entry = this.notifyQ.take();
                            this.teuList = this.teuMap.get(this.entry.container);
                            if (this.teuList == null) {
                                this.teuList = new ArrayList<TopoEdgeUpdate>();
                            }
                            this.teuList.addAll(this.entry.teuList);
                            this.teuMap.put(this.entry.container, this.teuList);
                            this.notifyListeners = true;
                        }
                        if (this.notifyListeners) {
                            for (String container : this.teuMap.keySet()) {
                                ITopologyServiceShimListener l = (ITopologyServiceShimListener)TopologyServiceShim.this.topologyServiceShimListeners.get(container);
                                if (l == null) continue;
                                l.edgeUpdate(this.teuMap.get(container));
                            }
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException e1) {
                    logger.warn("TopologyNotify interrupted {}", (Object)e1.getMessage());
                    if (!TopologyServiceShim.this.shuttingDown.booleanValue()) continue;
                    return;
                }
                catch (Exception e2) {
                    logger.error("", (Throwable)e2);
                    continue;
                }
                break;
            }
        }
    }

    class NotifyEntry {
        String container;
        List<TopoEdgeUpdate> teuList;

        public NotifyEntry(String container, TopoEdgeUpdate teu) {
            this.container = container;
            this.teuList = new ArrayList<TopoEdgeUpdate>();
            if (teu != null) {
                this.teuList.add(teu);
            }
        }

        public NotifyEntry(String container, List<TopoEdgeUpdate> teuList) {
            this.container = container;
            this.teuList = new ArrayList<TopoEdgeUpdate>();
            if (teuList != null) {
                this.teuList.addAll(teuList);
            }
        }
    }
}

