/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.controller.protocol_plugin.openflow.internal.TableConverter;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.reader.NodeTableStatistics;
import org.opendaylight.controller.sal.utils.NodeCreator;
import org.openflow.protocol.statistics.OFStatistics;
import org.openflow.protocol.statistics.OFTableStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStatisticsConverter {
    private static final Logger log = LoggerFactory.getLogger(TableStatisticsConverter.class);
    private final long switchId;
    private List<OFStatistics> ofStatsList;
    private List<NodeTableStatistics> ntStatsList;

    public TableStatisticsConverter(long switchId, List<OFStatistics> statsList) {
        this.switchId = switchId;
        this.ofStatsList = statsList == null || statsList.isEmpty() ? Collections.emptyList() : new ArrayList<OFStatistics>(statsList);
        this.ntStatsList = null;
    }

    public List<NodeTableStatistics> getNodeTableStatsList() {
        if (this.ofStatsList != null && this.ntStatsList == null) {
            this.ntStatsList = new ArrayList<NodeTableStatistics>();
            Node node = NodeCreator.createOFNode((Long)this.switchId);
            for (OFStatistics ofStat : this.ofStatsList) {
                OFTableStatistics ofTableStat = (OFTableStatistics)ofStat;
                NodeTableStatistics ntStat = new NodeTableStatistics();
                ntStat.setNodeTable(TableConverter.toNodeTable(ofTableStat.getTableId(), node));
                ntStat.setActiveCount(ofTableStat.getActiveCount());
                ntStat.setLookupCount(ofTableStat.getLookupCount());
                ntStat.setMatchedCount(ofTableStat.getMatchedCount());
                ntStat.setMaximumEntries(ofTableStat.getMaximumEntries());
                this.ntStatsList.add(ntStat);
            }
        }
        log.trace("OFStatistics: {} NodeTableStatistics: {}", this.ofStatsList, this.ntStatsList);
        return this.ntStatsList;
    }
}

