/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.protocol_plugin.openflow.IOFStatisticsListener;
import org.opendaylight.controller.protocol_plugin.openflow.IOFStatisticsManager;
import org.opendaylight.controller.protocol_plugin.openflow.IReadFilterInternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.IReadServiceFilter;
import org.opendaylight.controller.protocol_plugin.openflow.core.IController;
import org.opendaylight.controller.protocol_plugin.openflow.internal.DescStatisticsConverter;
import org.opendaylight.controller.protocol_plugin.openflow.internal.FlowConverter;
import org.opendaylight.controller.protocol_plugin.openflow.internal.FlowStatisticsConverter;
import org.opendaylight.controller.protocol_plugin.openflow.internal.PortStatisticsConverter;
import org.opendaylight.controller.protocol_plugin.openflow.internal.TableStatisticsConverter;
import org.opendaylight.controller.sal.action.Action;
import org.opendaylight.controller.sal.action.ActionType;
import org.opendaylight.controller.sal.action.Output;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.IContainerAware;
import org.opendaylight.controller.sal.core.IContainerListener;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.NodeTable;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.reader.FlowOnNode;
import org.opendaylight.controller.sal.reader.NodeConnectorStatistics;
import org.opendaylight.controller.sal.reader.NodeDescription;
import org.opendaylight.controller.sal.reader.NodeTableStatistics;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.NodeConnectorCreator;
import org.opendaylight.controller.sal.utils.NodeCreator;
import org.opendaylight.controller.sal.utils.NodeTableCreator;
import org.openflow.protocol.OFMatch;
import org.openflow.protocol.statistics.OFFlowStatisticsReply;
import org.openflow.protocol.statistics.OFPortStatisticsReply;
import org.openflow.protocol.statistics.OFStatistics;
import org.openflow.protocol.statistics.OFStatisticsType;
import org.openflow.protocol.statistics.OFTableStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadServiceFilter
implements IReadServiceFilter,
IContainerListener,
IOFStatisticsListener,
IContainerAware {
    private static final Logger logger = LoggerFactory.getLogger(ReadServiceFilter.class);
    private IController controller = null;
    private IOFStatisticsManager statsMgr = null;
    private ConcurrentMap<String, Set<NodeConnector>> containerToNc;
    private ConcurrentMap<String, Set<Node>> containerToNode;
    private ConcurrentMap<String, Set<NodeTable>> containerToNt;
    private ConcurrentMap<String, Set<ContainerFlow>> containerFlows;
    private ConcurrentMap<String, IReadFilterInternalListener> readFilterInternalListeners = new ConcurrentHashMap<String, IReadFilterInternalListener>();

    public void setController(IController core) {
        this.controller = core;
    }

    public void unsetController(IController core) {
        if (this.controller == core) {
            this.controller = null;
        }
    }

    public void setReadFilterInternalListener(Map<?, ?> props, IReadFilterInternalListener s) {
        if (props == null) {
            logger.error("Failed setting Read Filter Listener, property map is null.");
            return;
        }
        String containerName = (String)props.get("containerName");
        if (containerName == null) {
            logger.error("Failed setting Read Filter Listener, container name not supplied.");
            return;
        }
        if (this.readFilterInternalListeners != null && !this.readFilterInternalListeners.containsValue(s)) {
            this.readFilterInternalListeners.put(containerName, s);
            logger.trace("Added Read Filter Listener for container {}", (Object)containerName);
        }
    }

    public void unsetReadFilterInternalListener(Map<?, ?> props, IReadFilterInternalListener s) {
        if (props == null) {
            logger.error("Failed unsetting Read Filter Listener, property map is null.");
            return;
        }
        String containerName = (String)props.get("containerName");
        if (containerName == null) {
            logger.error("Failed unsetting Read Filter Listener, containerName not supplied");
            return;
        }
        if (this.readFilterInternalListeners != null && this.readFilterInternalListeners.get(containerName) != null && ((IReadFilterInternalListener)this.readFilterInternalListeners.get(containerName)).equals(s)) {
            this.readFilterInternalListeners.remove(containerName);
            logger.trace("Removed Read Filter Listener for container {}", (Object)containerName);
        }
    }

    void init() {
        this.containerToNc = new ConcurrentHashMap<String, Set<NodeConnector>>();
        this.containerToNt = new ConcurrentHashMap<String, Set<NodeTable>>();
        this.containerToNode = new ConcurrentHashMap<String, Set<Node>>();
        this.containerFlows = new ConcurrentHashMap<String, Set<ContainerFlow>>();
    }

    void destroy() {
        this.readFilterInternalListeners.clear();
    }

    void start() {
    }

    void stop() {
    }

    public void setService(IOFStatisticsManager service) {
        this.statsMgr = service;
    }

    public void unsetService(IOFStatisticsManager service) {
        this.statsMgr = null;
    }

    @Override
    public FlowOnNode readFlow(String container, Node node, Flow flow, boolean cached) {
        List<OFStatistics> ofList;
        if (this.controller == null) {
            logger.error("Internal plugin error");
            return null;
        }
        long sid = (Long)node.getID();
        OFMatch ofMatch = new FlowConverter(flow).getOFMatch();
        if (cached) {
            ofList = this.statsMgr.getOFFlowStatistics(sid, ofMatch, flow.getPriority());
        } else {
            ofList = this.statsMgr.queryStatistics(sid, OFStatisticsType.FLOW, ofMatch);
            for (OFStatistics ofStat : ofList) {
                if (((OFFlowStatisticsReply)ofStat).getPriority() != flow.getPriority()) continue;
                ofList = new ArrayList<OFStatistics>(1);
                ofList.add(ofStat);
                break;
            }
        }
        List<FlowOnNode> flowOnNodeList = new FlowStatisticsConverter(ofList).getFlowOnNodeList(node);
        List<FlowOnNode> filteredList = this.filterFlowListPerContainer(container, node, flowOnNodeList);
        return filteredList.isEmpty() ? null : filteredList.get(0);
    }

    @Override
    public List<FlowOnNode> readAllFlow(String container, Node node, boolean cached) {
        long sid = (Long)node.getID();
        List<OFStatistics> ofList = cached ? this.statsMgr.getOFFlowStatistics(sid) : this.statsMgr.queryStatistics(sid, OFStatisticsType.FLOW, null);
        List<FlowOnNode> flowOnNodeList = new FlowStatisticsConverter(ofList).getFlowOnNodeList(node);
        return this.filterFlowListPerContainer(container, node, flowOnNodeList);
    }

    @Override
    public NodeDescription readDescription(Node node, boolean cached) {
        if (this.controller == null) {
            logger.error("Internal plugin error");
            return null;
        }
        long sid = (Long)node.getID();
        List<OFStatistics> ofList = cached ? this.statsMgr.getOFDescStatistics(sid) : this.statsMgr.queryStatistics(sid, OFStatisticsType.DESC, null);
        return new DescStatisticsConverter(ofList).getHwDescription();
    }

    private List<FlowOnNode> filterFlowListPerContainer(String container, Node nodeId, List<FlowOnNode> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<FlowOnNode> newList = new ArrayList<FlowOnNode>();
        for (FlowOnNode target : list) {
            if (!this.flowBelongToContainer(container, nodeId, target.getFlow())) continue;
            newList.add(target);
        }
        return newList;
    }

    private List<OFStatistics> filterPortListPerContainer(String container, long switchId, List<OFStatistics> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<OFStatistics> newList = new ArrayList<OFStatistics>();
        for (OFStatistics stat : list) {
            OFPortStatisticsReply target = (OFPortStatisticsReply)stat;
            NodeConnector nc = NodeConnectorCreator.createOFNodeConnector((Short)target.getPortNumber(), (Node)NodeCreator.createOFNode((Long)switchId));
            if (!this.containerOwnsNodeConnector(container, nc)) continue;
            newList.add((OFStatistics)target);
        }
        return newList;
    }

    private List<OFStatistics> filterTableListPerContainer(String container, long switchId, List<OFStatistics> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<OFStatistics> newList = new ArrayList<OFStatistics>();
        for (OFStatistics stat : list) {
            OFTableStatistics target = (OFTableStatistics)stat;
            NodeTable nt = NodeTableCreator.createOFNodeTable((byte)target.getTableId(), (Node)NodeCreator.createOFNode((Long)switchId));
            if (!this.containerOwnsNodeTable(container, nt)) continue;
            newList.add((OFStatistics)target);
        }
        return newList;
    }

    public boolean flowBelongToContainer(String container, Node node, Flow flow) {
        if (container.equals(GlobalConstants.DEFAULT.toString())) {
            return true;
        }
        return this.flowPortsBelongToContainer(container, node, flow) && this.flowVlanBelongsToContainer(container, node, flow) && this.isFlowAllowedByContainer(container, flow);
    }

    public boolean containerOwnsNodeConnector(String container, NodeConnector p) {
        if (container.equals(GlobalConstants.DEFAULT.toString())) {
            return true;
        }
        Set portSet = (Set)this.containerToNc.get(container);
        return portSet == null ? false : portSet.contains(p);
    }

    public boolean containerOwnsNodeTable(String container, NodeTable table) {
        if (container.equals(GlobalConstants.DEFAULT.toString())) {
            return true;
        }
        Set tableSet = (Set)this.containerToNt.get(container);
        return tableSet == null ? false : tableSet.contains(table);
    }

    private boolean isFlowAllowedByContainer(String container, Flow flow) {
        Set cFlowSet = (Set)this.containerFlows.get(container);
        if (cFlowSet == null || cFlowSet.isEmpty()) {
            return true;
        }
        for (ContainerFlow cFlow : cFlowSet) {
            if (!cFlow.allowsFlow(flow)) continue;
            return true;
        }
        return false;
    }

    private boolean flowVlanBelongsToContainer(String container, Node node, Flow flow) {
        return true;
    }

    private boolean flowPortsBelongToContainer(String container, Node node, Flow flow) {
        NodeConnector inPort;
        Match m = flow.getMatch();
        if (m.isPresent(MatchType.IN_PORT) && !this.containerOwnsNodeConnector(container, inPort = (NodeConnector)m.getField(MatchType.IN_PORT).getValue())) {
            return false;
        }
        for (Action action : flow.getActions()) {
            NodeConnector outPort;
            if (action.getType() != ActionType.OUTPUT || this.containerOwnsNodeConnector(container, outPort = ((Output)action).getPort())) continue;
            return false;
        }
        return true;
    }

    public void containerFlowUpdated(String containerName, ContainerFlow previousFlow, ContainerFlow currentFlow, UpdateType t) {
        HashSet<ContainerFlow> cFlowSet = (HashSet<ContainerFlow>)this.containerFlows.get(containerName);
        switch (t) {
            case ADDED: {
                if (cFlowSet == null) {
                    cFlowSet = new HashSet<ContainerFlow>();
                    this.containerFlows.put(containerName, cFlowSet);
                }
                cFlowSet.add(currentFlow);
            }
            case CHANGED: {
                break;
            }
            case REMOVED: {
                if (cFlowSet == null) break;
                cFlowSet.remove(currentFlow);
                break;
            }
        }
    }

    public void nodeConnectorUpdated(String containerName, NodeConnector p, UpdateType type) {
        switch (type) {
            case ADDED: {
                if (!this.containerToNc.containsKey(containerName)) {
                    this.containerToNc.put(containerName, Collections.newSetFromMap(new ConcurrentHashMap()));
                }
                ((Set)this.containerToNc.get(containerName)).add(p);
                if (!this.containerToNode.containsKey(containerName)) {
                    this.containerToNode.put(containerName, new HashSet());
                }
                ((Set)this.containerToNode.get(containerName)).add(p.getNode());
                break;
            }
            case REMOVED: {
                Set nodeSet;
                Set ncSet = (Set)this.containerToNc.get(containerName);
                if (ncSet == null) break;
                ncSet.remove(p);
                boolean nodeInContainer = false;
                Node node = p.getNode();
                for (NodeConnector nodeConnector : ncSet) {
                    if (!nodeConnector.getNode().equals((Object)node)) continue;
                    nodeInContainer = true;
                    break;
                }
                if (nodeInContainer || (nodeSet = (Set)this.containerToNode.get(containerName)) == null) break;
                nodeSet.remove(node);
                break;
            }
        }
    }

    public void tagUpdated(String containerName, Node n, short oldTag, short newTag, UpdateType t) {
    }

    public void containerModeUpdated(UpdateType t) {
    }

    @Override
    public NodeConnectorStatistics readNodeConnector(String containerName, NodeConnector connector, boolean cached) {
        if (!this.containerOwnsNodeConnector(containerName, connector)) {
            return null;
        }
        Node node = connector.getNode();
        long sid = (Long)node.getID();
        short portId = (Short)connector.getID();
        List<OFStatistics> ofList = cached ? this.statsMgr.getOFPortStatistics(sid, portId) : this.statsMgr.queryStatistics(sid, OFStatisticsType.PORT, portId);
        List<NodeConnectorStatistics> ncStatistics = new PortStatisticsConverter(sid, ofList).getNodeConnectorStatsList();
        return ncStatistics.isEmpty() ? new NodeConnectorStatistics() : ncStatistics.get(0);
    }

    @Override
    public List<NodeConnectorStatistics> readAllNodeConnector(String containerName, Node node, boolean cached) {
        long sid = (Long)node.getID();
        List<OFStatistics> ofList = cached ? this.statsMgr.getOFPortStatistics(sid) : this.statsMgr.queryStatistics(sid, OFStatisticsType.FLOW, null);
        List<OFStatistics> filteredList = this.filterPortListPerContainer(containerName, sid, ofList);
        return new PortStatisticsConverter(sid, filteredList).getNodeConnectorStatsList();
    }

    @Override
    public long getTransmitRate(String containerName, NodeConnector connector) {
        if (!this.containerOwnsNodeConnector(containerName, connector)) {
            return 0L;
        }
        long switchId = (Long)connector.getNode().getID();
        short port = (Short)connector.getID();
        return this.statsMgr.getTransmitRate(switchId, port);
    }

    @Override
    public NodeTableStatistics readNodeTable(String containerName, NodeTable table, boolean cached) {
        if (!this.containerOwnsNodeTable(containerName, table)) {
            return null;
        }
        Node node = table.getNode();
        long sid = (Long)node.getID();
        Byte tableId = (Byte)table.getID();
        List<OFStatistics> ofList = cached ? this.statsMgr.getOFTableStatistics(sid, tableId) : this.statsMgr.queryStatistics(sid, OFStatisticsType.TABLE, tableId);
        List<NodeTableStatistics> ntStatistics = new TableStatisticsConverter(sid, ofList).getNodeTableStatsList();
        return ntStatistics.isEmpty() ? new NodeTableStatistics() : ntStatistics.get(0);
    }

    @Override
    public List<NodeTableStatistics> readAllNodeTable(String containerName, Node node, boolean cached) {
        long sid = (Long)node.getID();
        List<OFStatistics> ofList = cached ? this.statsMgr.getOFTableStatistics(sid) : this.statsMgr.queryStatistics(sid, OFStatisticsType.FLOW, null);
        List<OFStatistics> filteredList = this.filterTableListPerContainer(containerName, sid, ofList);
        return new TableStatisticsConverter(sid, filteredList).getNodeTableStatsList();
    }

    @Override
    public void descriptionStatisticsRefreshed(Long switchId, List<OFStatistics> description) {
        Node node = NodeCreator.createOFNode((Long)switchId);
        NodeDescription nodeDescription = new DescStatisticsConverter(description).getHwDescription();
        for (Map.Entry l : this.readFilterInternalListeners.entrySet()) {
            String container = (String)l.getKey();
            IReadFilterInternalListener listener = (IReadFilterInternalListener)l.getValue();
            if (container != GlobalConstants.DEFAULT.toString() && (!this.containerToNode.containsKey(container) || !((Set)this.containerToNode.get(container)).contains(node))) continue;
            listener.nodeDescriptionStatisticsUpdated(node, nodeDescription);
        }
    }

    @Override
    public void flowStatisticsRefreshed(Long switchId, List<OFStatistics> flows) {
        Node node = NodeCreator.createOFNode((Long)switchId);
        for (Map.Entry l : this.readFilterInternalListeners.entrySet()) {
            String container = (String)l.getKey();
            IReadFilterInternalListener listener = (IReadFilterInternalListener)l.getValue();
            List<FlowOnNode> flowOnNodeList = new FlowStatisticsConverter(flows).getFlowOnNodeList(node);
            flowOnNodeList = this.filterFlowListPerContainer(container, node, flowOnNodeList);
            listener.nodeFlowStatisticsUpdated(node, flowOnNodeList);
        }
    }

    @Override
    public void portStatisticsRefreshed(Long switchId, List<OFStatistics> ports) {
        Node node = NodeCreator.createOFNode((Long)switchId);
        for (Map.Entry l : this.readFilterInternalListeners.entrySet()) {
            String container = (String)l.getKey();
            IReadFilterInternalListener listener = (IReadFilterInternalListener)l.getValue();
            List<OFStatistics> filteredPorts = this.filterPortListPerContainer(container, switchId, ports);
            List<NodeConnectorStatistics> ncStatsList = new PortStatisticsConverter(switchId, filteredPorts).getNodeConnectorStatsList();
            listener.nodeConnectorStatisticsUpdated(node, ncStatsList);
        }
    }

    @Override
    public void tableStatisticsRefreshed(Long switchId, List<OFStatistics> tables) {
        Node node = NodeCreator.createOFNode((Long)switchId);
        for (Map.Entry l : this.readFilterInternalListeners.entrySet()) {
            String container = (String)l.getKey();
            List<OFStatistics> filteredList = this.filterTableListPerContainer(container, switchId, tables);
            List<NodeTableStatistics> tableStatsList = new TableStatisticsConverter(switchId, filteredList).getNodeTableStatsList();
            ((IReadFilterInternalListener)l.getValue()).nodeTableStatisticsUpdated(node, tableStatsList);
        }
    }

    public void containerCreate(String containerName) {
    }

    public void containerDestroy(String containerName) {
        this.containerToNc.remove(containerName);
        this.containerToNode.remove(containerName);
        this.containerToNt.remove(containerName);
        this.containerFlows.remove(containerName);
    }
}

