/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.protocol_plugin.openflow.IReadFilterInternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.IReadServiceFilter;
import org.opendaylight.controller.sal.connection.IPluginOutConnectionService;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.NodeTable;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.reader.FlowOnNode;
import org.opendaylight.controller.sal.reader.IPluginInReadService;
import org.opendaylight.controller.sal.reader.IPluginOutReadService;
import org.opendaylight.controller.sal.reader.NodeConnectorStatistics;
import org.opendaylight.controller.sal.reader.NodeDescription;
import org.opendaylight.controller.sal.reader.NodeTableStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadService
implements IPluginInReadService,
IReadFilterInternalListener {
    private static final Logger logger = LoggerFactory.getLogger(ReadService.class);
    private IReadServiceFilter filter;
    private Set<IPluginOutReadService> pluginOutReadServices = new CopyOnWriteArraySet<IPluginOutReadService>();
    private String containerName;
    private IPluginOutConnectionService connectionOutService;

    void init(Component c) {
        Dictionary props = c.getServiceProperties();
        this.containerName = props != null ? (String)props.get("containerName") : null;
    }

    void destroy() {
        this.pluginOutReadServices.clear();
    }

    void start() {
    }

    void stop() {
    }

    public void setService(IReadServiceFilter filter) {
        this.filter = filter;
    }

    public void unsetService(IReadServiceFilter filter) {
        this.filter = null;
    }

    public void setPluginOutReadServices(IPluginOutReadService service) {
        logger.trace("Got a service set request {}", (Object)service);
        if (this.pluginOutReadServices != null) {
            this.pluginOutReadServices.add(service);
        }
    }

    public void unsetPluginOutReadServices(IPluginOutReadService service) {
        logger.trace("Got a service UNset request");
        if (this.pluginOutReadServices != null) {
            this.pluginOutReadServices.remove(service);
        }
    }

    public FlowOnNode readFlow(Node node, Flow flow, boolean cached) {
        if (!node.getType().equals(Node.NodeIDType.OPENFLOW)) {
            logger.error("Invalid node type");
            return null;
        }
        if (!this.connectionOutService.isLocal(node)) {
            logger.debug("This Controller is not the master for the node : " + node);
            return null;
        }
        return this.filter.readFlow(this.containerName, node, flow, cached);
    }

    public List<FlowOnNode> readAllFlow(Node node, boolean cached) {
        if (!node.getType().equals(Node.NodeIDType.OPENFLOW)) {
            logger.error("Invalid node type");
            return Collections.emptyList();
        }
        if (!this.connectionOutService.isLocal(node)) {
            logger.debug("This Controller is not the master for the node : " + node);
            return Collections.emptyList();
        }
        return this.filter.readAllFlow(this.containerName, node, cached);
    }

    public NodeDescription readDescription(Node node, boolean cached) {
        if (!node.getType().equals(Node.NodeIDType.OPENFLOW)) {
            logger.error("Invalid node type");
            return null;
        }
        if (!this.connectionOutService.isLocal(node)) {
            logger.debug("This Controller is not the master for the node : " + node);
            return null;
        }
        return this.filter.readDescription(node, cached);
    }

    public NodeConnectorStatistics readNodeConnector(NodeConnector connector, boolean cached) {
        if (!connector.getNode().getType().equals(Node.NodeIDType.OPENFLOW)) {
            logger.error("Invalid node type");
            return null;
        }
        if (!this.connectionOutService.isLocal(connector.getNode())) {
            logger.debug("This Controller is not the master for connector : " + connector);
            return null;
        }
        return this.filter.readNodeConnector(this.containerName, connector, cached);
    }

    public List<NodeConnectorStatistics> readAllNodeConnector(Node node, boolean cached) {
        if (!node.getType().equals(Node.NodeIDType.OPENFLOW)) {
            logger.error("Invalid node type");
            return Collections.emptyList();
        }
        if (!this.connectionOutService.isLocal(node)) {
            logger.debug("This Controller is not the master for node : " + node);
            return Collections.emptyList();
        }
        return this.filter.readAllNodeConnector(this.containerName, node, cached);
    }

    public long getTransmitRate(NodeConnector connector) {
        if (!connector.getNode().getType().equals(Node.NodeIDType.OPENFLOW)) {
            logger.error("Invalid node type");
            return 0L;
        }
        if (!this.connectionOutService.isLocal(connector.getNode())) {
            logger.debug("This Controller is not the master for connector : " + connector);
            return 0L;
        }
        return this.filter.getTransmitRate(this.containerName, connector);
    }

    public NodeTableStatistics readNodeTable(NodeTable table, boolean cached) {
        if (!table.getNode().getType().equals(Node.NodeIDType.OPENFLOW)) {
            logger.error("Invalid node type");
            return null;
        }
        if (!this.connectionOutService.isLocal(table.getNode())) {
            logger.debug("This Controller is not the master for connector : " + table);
            return null;
        }
        return this.filter.readNodeTable(this.containerName, table, cached);
    }

    public List<NodeTableStatistics> readAllNodeTable(Node node, boolean cached) {
        if (!node.getType().equals(Node.NodeIDType.OPENFLOW)) {
            logger.error("Invalid node type");
            return Collections.emptyList();
        }
        if (!this.connectionOutService.isLocal(node)) {
            logger.debug("This Controller is not the master for node : " + node);
            return Collections.emptyList();
        }
        return this.filter.readAllNodeTable(this.containerName, node, cached);
    }

    @Override
    public void nodeFlowStatisticsUpdated(Node node, List<FlowOnNode> flowStatsList) {
        if (!this.connectionOutService.isLocal(node)) {
            logger.debug("This Controller is not the master for node : " + node);
            return;
        }
        for (IPluginOutReadService service : this.pluginOutReadServices) {
            service.nodeFlowStatisticsUpdated(node, flowStatsList);
        }
    }

    @Override
    public void nodeConnectorStatisticsUpdated(Node node, List<NodeConnectorStatistics> ncStatsList) {
        if (!this.connectionOutService.isLocal(node)) {
            logger.debug("This Controller is not the master for node : " + node);
            return;
        }
        for (IPluginOutReadService service : this.pluginOutReadServices) {
            service.nodeConnectorStatisticsUpdated(node, ncStatsList);
        }
    }

    @Override
    public void nodeTableStatisticsUpdated(Node node, List<NodeTableStatistics> tableStatsList) {
        if (!this.connectionOutService.isLocal(node)) {
            logger.debug("This Controller is not the master for node : " + node);
            return;
        }
        for (IPluginOutReadService service : this.pluginOutReadServices) {
            service.nodeTableStatisticsUpdated(node, tableStatsList);
        }
    }

    @Override
    public void nodeDescriptionStatisticsUpdated(Node node, NodeDescription nodeDescription) {
        if (!this.connectionOutService.isLocal(node)) {
            logger.debug("This Controller is not the master for node : " + node);
            return;
        }
        for (IPluginOutReadService service : this.pluginOutReadServices) {
            service.descriptionStatisticsUpdated(node, nodeDescription);
        }
    }

    void setIPluginOutConnectionService(IPluginOutConnectionService s) {
        this.connectionOutService = s;
    }

    void unsetIPluginOutConnectionService(IPluginOutConnectionService s) {
        if (this.connectionOutService == s) {
            this.connectionOutService = null;
        }
    }
}

