/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.controller.protocol_plugin.openflow.internal.PortConverter;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.reader.NodeConnectorStatistics;
import org.opendaylight.controller.sal.utils.NodeCreator;
import org.openflow.protocol.statistics.OFPortStatisticsReply;
import org.openflow.protocol.statistics.OFStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortStatisticsConverter {
    private static final Logger log = LoggerFactory.getLogger(PortStatisticsConverter.class);
    private long switchId;
    private List<OFStatistics> ofStatsList;
    private List<NodeConnectorStatistics> ncStatsList;

    public PortStatisticsConverter(long switchId, List<OFStatistics> statsList) {
        this.switchId = switchId;
        this.ofStatsList = statsList == null || statsList.isEmpty() ? Collections.emptyList() : new ArrayList<OFStatistics>(statsList);
        this.ncStatsList = null;
    }

    public List<NodeConnectorStatistics> getNodeConnectorStatsList() {
        if (this.ofStatsList != null && this.ncStatsList == null) {
            this.ncStatsList = new ArrayList<NodeConnectorStatistics>();
            Node node = NodeCreator.createOFNode((Long)this.switchId);
            for (OFStatistics ofStat : this.ofStatsList) {
                OFPortStatisticsReply ofPortStat = (OFPortStatisticsReply)ofStat;
                NodeConnectorStatistics NCStat = new NodeConnectorStatistics();
                NCStat.setNodeConnector(PortConverter.toNodeConnector(ofPortStat.getPortNumber(), node));
                NCStat.setReceivePacketCount(ofPortStat.getreceivePackets());
                NCStat.setTransmitPacketCount(ofPortStat.getTransmitPackets());
                NCStat.setReceiveByteCount(ofPortStat.getReceiveBytes());
                NCStat.setTransmitByteCount(ofPortStat.getTransmitBytes());
                NCStat.setReceiveDropCount(ofPortStat.getReceiveDropped());
                NCStat.setTransmitDropCount(ofPortStat.getTransmitDropped());
                NCStat.setReceiveErrorCount(ofPortStat.getreceiveErrors());
                NCStat.setTransmitErrorCount(ofPortStat.getTransmitErrors());
                NCStat.setReceiveFrameErrorCount(ofPortStat.getReceiveFrameErrors());
                NCStat.setReceiveOverRunErrorCount(ofPortStat.getReceiveOverrunErrors());
                NCStat.setReceiveCRCErrorCount(ofPortStat.getReceiveCRCErrors());
                NCStat.setCollisionCount(ofPortStat.getCollisions());
                this.ncStatsList.add(NCStat);
            }
        }
        log.trace("OFStatistics: {} NodeConnectorStatistics: {}", this.ofStatsList, this.ncStatsList);
        return this.ncStatsList;
    }
}

