/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.NetUtils;
import org.opendaylight.controller.sal.utils.NodeConnectorCreator;
import org.openflow.protocol.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PortConverter {
    private static final Logger log = LoggerFactory.getLogger(PortConverter.class);
    private static final int maxOFPhysicalPort = NetUtils.getUnsignedShort((short)OFPort.OFPP_MAX.getValue());

    public static NodeConnector toNodeConnector(short ofPort, Node node) {
        int unsignedOFPort = NetUtils.getUnsignedShort((short)ofPort);
        log.trace("Openflow port number signed: {} unsigned: {}", (Object)ofPort, (Object)unsignedOFPort);
        if (unsignedOFPort > maxOFPhysicalPort) {
            if (ofPort == OFPort.OFPP_LOCAL.getValue()) {
                return NodeConnectorCreator.createNodeConnector((String)NodeConnector.NodeConnectorIDType.SWSTACK, (Object)NodeConnector.SPECIALNODECONNECTORID, (Node)node);
            }
            if (ofPort == OFPort.OFPP_NORMAL.getValue()) {
                return NodeConnectorCreator.createNodeConnector((String)NodeConnector.NodeConnectorIDType.HWPATH, (Object)NodeConnector.SPECIALNODECONNECTORID, (Node)node);
            }
            if (ofPort == OFPort.OFPP_CONTROLLER.getValue()) {
                return NodeConnectorCreator.createNodeConnector((String)NodeConnector.NodeConnectorIDType.CONTROLLER, (Object)NodeConnector.SPECIALNODECONNECTORID, (Node)node);
            }
        }
        return NodeConnectorCreator.createNodeConnector((Object)ofPort, (Node)node);
    }

    public static short toOFPort(NodeConnector salPort) {
        log.trace("SAL Port", (Object)salPort);
        if (salPort.getType().equals(NodeConnector.NodeConnectorIDType.SWSTACK)) {
            return OFPort.OFPP_LOCAL.getValue();
        }
        if (salPort.getType().equals(NodeConnector.NodeConnectorIDType.HWPATH)) {
            return OFPort.OFPP_NORMAL.getValue();
        }
        if (salPort.getType().equals(NodeConnector.NodeConnectorIDType.CONTROLLER)) {
            return OFPort.OFPP_CONTROLLER.getValue();
        }
        return (Short)salPort.getID();
    }
}

