/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryShimExternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.IOFStatisticsListener;
import org.opendaylight.controller.protocol_plugin.openflow.IOFStatisticsManager;
import org.opendaylight.controller.protocol_plugin.openflow.core.IController;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitch;
import org.opendaylight.controller.protocol_plugin.openflow.internal.Utils;
import org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension.V6Match;
import org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension.V6StatsReply;
import org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension.V6StatsRequest;
import org.opendaylight.controller.sal.connection.IPluginOutConnectionService;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.openflow.protocol.OFError;
import org.openflow.protocol.OFMatch;
import org.openflow.protocol.OFPort;
import org.openflow.protocol.OFStatisticsRequest;
import org.openflow.protocol.statistics.OFAggregateStatisticsRequest;
import org.openflow.protocol.statistics.OFFlowStatisticsReply;
import org.openflow.protocol.statistics.OFFlowStatisticsRequest;
import org.openflow.protocol.statistics.OFPortStatisticsReply;
import org.openflow.protocol.statistics.OFPortStatisticsRequest;
import org.openflow.protocol.statistics.OFQueueStatisticsRequest;
import org.openflow.protocol.statistics.OFStatistics;
import org.openflow.protocol.statistics.OFStatisticsType;
import org.openflow.protocol.statistics.OFTableStatistics;
import org.openflow.protocol.statistics.OFVendorStatistics;
import org.openflow.util.HexString;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFStatisticsManager
implements IOFStatisticsManager,
IInventoryShimExternalListener,
CommandProvider {
    private static final Logger log = LoggerFactory.getLogger(OFStatisticsManager.class);
    private static final int INITIAL_SIZE = 64;
    private static final long FLOW_STATS_PERIOD = 10000L;
    private static final long DESC_STATS_PERIOD = 60000L;
    private static final long PORT_STATS_PERIOD = 5000L;
    private static final long TABLE_STATS_PERIOD = 10000L;
    private static final long TICK = 1000L;
    private static short statisticsTickNumber = (short)10;
    private static short descriptionTickNumber = (short)60;
    private static short portTickNumber = (short)5;
    private static short tableTickNumber = (short)10;
    private static short factoredSamples = (short)2;
    private static short counter = 1;
    private IController controller = null;
    private ConcurrentMap<Long, List<OFStatistics>> flowStatistics;
    private ConcurrentMap<Long, List<OFStatistics>> descStatistics;
    private ConcurrentMap<Long, List<OFStatistics>> portStatistics;
    private ConcurrentMap<Long, List<OFStatistics>> tableStatistics;
    private ConcurrentMap<Long, StatisticsTicks> statisticsTimerTicks;
    protected BlockingQueue<StatsRequest> pendingStatsRequests;
    protected BlockingQueue<Long> switchPortStatsUpdated;
    private Thread statisticsCollector;
    private Thread txRatesUpdater;
    private Timer statisticsTimer;
    private TimerTask statisticsTimerTask;
    private ConcurrentMap<Long, Boolean> switchSupportsVendorExtStats;
    private Map<Long, Map<Short, TxRates>> txRates;
    private Set<IOFStatisticsListener> statisticsListeners = new CopyOnWriteArraySet<IOFStatisticsListener>();
    IPluginOutConnectionService connectionPluginOutService;

    public void setController(IController core) {
        this.controller = core;
    }

    public void unsetController(IController core) {
        if (this.controller == core) {
            this.controller = null;
        }
    }

    private short getStatsQueueSize() {
        String statsQueueSizeStr = System.getProperty("of.statsQueueSize");
        int statsQueueSize = 64;
        if (statsQueueSizeStr != null) {
            try {
                statsQueueSize = Short.parseShort(statsQueueSizeStr);
                if (statsQueueSize <= 0) {
                    statsQueueSize = 64;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (short)statsQueueSize;
    }

    void setIPluginOutConnectionService(IPluginOutConnectionService s) {
        this.connectionPluginOutService = s;
    }

    void unsetIPluginOutConnectionService(IPluginOutConnectionService s) {
        if (this.connectionPluginOutService == s) {
            this.connectionPluginOutService = null;
        }
    }

    void init() {
        this.flowStatistics = new ConcurrentHashMap<Long, List<OFStatistics>>();
        this.descStatistics = new ConcurrentHashMap<Long, List<OFStatistics>>();
        this.portStatistics = new ConcurrentHashMap<Long, List<OFStatistics>>();
        this.tableStatistics = new ConcurrentHashMap<Long, List<OFStatistics>>();
        this.pendingStatsRequests = new LinkedBlockingQueue<StatsRequest>(this.getStatsQueueSize());
        this.statisticsTimerTicks = new ConcurrentHashMap<Long, StatisticsTicks>(64);
        this.switchPortStatsUpdated = new LinkedBlockingQueue<Long>(64);
        this.switchSupportsVendorExtStats = new ConcurrentHashMap<Long, Boolean>(64);
        this.txRates = new HashMap<Long, Map<Short, TxRates>>(64);
        this.configStatsPollIntervals();
        this.statisticsTimer = new Timer("Statistics Timer Ticks");
        this.statisticsTimerTask = new TimerTask(){

            @Override
            public void run() {
                OFStatisticsManager.this.decrementTicks();
            }
        };
        this.statisticsCollector = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        StatsRequest req = OFStatisticsManager.this.pendingStatsRequests.take();
                        OFStatisticsManager.this.queryStatisticsInternal(req.switchId, req.type);
                    }
                }
                catch (InterruptedException e) {
                    log.warn("Flow Statistics Collector thread interrupted", (Throwable)e);
                    return;
                }
            }
        }, "Statistics Collector");
        this.txRatesUpdater = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        long switchId = OFStatisticsManager.this.switchPortStatsUpdated.take();
                        OFStatisticsManager.this.updatePortsTxRate(switchId);
                    }
                }
                catch (InterruptedException e) {
                    log.warn("TX Rate Updater thread interrupted", (Throwable)e);
                    return;
                }
            }
        }, "TX Rate Updater");
    }

    void destroy() {
        this.statisticsListeners.clear();
    }

    void start() {
        this.statisticsTimer.scheduleAtFixedRate(this.statisticsTimerTask, 0L, 1000L);
        this.statisticsCollector.start();
        this.txRatesUpdater.start();
        this.registerWithOSGIConsole();
    }

    void stop() {
        this.statisticsTimer.cancel();
    }

    public void setStatisticsListener(IOFStatisticsListener s) {
        this.statisticsListeners.add(s);
    }

    public void unsetStatisticsListener(IOFStatisticsListener s) {
        if (s != null) {
            this.statisticsListeners.remove(s);
        }
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    private void addStatisticsTicks(Long switchId) {
        this.switchSupportsVendorExtStats.put(switchId, Boolean.TRUE);
        this.statisticsTimerTicks.put(switchId, new StatisticsTicks(true));
        log.debug("Added Switch {} to target pool", (Object)HexString.toHexString((long)switchId));
    }

    private void printInfoMessage(String type, StatsRequest request) {
        log.trace("{} stats request not inserted for switch: {}. Queue size: {}. Collector state: {}.", new Object[]{type, HexString.toHexString((long)request.switchId), this.pendingStatsRequests.size(), this.statisticsCollector.getState().toString()});
    }

    protected void decrementTicks() {
        StatsRequest request = null;
        for (Map.Entry entry : this.statisticsTimerTicks.entrySet()) {
            StatisticsTicks clock = (StatisticsTicks)entry.getValue();
            Long switchId = (Long)entry.getKey();
            if (clock.decrementFlowTicksIsZero()) {
                StatsRequest statsRequest = request = this.switchSupportsVendorExtStats.get(switchId) == Boolean.TRUE ? new StatsRequest(switchId, OFStatisticsType.VENDOR) : new StatsRequest(switchId, OFStatisticsType.FLOW);
                if (!this.pendingStatsRequests.contains(request) && !this.pendingStatsRequests.offer(request)) {
                    this.printInfoMessage("Flow", request);
                }
            }
            if (clock.decrementDescTicksIsZero() && !this.pendingStatsRequests.contains(request = new StatsRequest(switchId, OFStatisticsType.DESC)) && !this.pendingStatsRequests.offer(request)) {
                this.printInfoMessage("Description", request);
            }
            if (clock.decrementPortTicksIsZero() && !this.pendingStatsRequests.contains(request = new StatsRequest(switchId, OFStatisticsType.PORT)) && !this.pendingStatsRequests.offer(request)) {
                this.printInfoMessage("Port", request);
            }
            if (!clock.decrementTableTicksIsZero() || this.pendingStatsRequests.contains(request = new StatsRequest(switchId, OFStatisticsType.TABLE)) || this.pendingStatsRequests.offer(request)) continue;
            this.printInfoMessage("Table", request);
        }
    }

    private void removeStatsRequestTasks(Long switchId) {
        log.debug("Cleaning Statistics database for switch {}", (Object)HexEncode.longToHexString((long)switchId));
        this.pendingStatsRequests.remove(new StatsRequest(switchId, OFStatisticsType.VENDOR));
        this.pendingStatsRequests.remove(new StatsRequest(switchId, OFStatisticsType.FLOW));
        this.pendingStatsRequests.remove(new StatsRequest(switchId, OFStatisticsType.DESC));
        this.pendingStatsRequests.remove(new StatsRequest(switchId, OFStatisticsType.PORT));
        this.pendingStatsRequests.remove(new StatsRequest(switchId, OFStatisticsType.TABLE));
        this.switchPortStatsUpdated.remove(switchId);
        this.txRates.remove(switchId);
    }

    private void clearFlowStatsAndTicks(Long switchId) {
        this.statisticsTimerTicks.remove(switchId);
        this.removeStatsRequestTasks(switchId);
        this.flowStatistics.remove(switchId);
        log.debug("Statistics removed for switch {}", (Object)HexString.toHexString((long)switchId));
    }

    private void queryStatisticsInternal(Long switchId, OFStatisticsType statType) {
        List<OFStatistics> values = this.fetchStatisticsFromSwitch(switchId, statType, null);
        if (!values.isEmpty()) {
            switch (statType) {
                case FLOW: 
                case VENDOR: {
                    this.flowStatistics.put(switchId, values);
                    this.notifyFlowUpdate(switchId, values);
                    break;
                }
                case DESC: {
                    this.descStatistics.put(switchId, values);
                    this.notifyDescriptionUpdate(switchId, values);
                    break;
                }
                case PORT: {
                    this.portStatistics.put(switchId, values);
                    this.switchPortStatsUpdated.offer(switchId);
                    this.notifyPortUpdate(switchId, values);
                    break;
                }
                case TABLE: {
                    this.tableStatistics.put(switchId, values);
                    this.notifyTableUpdate(switchId, values);
                    break;
                }
            }
        }
    }

    private void notifyDescriptionUpdate(Long switchId, List<OFStatistics> values) {
        for (IOFStatisticsListener l : this.statisticsListeners) {
            l.descriptionStatisticsRefreshed(switchId, values);
        }
    }

    private void notifyFlowUpdate(Long switchId, List<OFStatistics> values) {
        if (values.get(0) instanceof OFVendorStatistics) {
            values = this.v6StatsListToOFStatsList(values);
        }
        for (IOFStatisticsListener l : this.statisticsListeners) {
            l.flowStatisticsRefreshed(switchId, values);
        }
    }

    private void notifyPortUpdate(Long switchId, List<OFStatistics> values) {
        for (IOFStatisticsListener l : this.statisticsListeners) {
            l.portStatisticsRefreshed(switchId, values);
        }
    }

    private void notifyTableUpdate(Long switchId, List<OFStatistics> values) {
        for (IOFStatisticsListener l : this.statisticsListeners) {
            l.tableStatisticsRefreshed(switchId, values);
        }
    }

    private List<OFStatistics> fetchStatisticsFromSwitch(Long switchId, OFStatisticsType statsType, Object target) {
        List values = Collections.emptyList();
        String type = null;
        ISwitch sw = this.controller.getSwitch(switchId);
        if (sw != null) {
            OFStatisticsRequest req = new OFStatisticsRequest();
            req.setStatisticType(statsType);
            int requestLength = req.getLengthU();
            if (statsType == OFStatisticsType.FLOW) {
                OFMatch match = null;
                if (target == null) {
                    match = new OFMatch();
                    match.setWildcards(-1);
                } else {
                    if (!(target instanceof OFMatch)) {
                        log.warn("Invalid target type for Flow stats request: {}", target.getClass());
                        return Collections.emptyList();
                    }
                    match = (OFMatch)target;
                }
                OFFlowStatisticsRequest specificReq = new OFFlowStatisticsRequest();
                specificReq.setMatch(match);
                specificReq.setOutPort(OFPort.OFPP_NONE.getValue());
                specificReq.setTableId((byte)-1);
                req.setStatistics(Collections.singletonList(specificReq));
                requestLength += specificReq.getLength();
                type = "FLOW";
            } else if (statsType == OFStatisticsType.VENDOR) {
                V6StatsRequest specificReq = new V6StatsRequest();
                specificReq.setOutPort(OFPort.OFPP_NONE.getValue());
                specificReq.setTableId((byte)-1);
                req.setStatistics(Collections.singletonList(specificReq));
                requestLength += specificReq.getLength();
                type = "VENDOR";
            } else if (statsType == OFStatisticsType.AGGREGATE) {
                OFAggregateStatisticsRequest specificReq = new OFAggregateStatisticsRequest();
                OFMatch match = new OFMatch();
                match.setWildcards(-1);
                specificReq.setMatch(match);
                specificReq.setOutPort(OFPort.OFPP_NONE.getValue());
                specificReq.setTableId((byte)-1);
                req.setStatistics(Collections.singletonList(specificReq));
                requestLength += specificReq.getLength();
                type = "AGGREGATE";
            } else if (statsType == OFStatisticsType.PORT) {
                short targetPort;
                if (target == null) {
                    targetPort = OFPort.OFPP_NONE.getValue();
                } else {
                    if (!(target instanceof Short)) {
                        log.warn("Invalid target type for Port stats request: {}", target.getClass());
                        return Collections.emptyList();
                    }
                    targetPort = (Short)target;
                }
                OFPortStatisticsRequest specificReq = new OFPortStatisticsRequest();
                specificReq.setPortNumber(targetPort);
                req.setStatistics(Collections.singletonList(specificReq));
                requestLength += specificReq.getLength();
                type = "PORT";
            } else if (statsType == OFStatisticsType.QUEUE) {
                OFQueueStatisticsRequest specificReq = new OFQueueStatisticsRequest();
                specificReq.setPortNumber(OFPort.OFPP_ALL.getValue());
                specificReq.setQueueId(-1);
                req.setStatistics(Collections.singletonList(specificReq));
                requestLength += specificReq.getLength();
                type = "QUEUE";
            } else if (statsType == OFStatisticsType.DESC) {
                type = "DESC";
            } else if (statsType == OFStatisticsType.TABLE) {
                if (target != null) {
                    if (!(target instanceof Byte)) {
                        log.warn("Invalid table id for table stats request: {}", target.getClass());
                        return Collections.emptyList();
                    }
                    byte targetTable = (Byte)target;
                    OFTableStatistics specificReq = new OFTableStatistics();
                    specificReq.setTableId(targetTable);
                    req.setStatistics(Collections.singletonList(specificReq));
                    requestLength += specificReq.getLength();
                }
                type = "TABLE";
            }
            req.setLengthU(requestLength);
            Object result = sw.getStatistics(req);
            if (result == null) {
                log.warn("Request Timed Out for ({}) from switch {}", (Object)type, (Object)HexString.toHexString((long)switchId));
            } else if (result instanceof OFError) {
                log.warn("Switch {} failed to handle ({}) stats request: {}", new Object[]{HexString.toHexString((long)switchId), type, Utils.getOFErrorString((OFError)result)});
                if (this.switchSupportsVendorExtStats.get(switchId) == Boolean.TRUE) {
                    log.warn("Switching back to regular Flow stats requests for switch {}", (Object)HexString.toHexString((long)switchId));
                    this.switchSupportsVendorExtStats.put(switchId, Boolean.FALSE);
                }
            } else {
                values = (List)result;
            }
        }
        return values;
    }

    @Override
    public List<OFStatistics> getOFFlowStatistics(Long switchId) {
        List<OFStatistics> list = (List<OFStatistics>)this.flowStatistics.get(switchId);
        return list == null || list.isEmpty() ? Collections.emptyList() : (list.get(0) instanceof OFVendorStatistics ? this.v6StatsListToOFStatsList(list) : list);
    }

    @Override
    public List<OFStatistics> getOFFlowStatistics(Long switchId, OFMatch ofMatch, short priority) {
        List statsList = (List)this.flowStatistics.get(switchId);
        if (statsList == null || statsList.isEmpty()) {
            return Collections.emptyList();
        }
        if (statsList.get(0) instanceof OFVendorStatistics) {
            V6Match targetMatch = ofMatch instanceof V6Match ? (V6Match)ofMatch : new V6Match(ofMatch);
            List<OFStatistics> targetList = this.v6StatsListToOFStatsList(statsList);
            for (OFStatistics stats : targetList) {
                V6StatsReply v6Stats = (V6StatsReply)stats;
                V6Match v6Match = v6Stats.getMatch();
                if (v6Stats.getPriority() != priority || !targetMatch.equals(v6Match)) continue;
                ArrayList<OFStatistics> list = new ArrayList<OFStatistics>();
                list.add(stats);
                return list;
            }
        } else {
            for (OFStatistics stats : statsList) {
                OFFlowStatisticsReply flowStats = (OFFlowStatisticsReply)stats;
                if (flowStats.getPriority() != priority || !ofMatch.equals((Object)flowStats.getMatch())) continue;
                ArrayList<OFStatistics> list = new ArrayList<OFStatistics>();
                list.add(stats);
                return list;
            }
        }
        return Collections.emptyList();
    }

    private List<OFStatistics> v6StatsListToOFStatsList(List<OFStatistics> statistics) {
        if (statistics == null || statistics.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OFStatistics> v6statistics = new ArrayList<OFStatistics>();
        for (OFStatistics stats : statistics) {
            List<OFStatistics> r;
            if (!(stats instanceof OFVendorStatistics) || (r = OFStatisticsManager.getV6ReplyStatistics((OFVendorStatistics)stats)) == null) continue;
            v6statistics.addAll(r);
        }
        return v6statistics;
    }

    private static List<OFStatistics> getV6ReplyStatistics(OFVendorStatistics stat) {
        int vendor;
        int length = stat.getLength();
        ArrayList<OFStatistics> results = new ArrayList<OFStatistics>();
        if (length < 12) {
            return Collections.emptyList();
        }
        ByteBuffer data = ByteBuffer.allocate(length);
        stat.writeTo(data);
        data.rewind();
        if (log.isTraceEnabled()) {
            log.trace("getV6ReplyStatistics: Buffer BYTES ARE {}", (Object)HexString.toHexString((byte[])data.array()));
        }
        if ((vendor = data.getInt()) != 8992) {
            log.warn("Unexpected vendor id: 0x{}", (Object)Integer.toHexString(vendor));
            return Collections.emptyList();
        }
        data.getLong();
        length -= 12;
        while (length > 0) {
            V6StatsReply v6statsreply = new V6StatsReply();
            int min_len = v6statsreply.getLength();
            if (length < v6statsreply.getLength()) break;
            v6statsreply.setActionFactory(stat.getActionFactory());
            v6statsreply.readFrom(data);
            if (v6statsreply.getLength() < min_len) break;
            v6statsreply.setVendorId(vendor);
            log.trace("V6StatsReply: {}", (Object)v6statsreply);
            length -= v6statsreply.getLength();
            results.add((OFStatistics)v6statsreply);
        }
        return results;
    }

    @Override
    public List<OFStatistics> queryStatistics(Long switchId, OFStatisticsType statType, Object target) {
        if (statType == OFStatisticsType.FLOW && this.switchSupportsVendorExtStats.get(switchId) == Boolean.TRUE) {
            statType = OFStatisticsType.VENDOR;
        }
        List<OFStatistics> list = this.fetchStatisticsFromSwitch(switchId, statType, target);
        return statType == OFStatisticsType.VENDOR ? this.v6StatsListToOFStatsList(list) : list;
    }

    @Override
    public List<OFStatistics> getOFDescStatistics(Long switchId) {
        if (!this.descStatistics.containsKey(switchId)) {
            return Collections.emptyList();
        }
        return (List)this.descStatistics.get(switchId);
    }

    @Override
    public List<OFStatistics> getOFPortStatistics(Long switchId) {
        if (!this.portStatistics.containsKey(switchId)) {
            return Collections.emptyList();
        }
        return (List)this.portStatistics.get(switchId);
    }

    @Override
    public List<OFStatistics> getOFPortStatistics(Long switchId, short portId) {
        if (!this.portStatistics.containsKey(switchId)) {
            return Collections.emptyList();
        }
        ArrayList<OFStatistics> list = new ArrayList<OFStatistics>(1);
        for (OFStatistics stats : (List)this.portStatistics.get(switchId)) {
            if (((OFPortStatisticsReply)stats).getPortNumber() != portId) continue;
            list.add(stats);
            break;
        }
        return list;
    }

    @Override
    public List<OFStatistics> getOFTableStatistics(Long switchId) {
        if (!this.tableStatistics.containsKey(switchId)) {
            return Collections.emptyList();
        }
        return (List)this.tableStatistics.get(switchId);
    }

    @Override
    public List<OFStatistics> getOFTableStatistics(Long switchId, Byte tableId) {
        if (!this.tableStatistics.containsKey(switchId)) {
            return Collections.emptyList();
        }
        ArrayList<OFStatistics> list = new ArrayList<OFStatistics>(1);
        for (OFStatistics stats : (List)this.tableStatistics.get(switchId)) {
            if (((OFTableStatistics)stats).getTableId() != tableId.byteValue()) continue;
            list.add(stats);
            break;
        }
        return list;
    }

    @Override
    public int getFlowsNumber(long switchId) {
        return ((List)this.flowStatistics.get(switchId)).size();
    }

    @Override
    public void updateNode(Node node, UpdateType type, Set<Property> props) {
        Long switchId = (Long)node.getID();
        switch (type) {
            case ADDED: {
                this.addStatisticsTicks(switchId);
                break;
            }
            case REMOVED: {
                this.clearFlowStatsAndTicks(switchId);
            }
        }
    }

    @Override
    public void updateNodeConnector(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
    }

    private synchronized void updatePortsTxRate(long switchId) {
        List newPortStatistics = (List)this.portStatistics.get(switchId);
        if (newPortStatistics == null) {
            return;
        }
        Map<Short, TxRates> rates = this.txRates.get(switchId);
        if (rates == null) {
            rates = new HashMap<Short, TxRates>();
            this.txRates.put(switchId, rates);
        }
        for (OFStatistics stats : newPortStatistics) {
            long transmitBytes;
            OFPortStatisticsReply newPortStat = (OFPortStatisticsReply)stats;
            short port = newPortStat.getPortNumber();
            TxRates portRatesHolder = rates.get(port);
            if (portRatesHolder == null) {
                portRatesHolder = new TxRates();
                rates.put(port, portRatesHolder);
            }
            long value = (transmitBytes = newPortStat.getTransmitBytes()) < 0L ? 0L : transmitBytes;
            portRatesHolder.update(value);
        }
    }

    @Override
    public synchronized long getTransmitRate(Long switchId, Short port) {
        long average = 0L;
        if (switchId == null || port == null) {
            return average;
        }
        Map<Short, TxRates> perSwitch = this.txRates.get(switchId);
        if (perSwitch == null) {
            return average;
        }
        TxRates portRates = perSwitch.get(port);
        if (portRates == null) {
            return average;
        }
        return portRates.getAverageTxRate();
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---OF Statistics Manager utilities---\n");
        help.append("\t ofdumpstatsmgr         - Print Internal Stats Mgr db\n");
        help.append("\t ofstatsmgrintervals <fP> <pP> <dP> <tP> (all in seconds) - Set/Show flow/port/dedscription stats poll intervals\n");
        return help.toString();
    }

    private boolean isValidSwitchId(String switchId) {
        String regexDatapathID = "^([0-9a-fA-F]{1,2}[:-]){7}[0-9a-fA-F]{1,2}$";
        String regexDatapathIDLong = "^[0-9a-fA-F]{1,16}$";
        return switchId != null && (switchId.matches(regexDatapathID) || switchId.matches(regexDatapathIDLong));
    }

    public long getSwitchIDLong(String switchId) {
        int radix = 16;
        String switchString = "0";
        if (this.isValidSwitchId(switchId)) {
            switchString = switchId.contains(":") ? switchId.replace(":", "") : (switchId.contains("-") ? switchId.replace("-", "") : switchId);
        }
        return Long.parseLong(switchString, radix);
    }

    private String prettyPrintSwitchMap(ConcurrentMap<Long, StatisticsTicks> map) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (Map.Entry entry : map.entrySet()) {
            buffer.append(HexString.toHexString((long)((Long)entry.getKey())) + "=" + ((StatisticsTicks)entry.getValue()).toString() + " ");
        }
        buffer.append("}");
        return buffer.toString();
    }

    public void _ofdumpstatsmgr(CommandInterpreter ci) {
        ci.println((Object)("Global Counter: " + counter));
        ci.println((Object)("Timer Ticks: " + this.prettyPrintSwitchMap(this.statisticsTimerTicks)));
        ci.println((Object)("PendingStatsQueue: " + this.pendingStatsRequests));
        ci.println((Object)("PendingStatsQueue size: " + this.pendingStatsRequests.size()));
        ci.println((Object)("Stats Collector alive: " + this.statisticsCollector.isAlive()));
        ci.println((Object)("Stats Collector State: " + this.statisticsCollector.getState().toString()));
        ci.println((Object)("StatsTimer: " + this.statisticsTimer.toString()));
        ci.println((Object)("Flow Stats Period: " + statisticsTickNumber + " s"));
        ci.println((Object)("Desc Stats Period: " + descriptionTickNumber + " s"));
        ci.println((Object)("Port Stats Period: " + portTickNumber + " s"));
        ci.println((Object)("Table Stats Period: " + tableTickNumber + " s"));
    }

    public void _resetSwitchCapability(CommandInterpreter ci) {
        String sidString = ci.nextArgument();
        Long sid = null;
        if (sidString == null) {
            ci.println((Object)"Insert the switch id (numeric value)");
            return;
        }
        try {
            sid = Long.valueOf(sidString);
            this.switchSupportsVendorExtStats.put(sid, Boolean.TRUE);
            ci.println((Object)("Vendor capability for switch " + sid + " set to " + this.switchSupportsVendorExtStats.get(sid)));
        }
        catch (NumberFormatException e) {
            ci.println((Object)"Invalid switch id. Has to be numeric.");
        }
    }

    public void _ofbw(CommandInterpreter ci) {
        String sidString = ci.nextArgument();
        Long sid = null;
        if (sidString == null) {
            ci.println((Object)"Insert the switch id (numeric value)");
            return;
        }
        try {
            sid = Long.valueOf(sidString);
        }
        catch (NumberFormatException e) {
            ci.println((Object)"Invalid switch id. Has to be numeric.");
        }
        if (sid != null) {
            Map<Short, TxRates> thisSwitchRates = this.txRates.get(sid);
            ci.println((Object)("Bandwidth utilization (" + factoredSamples * portTickNumber + " sec average) for switch " + HexEncode.longToHexString((long)sid) + ":"));
            if (thisSwitchRates == null) {
                ci.println((Object)"Not available");
            } else {
                for (Map.Entry<Short, TxRates> entry : thisSwitchRates.entrySet()) {
                    ci.println((Object)("Port: " + entry.getKey() + ": " + entry.getValue().getAverageTxRate() + " bps"));
                }
            }
        }
    }

    public void _txratewindow(CommandInterpreter ci) {
        String averageWindow = ci.nextArgument();
        short seconds = 0;
        if (averageWindow == null) {
            ci.println((Object)"Insert the length in seconds of the median window for tx rate");
            ci.println((Object)("Current: " + factoredSamples * portTickNumber + " secs"));
            return;
        }
        try {
            seconds = Short.valueOf(averageWindow);
        }
        catch (NumberFormatException e) {
            ci.println((Object)"Invalid period.");
        }
        factoredSamples = (short)(seconds / portTickNumber);
        ci.println((Object)("New: " + factoredSamples * portTickNumber + " secs"));
    }

    public void _ofstatsmgrintervals(CommandInterpreter ci) {
        Short tP;
        Short dP;
        Short pP;
        Short fP;
        String flowStatsInterv = ci.nextArgument();
        String portStatsInterv = ci.nextArgument();
        String descStatsInterv = ci.nextArgument();
        String tableStatsInterv = ci.nextArgument();
        if (flowStatsInterv == null || portStatsInterv == null || descStatsInterv == null) {
            ci.println((Object)"Usage: ofstatsmgrintervals <fP> <pP> <dP> <tP> (all in seconds)");
            ci.println((Object)("Current Values: fP=" + statisticsTickNumber + "sec pP=" + portTickNumber + "sec dP=" + descriptionTickNumber + "sec tP=" + tableTickNumber + " sec"));
            return;
        }
        try {
            fP = Short.parseShort(flowStatsInterv);
            pP = Short.parseShort(portStatsInterv);
            dP = Short.parseShort(descStatsInterv);
            tP = Short.parseShort(tableStatsInterv);
        }
        catch (Exception e) {
            ci.println((Object)("Invalid format values: " + e.getMessage()));
            return;
        }
        if (pP <= 1 || fP <= 1 || dP <= 1 || tP <= 1) {
            ci.println((Object)"Invalid values. fP, pP, dP, tP have to be greater than 1.");
            return;
        }
        statisticsTickNumber = fP;
        portTickNumber = pP;
        descriptionTickNumber = dP;
        tableTickNumber = tP;
        ci.println((Object)("New Values: fP=" + statisticsTickNumber + "s pP=" + portTickNumber + "s dP=" + descriptionTickNumber + "s tP=" + tableTickNumber + "s"));
    }

    private void configStatsPollIntervals() {
        String fsStr = System.getProperty("of.flowStatsPollInterval");
        String psStr = System.getProperty("of.portStatsPollInterval");
        String dsStr = System.getProperty("of.descStatsPollInterval");
        String tsStr = System.getProperty("of.tableStatsPollInterval");
        if (fsStr != null) {
            try {
                Short fs = Short.parseShort(fsStr);
                if (fs > 0) {
                    statisticsTickNumber = fs;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (psStr != null) {
            try {
                Short ps = Short.parseShort(psStr);
                if (ps > 0) {
                    portTickNumber = ps;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (dsStr != null) {
            try {
                Short ds = Short.parseShort(dsStr);
                if (ds > 0) {
                    descriptionTickNumber = ds;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (tsStr != null) {
            try {
                Short ts = Short.parseShort(tsStr);
                if (ts > 0) {
                    tableTickNumber = ts;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected static class StatisticsTicks {
        private short flowStatisticsTicks;
        private short descriptionTicks;
        private short portStatisticsTicks;
        private short tableStatisticsTicks;

        public StatisticsTicks(boolean scattered) {
            if (scattered) {
                if ((counter = (short)(counter + 1)) < 0) {
                    counter = (short)0;
                }
                this.flowStatisticsTicks = (short)(1 + counter % statisticsTickNumber);
                this.descriptionTicks = (short)(1 + counter % descriptionTickNumber);
                this.portStatisticsTicks = (short)(1 + counter % portTickNumber);
                this.tableStatisticsTicks = (short)(1 + counter % tableTickNumber);
            } else {
                this.flowStatisticsTicks = statisticsTickNumber;
                this.descriptionTicks = descriptionTickNumber;
                this.portStatisticsTicks = portTickNumber;
                this.tableStatisticsTicks = tableTickNumber;
            }
        }

        public boolean decrementFlowTicksIsZero() {
            this.flowStatisticsTicks = (short)(this.flowStatisticsTicks - 1);
            if (this.flowStatisticsTicks == 0) {
                this.flowStatisticsTicks = statisticsTickNumber;
                return true;
            }
            return false;
        }

        public boolean decrementDescTicksIsZero() {
            this.descriptionTicks = (short)(this.descriptionTicks - 1);
            if (this.descriptionTicks == 0) {
                this.descriptionTicks = descriptionTickNumber;
                return true;
            }
            return false;
        }

        public boolean decrementPortTicksIsZero() {
            this.portStatisticsTicks = (short)(this.portStatisticsTicks - 1);
            if (this.portStatisticsTicks == 0) {
                this.portStatisticsTicks = portTickNumber;
                return true;
            }
            return false;
        }

        public boolean decrementTableTicksIsZero() {
            this.tableStatisticsTicks = (short)(this.tableStatisticsTicks - 1);
            if (this.tableStatisticsTicks == 0) {
                this.tableStatisticsTicks = tableTickNumber;
                return true;
            }
            return false;
        }

        public String toString() {
            return "{fT=" + this.flowStatisticsTicks + ",dT=" + this.descriptionTicks + ",pT=" + this.portStatisticsTicks + ",tT=" + this.tableStatisticsTicks + "}";
        }
    }

    private static class StatsRequest {
        protected Long switchId;
        protected OFStatisticsType type;

        public StatsRequest(Long d, OFStatisticsType t) {
            this.switchId = d;
            this.type = t;
        }

        public String toString() {
            return "SReq = {switchId=" + this.switchId + ", type=" + this.type + "}";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.switchId == null ? 0 : this.switchId.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.ordinal());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StatsRequest other = (StatsRequest)obj;
            if (this.switchId == null ? other.switchId != null : !this.switchId.equals(other.switchId)) {
                return false;
            }
            return this.type == other.type;
        }
    }

    protected class TxRates {
        Deque<Long> sampledTxBytes = new LinkedBlockingDeque<Long>();

        public void update(Long txBytes) {
            if (this.sampledTxBytes.size() == factoredSamples) {
                this.sampledTxBytes.removeLast();
            }
            this.sampledTxBytes.addFirst(txBytes);
        }

        public long getAverageTxRate() {
            long average = 0L;
            if (this.sampledTxBytes.size() < factoredSamples) {
                return average;
            }
            long increment = this.sampledTxBytes.getFirst() - this.sampledTxBytes.getLast();
            long timePeriod = (long)factoredSamples * 5000L / 1000L;
            average = 8L * increment / timePeriod;
            return average;
        }
    }
}

