/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryShimExternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryShimInternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.IOFStatisticsListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.IController;
import org.opendaylight.controller.protocol_plugin.openflow.core.IMessageListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitch;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitchStateListener;
import org.opendaylight.controller.protocol_plugin.openflow.internal.FlowConverter;
import org.opendaylight.controller.protocol_plugin.openflow.internal.InventoryServiceHelper;
import org.opendaylight.controller.protocol_plugin.openflow.internal.PortConverter;
import org.opendaylight.controller.sal.action.SupportedFlowActions;
import org.opendaylight.controller.sal.connection.ConnectionLocality;
import org.opendaylight.controller.sal.connection.IPluginOutConnectionService;
import org.opendaylight.controller.sal.core.Buffers;
import org.opendaylight.controller.sal.core.Capabilities;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.Description;
import org.opendaylight.controller.sal.core.IContainerAware;
import org.opendaylight.controller.sal.core.IContainerListener;
import org.opendaylight.controller.sal.core.MacAddress;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.Tables;
import org.opendaylight.controller.sal.core.TimeStamp;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.NodeCreator;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPortStatus;
import org.openflow.protocol.OFType;
import org.openflow.protocol.statistics.OFDescriptionStatistics;
import org.openflow.protocol.statistics.OFStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryServiceShim
implements IContainerListener,
IMessageListener,
ISwitchStateListener,
IOFStatisticsListener,
IContainerAware {
    protected static final Logger logger = LoggerFactory.getLogger(InventoryServiceShim.class);
    private IController controller = null;
    private final ConcurrentMap<String, IInventoryShimInternalListener> inventoryShimInternalListeners = new ConcurrentHashMap<String, IInventoryShimInternalListener>();
    private final Set<IInventoryShimInternalListener> globalInventoryShimInternalListeners = new HashSet<IInventoryShimInternalListener>();
    private final List<IInventoryShimExternalListener> inventoryShimExternalListeners = new CopyOnWriteArrayList<IInventoryShimExternalListener>();
    private final ConcurrentMap<NodeConnector, Set<String>> nodeConnectorContainerMap = new ConcurrentHashMap<NodeConnector, Set<String>>();
    private final ConcurrentMap<Node, Set<String>> nodeContainerMap = new ConcurrentHashMap<Node, Set<String>>();
    private final ConcurrentMap<NodeConnector, Set<Property>> nodeConnectorProps = new ConcurrentHashMap<NodeConnector, Set<Property>>();
    private final ConcurrentMap<Node, Set<Property>> nodeProps = new ConcurrentHashMap<Node, Set<Property>>();
    private IPluginOutConnectionService connectionOutService;

    void setController(IController s) {
        this.controller = s;
    }

    void unsetController(IController s) {
        if (this.controller == s) {
            this.controller = null;
        }
    }

    void setInventoryShimGlobalInternalListener(Map<?, ?> props, IInventoryShimInternalListener s) {
        if (this.globalInventoryShimInternalListeners != null) {
            this.globalInventoryShimInternalListeners.add(s);
        }
    }

    void unsetInventoryShimGlobalInternalListener(Map<?, ?> props, IInventoryShimInternalListener s) {
        if (this.globalInventoryShimInternalListeners != null) {
            this.globalInventoryShimInternalListeners.remove(s);
        }
    }

    void setInventoryShimInternalListener(Map<?, ?> props, IInventoryShimInternalListener s) {
        if (props == null) {
            logger.error("setInventoryShimInternalListener property is null");
            return;
        }
        String containerName = (String)props.get("containerName");
        if (containerName == null) {
            logger.error("setInventoryShimInternalListener containerName not supplied");
            return;
        }
        if (this.inventoryShimInternalListeners != null && !this.inventoryShimInternalListeners.containsValue(s)) {
            this.inventoryShimInternalListeners.put(containerName, s);
            logger.trace("Added inventoryShimInternalListener for container {}", (Object)containerName);
        }
    }

    void unsetInventoryShimInternalListener(Map<?, ?> props, IInventoryShimInternalListener s) {
        if (props == null) {
            logger.error("unsetInventoryShimInternalListener property is null");
            return;
        }
        String containerName = (String)props.get("containerName");
        if (containerName == null) {
            logger.error("setInventoryShimInternalListener containerName not supplied");
            return;
        }
        if (this.inventoryShimInternalListeners != null && this.inventoryShimInternalListeners.get(containerName) != null && ((IInventoryShimInternalListener)this.inventoryShimInternalListeners.get(containerName)).equals(s)) {
            this.inventoryShimInternalListeners.remove(containerName);
            logger.trace("Removed inventoryShimInternalListener for container {}", (Object)containerName);
        }
    }

    void setInventoryShimExternalListener(IInventoryShimExternalListener s) {
        logger.trace("Set inventoryShimExternalListener {}", (Object)s);
        if (this.inventoryShimExternalListeners != null && !this.inventoryShimExternalListeners.contains(s)) {
            this.inventoryShimExternalListeners.add(s);
        }
    }

    void unsetInventoryShimExternalListener(IInventoryShimExternalListener s) {
        logger.trace("Unset inventoryShimExternalListener {}", (Object)s);
        if (this.inventoryShimExternalListeners != null && this.inventoryShimExternalListeners.contains(s)) {
            this.inventoryShimExternalListeners.remove(s);
        }
    }

    void setIPluginOutConnectionService(IPluginOutConnectionService s) {
        this.connectionOutService = s;
    }

    void unsetIPluginOutConnectionService(IPluginOutConnectionService s) {
        if (this.connectionOutService == s) {
            this.connectionOutService = null;
        }
    }

    void init() {
        this.controller.addMessageListener(OFType.PORT_STATUS, this);
        this.controller.addSwitchStateListener(this);
    }

    void started() {
        this.startService();
    }

    void destroy() {
        this.controller.removeMessageListener(OFType.PACKET_IN, this);
        this.controller.removeSwitchStateListener(this);
        this.inventoryShimInternalListeners.clear();
        this.nodeConnectorContainerMap.clear();
        this.nodeContainerMap.clear();
        this.globalInventoryShimInternalListeners.clear();
        this.controller = null;
    }

    @Override
    public void receive(ISwitch sw, OFMessage msg) {
        if (msg instanceof OFPortStatus) {
            this.handlePortStatusMessage(sw, (OFPortStatus)msg);
        }
    }

    protected void handlePortStatusMessage(ISwitch sw, OFPortStatus m) {
        Node node = NodeCreator.createOFNode((Long)sw.getId());
        NodeConnector nodeConnector = PortConverter.toNodeConnector(m.getDesc().getPortNumber(), node);
        Set<Property> props = InventoryServiceHelper.OFPortToProps(m.getDesc());
        UpdateType type = null;
        if (m.getReason() == (byte)OFPortStatus.OFPortReason.OFPPR_ADD.ordinal()) {
            type = UpdateType.ADDED;
            this.nodeConnectorProps.put(nodeConnector, props);
        } else if (m.getReason() == (byte)OFPortStatus.OFPortReason.OFPPR_DELETE.ordinal()) {
            type = UpdateType.REMOVED;
            this.nodeConnectorProps.remove(nodeConnector);
        } else if (m.getReason() == (byte)OFPortStatus.OFPortReason.OFPPR_MODIFY.ordinal()) {
            type = UpdateType.CHANGED;
            this.nodeConnectorProps.put(nodeConnector, props);
        }
        logger.trace("handlePortStatusMessage {} type {}", (Object)nodeConnector, (Object)type);
        if (type != null) {
            this.notifyInventoryShimListener(nodeConnector, type, props);
        }
    }

    @Override
    public void switchAdded(ISwitch sw) {
        if (sw == null) {
            logger.debug("Ignore null switch addition");
            return;
        }
        Node node = NodeCreator.createOFNode((Long)sw.getId());
        if (this.nodeProps.get(node) != null && this.connectionOutService.isLocal(node)) {
            logger.debug("Ignore switchAdded {}", (Object)sw);
            return;
        }
        Map<NodeConnector, Set<Property>> ncProps = InventoryServiceHelper.OFSwitchToProps(sw);
        if (!ncProps.isEmpty()) {
            for (Map.Entry<NodeConnector, Set<Property>> entry : ncProps.entrySet()) {
                HashSet<Property> props = new HashSet<Property>();
                Set<Property> prop = entry.getValue();
                if (prop != null) {
                    props.addAll(prop);
                }
                this.nodeConnectorProps.put(entry.getKey(), props);
                this.notifyInventoryShimListener(entry.getKey(), UpdateType.ADDED, entry.getValue());
            }
        } else {
            this.notifyInventoryShimListener(node, UpdateType.ADDED, Collections.emptySet());
        }
        if (this.connectionOutService.getLocalityStatus(node) != ConnectionLocality.NOT_CONNECTED) {
            this.addNode(sw);
        } else {
            logger.debug("Skipping node addition due to Connectivity Status : {}", (Object)this.connectionOutService.getLocalityStatus(node).name());
        }
    }

    @Override
    public void switchDeleted(ISwitch sw) {
        if (sw == null) {
            return;
        }
        this.removeNode(sw);
    }

    public void containerModeUpdated(UpdateType t) {
    }

    public void tagUpdated(String containerName, Node n, short oldTag, short newTag, UpdateType t) {
        logger.debug("tagUpdated: {} type {} for container {}", new Object[]{n, t, containerName});
    }

    public void containerFlowUpdated(String containerName, ContainerFlow previousFlow, ContainerFlow currentFlow, UpdateType t) {
    }

    public void nodeConnectorUpdated(String containerName, NodeConnector nc, UpdateType t) {
        logger.debug("nodeConnectorUpdated: {} type {} for container {}", new Object[]{nc, t, containerName});
        Node node = nc.getNode();
        CopyOnWriteArraySet<String> ncContainers = (CopyOnWriteArraySet<String>)this.nodeConnectorContainerMap.get(nc);
        CopyOnWriteArraySet<String> nodeContainers = (CopyOnWriteArraySet<String>)this.nodeContainerMap.get(node);
        if (ncContainers == null) {
            ncContainers = new CopyOnWriteArraySet<String>();
        }
        if (nodeContainers == null) {
            nodeContainers = new CopyOnWriteArraySet<String>();
        }
        boolean notifyNodeUpdate = false;
        switch (t) {
            case ADDED: {
                if (ncContainers.add(containerName)) {
                    this.nodeConnectorContainerMap.put(nc, ncContainers);
                }
                if (!nodeContainers.add(containerName)) break;
                this.nodeContainerMap.put(node, nodeContainers);
                notifyNodeUpdate = true;
                break;
            }
            case REMOVED: {
                if (ncContainers.remove(containerName)) {
                    if (ncContainers.isEmpty()) {
                        this.nodeConnectorContainerMap.remove(nc);
                    } else {
                        this.nodeConnectorContainerMap.put(nc, ncContainers);
                    }
                }
                boolean nodeContainerUpdate = true;
                for (NodeConnector ncContainer : this.nodeConnectorContainerMap.keySet()) {
                    if (!ncContainer.getNode().equals((Object)node) || !((Set)this.nodeConnectorContainerMap.get(ncContainer)).contains(containerName)) continue;
                    nodeContainerUpdate = false;
                    break;
                }
                if (!nodeContainerUpdate) break;
                nodeContainers.remove(containerName);
                notifyNodeUpdate = true;
                if (nodeContainers.isEmpty()) {
                    this.nodeContainerMap.remove(node);
                    break;
                }
                this.nodeContainerMap.put(node, nodeContainers);
                break;
            }
        }
        Set nodeProp = (Set)this.nodeProps.get(node);
        if (nodeProp == null) {
            return;
        }
        Set ncProp = (Set)this.nodeConnectorProps.get(nc);
        this.notifyInventoryShimInternalListener(containerName, nc, t, (Set<Property>)ncProp);
        if (notifyNodeUpdate) {
            this.notifyInventoryShimInternalListener(containerName, node, t, (Set<Property>)nodeProp);
        }
    }

    private void notifyInventoryShimExternalListener(Node node, UpdateType type, Set<Property> props) {
        for (IInventoryShimExternalListener s : this.inventoryShimExternalListeners) {
            s.updateNode(node, type, props);
        }
    }

    private void notifyInventoryShimExternalListener(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
        for (IInventoryShimExternalListener s : this.inventoryShimExternalListeners) {
            s.updateNodeConnector(nodeConnector, type, props);
        }
    }

    private void notifyInventoryShimInternalListener(String container, NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
        IInventoryShimInternalListener inventoryShimInternalListener = (IInventoryShimInternalListener)this.inventoryShimInternalListeners.get(container);
        if (inventoryShimInternalListener != null) {
            inventoryShimInternalListener.updateNodeConnector(nodeConnector, type, props);
            logger.trace("notifyInventoryShimInternalListener {} type {} for container {}", new Object[]{nodeConnector, type, container});
        }
    }

    private void notifyInventoryShimListener(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
        boolean isNodeLocal;
        if (type == UpdateType.REMOVED) {
            isNodeLocal = this.connectionOutService.isLocal(nodeConnector.getNode());
            this.notifyGlobalInventoryShimInternalListener(nodeConnector, type, props);
        } else {
            this.notifyGlobalInventoryShimInternalListener(nodeConnector, type, props);
            isNodeLocal = this.connectionOutService.isLocal(nodeConnector.getNode());
        }
        if (isNodeLocal) {
            HashSet<String> containers = this.nodeConnectorContainerMap.get(nodeConnector) == null ? new HashSet<String>() : new HashSet((Collection)this.nodeConnectorContainerMap.get(nodeConnector));
            containers.add(GlobalConstants.DEFAULT.toString());
            for (String container : containers) {
                this.notifyInventoryShimInternalListener(container, nodeConnector, type, props);
            }
            this.notifyInventoryShimExternalListener(nodeConnector, type, props);
            logger.debug("Connection service accepted the inventory notification for {} {}", (Object)nodeConnector, (Object)type);
        } else {
            logger.debug("Connection service dropped the inventory notification for {} {}", (Object)nodeConnector, (Object)type);
        }
    }

    private void notifyInventoryShimListener(Node node, UpdateType type, Set<Property> props) {
        boolean isNodeLocal;
        if (type == UpdateType.REMOVED) {
            isNodeLocal = this.connectionOutService.isLocal(node);
            this.notifyGlobalInventoryShimInternalListener(node, type, props);
        } else {
            this.notifyGlobalInventoryShimInternalListener(node, type, props);
            isNodeLocal = this.connectionOutService.isLocal(node);
        }
        if (isNodeLocal) {
            HashSet<String> containers = this.nodeContainerMap.get(node) == null ? new HashSet<String>() : new HashSet((Collection)this.nodeContainerMap.get(node));
            containers.add(GlobalConstants.DEFAULT.toString());
            for (String container : containers) {
                this.notifyInventoryShimInternalListener(container, node, type, props);
            }
            this.notifyInventoryShimExternalListener(node, type, props);
            logger.debug("Connection service accepted the inventory notification for {} {}", (Object)node, (Object)type);
        } else {
            logger.debug("Connection service dropped the inventory notification for {} {}", (Object)node, (Object)type);
        }
    }

    private void notifyGlobalInventoryShimInternalListener(Node node, UpdateType type, Set<Property> props) {
        for (IInventoryShimInternalListener globalListener : this.globalInventoryShimInternalListeners) {
            globalListener.updateNode(node, type, props);
            logger.trace("notifyGlobalInventoryShimInternalListener {} type {}", new Object[]{node, type});
        }
    }

    private void notifyGlobalInventoryShimInternalListener(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
        for (IInventoryShimInternalListener globalListener : this.globalInventoryShimInternalListeners) {
            globalListener.updateNodeConnector(nodeConnector, type, props);
            logger.trace("notifyGlobalInventoryShimInternalListener {} type {}", new Object[]{nodeConnector, type});
        }
    }

    private void notifyInventoryShimInternalListener(String container, Node node, UpdateType type, Set<Property> props) {
        IInventoryShimInternalListener inventoryShimInternalListener = (IInventoryShimInternalListener)this.inventoryShimInternalListeners.get(container);
        if (inventoryShimInternalListener != null) {
            inventoryShimInternalListener.updateNode(node, type, props);
            logger.trace("notifyInventoryShimInternalListener {} type {} for container {}", new Object[]{node, type, container});
        }
    }

    private void addNode(ISwitch sw) {
        int buffers;
        Buffers b;
        int act;
        SupportedFlowActions a;
        int cap;
        Capabilities c;
        Node node = NodeCreator.createOFNode((Long)sw.getId());
        UpdateType type = UpdateType.ADDED;
        HashSet<Property> props = new HashSet<Property>();
        Long sid = (Long)node.getID();
        Date connectedSince = sw.getConnectedDate();
        Long connectedSinceTime = connectedSince == null ? 0L : connectedSince.getTime();
        props.add((Property)new TimeStamp(connectedSinceTime.longValue(), "connectedSince"));
        props.add((Property)new MacAddress(this.deriveMacAddress(sid)));
        byte tables = sw.getTables();
        Tables t = new Tables(tables);
        if (t != null) {
            props.add((Property)t);
        }
        if ((c = new Capabilities(cap = sw.getCapabilities().intValue())) != null) {
            props.add((Property)c);
        }
        if ((a = new SupportedFlowActions(FlowConverter.getFlowActions(act = sw.getActions().intValue()))) != null) {
            props.add((Property)a);
        }
        if ((b = new Buffers(buffers = sw.getBuffers().intValue())) != null) {
            props.add((Property)b);
        }
        if (this.nodeProps.get(node) == null && this.connectionOutService.isLocal(node)) {
            sw.deleteAllFlows();
        }
        this.nodeProps.put(node, props);
        this.notifyInventoryShimListener(node, type, props);
    }

    private void removeNode(ISwitch sw) {
        Node node = NodeCreator.createOFNode((Long)sw.getId());
        if (node == null) {
            return;
        }
        this.removeNodeConnectorProps(node);
        this.nodeProps.remove(node);
        UpdateType type = UpdateType.REMOVED;
        this.notifyInventoryShimListener(node, type, null);
    }

    private void startService() {
        Map<Long, ISwitch> switches = this.controller.getSwitches();
        for (ISwitch sw : switches.values()) {
            this.switchAdded(sw);
        }
    }

    private void removeNodeConnectorProps(Node node) {
        ArrayList<NodeConnector> ncList = new ArrayList<NodeConnector>();
        for (NodeConnector nc : this.nodeConnectorProps.keySet()) {
            if (!nc.getNode().equals((Object)node)) continue;
            ncList.add(nc);
        }
        for (NodeConnector nc : ncList) {
            this.nodeConnectorProps.remove(nc);
        }
    }

    @Override
    public void descriptionStatisticsRefreshed(Long switchId, List<OFStatistics> descriptionStats) {
        Node node = NodeCreator.createOFNode((Long)switchId);
        HashSet<Property> properties = new HashSet<Property>(1);
        OFDescriptionStatistics ofDesc = (OFDescriptionStatistics)descriptionStats.get(0);
        Description desc = new Description(ofDesc.getDatapathDescription());
        properties.add((Property)desc);
        this.notifyInventoryShimListener(node, UpdateType.CHANGED, properties);
    }

    private byte[] deriveMacAddress(long dpid) {
        byte[] mac = new byte[]{0, 0, 0, 0, 0, 0};
        for (int i = 0; i < 6; i = (int)((short)(i + 1))) {
            mac[5 - i] = (byte)dpid;
            dpid >>= 8;
        }
        return mac;
    }

    @Override
    public void flowStatisticsRefreshed(Long switchId, List<OFStatistics> flows) {
    }

    @Override
    public void portStatisticsRefreshed(Long switchId, List<OFStatistics> ports) {
    }

    @Override
    public void tableStatisticsRefreshed(Long switchId, List<OFStatistics> tables) {
    }

    public void containerCreate(String containerName) {
    }

    public void containerDestroy(String containerName) {
        Set nodeContainers;
        Set ncContainers;
        HashSet<NodeConnector> removeNodeConnectorSet = new HashSet<NodeConnector>();
        HashSet<Node> removeNodeSet = new HashSet<Node>();
        for (Map.Entry entry : this.nodeConnectorContainerMap.entrySet()) {
            ncContainers = (Set)entry.getValue();
            if (!ncContainers.contains(containerName)) continue;
            NodeConnector nodeConnector = (NodeConnector)entry.getKey();
            removeNodeConnectorSet.add(nodeConnector);
        }
        for (Map.Entry entry : this.nodeContainerMap.entrySet()) {
            nodeContainers = (Set)entry.getValue();
            if (!nodeContainers.contains(containerName)) continue;
            Node node = (Node)entry.getKey();
            removeNodeSet.add(node);
        }
        for (NodeConnector nodeConnector : removeNodeConnectorSet) {
            ncContainers = (Set)this.nodeConnectorContainerMap.get(nodeConnector);
            ncContainers.remove(containerName);
            if (!ncContainers.isEmpty()) continue;
            this.nodeConnectorContainerMap.remove(nodeConnector);
        }
        for (Node node : removeNodeSet) {
            nodeContainers = (Set)this.nodeContainerMap.get(node);
            nodeContainers.remove(containerName);
            if (!nodeContainers.isEmpty()) continue;
            this.nodeContainerMap.remove(node);
        }
    }
}

