/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitch;
import org.opendaylight.controller.protocol_plugin.openflow.internal.PortConverter;
import org.opendaylight.controller.sal.core.AdvertisedBandwidth;
import org.opendaylight.controller.sal.core.Bandwidth;
import org.opendaylight.controller.sal.core.Config;
import org.opendaylight.controller.sal.core.Name;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.PeerBandwidth;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.State;
import org.opendaylight.controller.sal.core.SupportedBandwidth;
import org.opendaylight.controller.sal.utils.NodeCreator;
import org.openflow.protocol.OFPhysicalPort;

public class InventoryServiceHelper {
    public static Bandwidth OFPortToBandWidth(int portFeatures) {
        Bandwidth bw = null;
        int value = portFeatures & (OFPhysicalPort.OFPortFeatures.OFPPF_10MB_FD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_10MB_HD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_100MB_FD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_100MB_HD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_1GB_FD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_1GB_HD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_10GB_FD.getValue());
        switch (value) {
            case 1: 
            case 2: {
                bw = new Bandwidth(Bandwidth.BW10Mbps);
                break;
            }
            case 4: 
            case 8: {
                bw = new Bandwidth(Bandwidth.BW100Mbps);
                break;
            }
            case 16: 
            case 32: {
                bw = new Bandwidth(Bandwidth.BW1Gbps);
                break;
            }
            case 64: {
                bw = new Bandwidth(Bandwidth.BW10Gbps);
                break;
            }
        }
        return bw;
    }

    public static Config OFPortToConfig(int portConfig) {
        Config config = (OFPhysicalPort.OFPortConfig.OFPPC_PORT_DOWN.getValue() & portConfig) != 0 ? new Config(0) : new Config(1);
        return config;
    }

    public static State OFPortToState(int portState) {
        State state = (OFPhysicalPort.OFPortState.OFPPS_LINK_DOWN.getValue() & portState) != 0 ? new State(0) : new State(1);
        return state;
    }

    public static Set<Property> OFPortToProps(OFPhysicalPort port) {
        PeerBandwidth p;
        Bandwidth pbw;
        SupportedBandwidth s;
        Bandwidth sbw;
        AdvertisedBandwidth a;
        Bandwidth abw;
        HashSet<Property> props = new HashSet<Property>();
        Bandwidth bw = InventoryServiceHelper.OFPortToBandWidth(port.getCurrentFeatures());
        if (bw != null) {
            props.add((Property)bw);
        }
        if ((abw = InventoryServiceHelper.OFPortToBandWidth(port.getAdvertisedFeatures())) != null && (a = new AdvertisedBandwidth(abw.getValue())) != null) {
            props.add((Property)a);
        }
        if ((sbw = InventoryServiceHelper.OFPortToBandWidth(port.getSupportedFeatures())) != null && (s = new SupportedBandwidth(sbw.getValue())) != null) {
            props.add((Property)s);
        }
        if ((pbw = InventoryServiceHelper.OFPortToBandWidth(port.getPeerFeatures())) != null && (p = new PeerBandwidth(pbw.getValue())) != null) {
            props.add((Property)p);
        }
        props.add((Property)new Name(port.getName()));
        props.add((Property)InventoryServiceHelper.OFPortToConfig(port.getConfig()));
        props.add((Property)InventoryServiceHelper.OFPortToState(port.getState()));
        return props;
    }

    public static Map<NodeConnector, Set<Property>> OFSwitchToProps(ISwitch sw) {
        HashMap<NodeConnector, Set<Property>> ncProps = new HashMap<NodeConnector, Set<Property>>();
        if (sw == null) {
            return ncProps;
        }
        Node node = NodeCreator.createOFNode((Long)sw.getId());
        if (node == null) {
            return ncProps;
        }
        Map<Short, OFPhysicalPort> ports = sw.getPhysicalPorts();
        for (Map.Entry<Short, OFPhysicalPort> entry : ports.entrySet()) {
            NodeConnector nodeConnector = PortConverter.toNodeConnector(entry.getKey(), node);
            OFPhysicalPort port = entry.getValue();
            Set<Property> props = InventoryServiceHelper.OFPortToProps(port);
            ncProps.put(nodeConnector, props);
        }
        return ncProps;
    }
}

