/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryProvider;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryShimInternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.IController;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitch;
import org.opendaylight.controller.protocol_plugin.openflow.internal.InventoryServiceHelper;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.inventory.IPluginInInventoryService;
import org.opendaylight.controller.sal.inventory.IPluginOutInventoryService;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryService
implements IInventoryShimInternalListener,
IPluginInInventoryService,
IInventoryProvider {
    protected static final Logger logger = LoggerFactory.getLogger(InventoryService.class);
    private final Set<IPluginOutInventoryService> pluginOutInventoryServices = new CopyOnWriteArraySet<IPluginOutInventoryService>();
    private IController controller = null;
    private ConcurrentMap<Node, Map<String, Property>> nodeProps;
    private ConcurrentMap<NodeConnector, Map<String, Property>> nodeConnectorProps;
    private boolean isDefaultContainer = false;
    private String containerName = null;

    void setController(IController s) {
        this.controller = s;
    }

    void unsetController(IController s) {
        if (this.controller == s) {
            this.controller = null;
        }
    }

    void init(Component c) {
        logger.trace("INIT called!");
        Dictionary props = c.getServiceProperties();
        if (props != null) {
            this.containerName = (String)props.get("containerName");
            if (this.containerName != null) {
                this.isDefaultContainer = this.containerName.equals(GlobalConstants.DEFAULT.toString());
            }
        }
        this.nodeProps = new ConcurrentHashMap<Node, Map<String, Property>>();
        this.nodeConnectorProps = new ConcurrentHashMap<NodeConnector, Map<String, Property>>();
    }

    void destroy() {
        logger.trace("DESTROY called!");
    }

    void start() {
        logger.trace("START called!");
    }

    void stop() {
        logger.trace("STOP called!");
        this.pluginOutInventoryServices.clear();
    }

    public void setPluginOutInventoryServices(IPluginOutInventoryService service) {
        logger.trace("Got a service set request {}", (Object)service);
        if (this.pluginOutInventoryServices != null) {
            this.pluginOutInventoryServices.add(service);
        }
    }

    public void unsetPluginOutInventoryServices(IPluginOutInventoryService service) {
        logger.trace("Got a service UNset request");
        if (this.pluginOutInventoryServices != null) {
            this.pluginOutInventoryServices.remove(service);
        }
    }

    public ConcurrentMap<Node, Map<String, Property>> getNodeProps() {
        logger.debug("getNodePros for container {}", (Object)this.containerName);
        return this.nodeProps;
    }

    public Set<Node> getConfiguredNotConnectedNodes() {
        return Collections.emptySet();
    }

    public ConcurrentMap<NodeConnector, Map<String, Property>> getNodeConnectorProps(Boolean refresh) {
        if (this.nodeConnectorProps == null) {
            return null;
        }
        if (this.isDefaultContainer && refresh.booleanValue()) {
            Map<Long, ISwitch> switches = this.controller.getSwitches();
            for (ISwitch sw : switches.values()) {
                Map<NodeConnector, Set<Property>> ncProps = InventoryServiceHelper.OFSwitchToProps(sw);
                for (Map.Entry<NodeConnector, Set<Property>> entry : ncProps.entrySet()) {
                    this.updateNodeConnector(entry.getKey(), UpdateType.ADDED, entry.getValue());
                }
            }
        }
        return this.nodeConnectorProps;
    }

    @Override
    public void updateNodeConnector(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
        logger.trace("updateNodeConnector {} type {}", (Object)nodeConnector, (Object)type.getName());
        if (this.nodeConnectorProps == null) {
            logger.trace("nodeConnectorProps is null");
            return;
        }
        HashMap<String, Property> propMap = (HashMap<String, Property>)this.nodeConnectorProps.get(nodeConnector);
        switch (type) {
            case ADDED: 
            case CHANGED: {
                if (propMap == null) {
                    propMap = new HashMap<String, Property>();
                }
                if (props != null) {
                    for (Property prop : props) {
                        propMap.put(prop.getName(), prop);
                    }
                }
                this.nodeConnectorProps.put(nodeConnector, propMap);
                break;
            }
            case REMOVED: {
                this.nodeConnectorProps.remove(nodeConnector);
                break;
            }
            default: {
                return;
            }
        }
        for (IPluginOutInventoryService service : this.pluginOutInventoryServices) {
            service.updateNodeConnector(nodeConnector, type, props);
        }
    }

    private void addNode(Node node, Set<Property> props) {
        if (this.nodeProps == null) {
            return;
        }
        logger.trace("addNode: {} added, props: {} for container {}", new Object[]{node, props, this.containerName});
        HashMap<String, Property> propMap = (HashMap<String, Property>)this.nodeProps.get(node);
        if (propMap == null) {
            propMap = new HashMap<String, Property>();
        }
        if (props != null) {
            for (Property prop : props) {
                propMap.put(prop.getName(), prop);
            }
        }
        this.nodeProps.put(node, propMap);
        for (IPluginOutInventoryService service : this.pluginOutInventoryServices) {
            service.updateNode(node, UpdateType.ADDED, props);
        }
    }

    private void removeNode(Node node) {
        logger.trace("{} removed", (Object)node);
        if (this.nodeProps == null) {
            return;
        }
        this.nodeProps.remove(node);
        HashSet<NodeConnector> removeSet = new HashSet<NodeConnector>();
        for (NodeConnector nodeConnector : this.nodeConnectorProps.keySet()) {
            if (!nodeConnector.getNode().equals((Object)node)) continue;
            removeSet.add(nodeConnector);
        }
        for (NodeConnector nodeConnector : removeSet) {
            this.nodeConnectorProps.remove(nodeConnector);
        }
        for (IPluginOutInventoryService service : this.pluginOutInventoryServices) {
            service.updateNode(node, UpdateType.REMOVED, null);
        }
    }

    private void updateNode(Node node, Set<Property> properties) {
        logger.trace("{} updated, props: {}", (Object)node, properties);
        if (this.nodeProps == null || !this.nodeProps.containsKey(node) || properties == null || properties.isEmpty()) {
            return;
        }
        HashSet<Property> newProperties = new HashSet<Property>(properties.size());
        Map propertyMap = (Map)this.nodeProps.get(node);
        for (Property property : properties) {
            String name;
            Property currentProperty;
            if (property.equals((Object)(currentProperty = (Property)propertyMap.get(name = property.getName())))) continue;
            propertyMap.put(name, property);
            newProperties.add(property);
        }
        if (!newProperties.isEmpty()) {
            for (IPluginOutInventoryService service : this.pluginOutInventoryServices) {
                service.updateNode(node, UpdateType.CHANGED, newProperties);
            }
        }
    }

    @Override
    public void updateNode(Node node, UpdateType type, Set<Property> props) {
        switch (type) {
            case ADDED: {
                this.addNode(node, props);
                break;
            }
            case REMOVED: {
                this.removeNode(node);
                break;
            }
            case CHANGED: {
                this.updateNode(node, props);
                break;
            }
        }
    }
}

