/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.protocol_plugin.openflow.IFlowProgrammerNotifier;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryShimExternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.IController;
import org.opendaylight.controller.protocol_plugin.openflow.core.IMessageListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitch;
import org.opendaylight.controller.protocol_plugin.openflow.internal.FlowConverter;
import org.opendaylight.controller.protocol_plugin.openflow.internal.Utils;
import org.opendaylight.controller.sal.connection.IPluginOutConnectionService;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.IContainerAware;
import org.opendaylight.controller.sal.core.IContainerListener;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.flowprogrammer.IPluginInFlowProgrammerService;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.utils.EtherTypes;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.controller.sal.utils.NodeCreator;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.openflow.protocol.OFError;
import org.openflow.protocol.OFFlowRemoved;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPort;
import org.openflow.protocol.OFType;
import org.openflow.protocol.action.OFAction;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowProgrammerService
implements IPluginInFlowProgrammerService,
IMessageListener,
IContainerListener,
IInventoryShimExternalListener,
CommandProvider,
IContainerAware {
    private static final Logger log = LoggerFactory.getLogger(FlowProgrammerService.class);
    private IController controller = null;
    private ConcurrentMap<String, IFlowProgrammerNotifier> flowProgrammerNotifiers;
    private Map<String, Set<NodeConnector>> containerToNc;
    private ConcurrentMap<Long, Map<Integer, Long>> xid2rid;
    private int barrierMessagePriorCount = this.getBarrierMessagePriorCount();
    private IPluginOutConnectionService connectionOutService;

    public FlowProgrammerService() {
        this.flowProgrammerNotifiers = new ConcurrentHashMap<String, IFlowProgrammerNotifier>();
        this.containerToNc = new HashMap<String, Set<NodeConnector>>();
        this.xid2rid = new ConcurrentHashMap<Long, Map<Integer, Long>>();
    }

    public void setController(IController core) {
        this.controller = core;
    }

    public void unsetController(IController core) {
        if (this.controller == core) {
            this.controller = null;
        }
    }

    void setIPluginOutConnectionService(IPluginOutConnectionService s) {
        this.connectionOutService = s;
    }

    void unsetIPluginOutConnectionService(IPluginOutConnectionService s) {
        if (this.connectionOutService == s) {
            this.connectionOutService = null;
        }
    }

    public void setFlowProgrammerNotifier(Map<String, ?> props, IFlowProgrammerNotifier s) {
        if (props == null || props.get("containerName") == null) {
            log.error("Didn't receive the service correct properties");
            return;
        }
        String containerName = (String)props.get("containerName");
        this.flowProgrammerNotifiers.put(containerName, s);
    }

    public void unsetFlowProgrammerNotifier(Map<String, ?> props, IFlowProgrammerNotifier s) {
        if (props == null || props.get("containerName") == null) {
            log.error("Didn't receive the service correct properties");
            return;
        }
        String containerName = (String)props.get("containerName");
        if (this.flowProgrammerNotifiers != null && this.flowProgrammerNotifiers.containsKey(containerName) && this.flowProgrammerNotifiers.get(containerName) == s) {
            this.flowProgrammerNotifiers.remove(containerName);
        }
    }

    void init() {
        this.controller.addMessageListener(OFType.FLOW_REMOVED, this);
        this.controller.addMessageListener(OFType.ERROR, this);
        this.registerWithOSGIConsole();
    }

    void destroy() {
    }

    void start() {
    }

    void stop() {
    }

    public Status addFlow(Node node, Flow flow) {
        if (!this.connectionOutService.isLocal(node)) {
            log.debug("Add flow will not be processed in a non-master controller for node " + node);
            return new Status(StatusCode.NOTALLOWED, "This is not the master controller for " + node);
        }
        return this.addFlowInternal(node, flow, 0L);
    }

    public Status modifyFlow(Node node, Flow oldFlow, Flow newFlow) {
        if (!this.connectionOutService.isLocal(node)) {
            log.debug("Modify flow will not be processed in a non-master controller for node " + node);
            return new Status(StatusCode.NOTALLOWED, "This is not the master controller for " + node);
        }
        return this.modifyFlowInternal(node, oldFlow, newFlow, 0L);
    }

    public Status removeFlow(Node node, Flow flow) {
        if (!this.connectionOutService.isLocal(node)) {
            log.debug("Remove flow will not be processed in a non-master controller for node " + node);
            return new Status(StatusCode.NOTALLOWED, "This is not the master controller for " + node);
        }
        return this.removeFlowInternal(node, flow, 0L);
    }

    public Status addFlowAsync(Node node, Flow flow, long rid) {
        if (!this.connectionOutService.isLocal(node)) {
            log.debug("Add flow Async will not be processed in a non-master controller for node " + node);
            return new Status(StatusCode.NOTALLOWED, "This is not the master controller for " + node);
        }
        return this.addFlowInternal(node, flow, rid);
    }

    public Status modifyFlowAsync(Node node, Flow oldFlow, Flow newFlow, long rid) {
        if (!this.connectionOutService.isLocal(node)) {
            log.debug("Modify flow async will not be processed in a non-master controller for node " + node);
            return new Status(StatusCode.NOTALLOWED, "This is not the master controller for " + node);
        }
        return this.modifyFlowInternal(node, oldFlow, newFlow, rid);
    }

    public Status removeFlowAsync(Node node, Flow flow, long rid) {
        if (!this.connectionOutService.isLocal(node)) {
            log.debug("Remove flow async will not be processed in a non-master controller for node " + node);
            return new Status(StatusCode.NOTALLOWED, "This is not the master controller for " + node);
        }
        return this.removeFlowInternal(node, flow, rid);
    }

    private Status addFlowInternal(Node node, Flow flow, long rid) {
        String action = "add";
        if (!node.getType().equals(Node.NodeIDType.OPENFLOW)) {
            return new Status(StatusCode.NOTACCEPTABLE, this.errorString("send", action, "Invalid node type"));
        }
        Status status = this.validateFlow(flow);
        if (!status.isSuccess()) {
            return status;
        }
        if (this.controller != null) {
            ISwitch sw = this.controller.getSwitch((Long)node.getID());
            if (sw != null) {
                FlowConverter x = new FlowConverter(flow);
                OFMessage msg = x.getOFFlowMod((short)0, null);
                Object result = rid == 0L ? sw.syncSend(msg) : this.asyncMsgSend(node, sw, msg, rid);
                return this.getStatusInternal(result, action, rid);
            }
            return new Status(StatusCode.GONE, this.errorString("send", action, "Switch is not available"));
        }
        return new Status(StatusCode.INTERNALERROR, this.errorString("send", action, "Internal plugin error"));
    }

    private Status validateFlow(Flow flow) {
        boolean isIPEthertypeSet;
        Match m = flow.getMatch();
        boolean bl = isIPEthertypeSet = m.isPresent(MatchType.DL_TYPE) && (m.getField(MatchType.DL_TYPE).getValue().equals(EtherTypes.IPv4.shortValue()) || m.getField(MatchType.DL_TYPE).getValue().equals(EtherTypes.IPv6.shortValue()));
        if ((m.isPresent(MatchType.NW_SRC) || m.isPresent(MatchType.NW_DST)) && !isIPEthertypeSet) {
            return new Status(StatusCode.NOTACCEPTABLE, "The match on network source or destination address cannot be accepted if the match on proper ethertype is missing");
        }
        if (m.isPresent(MatchType.NW_PROTO) && !isIPEthertypeSet) {
            return new Status(StatusCode.NOTACCEPTABLE, "The match on network protocol cannot be accepted if the match on proper ethertype is missing");
        }
        if ((m.isPresent(MatchType.TP_SRC) || m.isPresent(MatchType.TP_DST)) && (!isIPEthertypeSet || m.isAny(MatchType.NW_PROTO))) {
            return new Status(StatusCode.NOTACCEPTABLE, "The match on transport source or destination port cannot be accepted if the match on network protocol and match on IP ethertype are missing");
        }
        return new Status(StatusCode.SUCCESS);
    }

    private Status modifyFlowInternal(Node node, Flow oldFlow, Flow newFlow, long rid) {
        String action = "modify";
        if (!node.getType().equals(Node.NodeIDType.OPENFLOW)) {
            return new Status(StatusCode.NOTACCEPTABLE, this.errorString("send", action, "Invalid node type"));
        }
        Status status = this.validateFlow(newFlow);
        if (!status.isSuccess()) {
            return status;
        }
        if (this.controller != null) {
            ISwitch sw = this.controller.getSwitch((Long)node.getID());
            if (sw != null) {
                OFMessage msg1 = null;
                OFMessage msg2 = null;
                if (oldFlow.getPriority() != newFlow.getPriority() || !oldFlow.getMatch().equals((Object)newFlow.getMatch())) {
                    msg1 = new FlowConverter(oldFlow).getOFFlowMod((short)4, OFPort.OFPP_NONE);
                    msg2 = new FlowConverter(newFlow).getOFFlowMod((short)0, null);
                } else {
                    msg1 = new FlowConverter(newFlow).getOFFlowMod((short)2, null);
                }
                action = msg2 == null ? "modify" : "delete";
                Object result = rid == 0L ? sw.syncSend(msg1) : this.asyncMsgSend(node, sw, msg1, rid);
                Status rv = this.getStatusInternal(result, action, rid);
                if (msg2 == null || !rv.isSuccess()) {
                    return rv;
                }
                action = "add";
                result = rid == 0L ? sw.syncSend(msg2) : this.asyncMsgSend(node, sw, msg2, rid);
                return this.getStatusInternal(result, action, rid);
            }
            return new Status(StatusCode.GONE, this.errorString("send", action, "Switch is not available"));
        }
        return new Status(StatusCode.INTERNALERROR, this.errorString("send", action, "Internal plugin error"));
    }

    private Status removeFlowInternal(Node node, Flow flow, long rid) {
        String action = "remove";
        if (!node.getType().equals(Node.NodeIDType.OPENFLOW)) {
            return new Status(StatusCode.NOTACCEPTABLE, this.errorString("send", action, "Invalid node type"));
        }
        if (this.controller != null) {
            ISwitch sw = this.controller.getSwitch((Long)node.getID());
            if (sw != null) {
                OFMessage msg = new FlowConverter(flow).getOFFlowMod((short)4, OFPort.OFPP_NONE);
                Object result = rid == 0L ? sw.syncSend(msg) : this.asyncMsgSend(node, sw, msg, rid);
                return this.getStatusInternal(result, action, rid);
            }
            return new Status(StatusCode.GONE, this.errorString("send", action, "Switch is not available"));
        }
        return new Status(StatusCode.INTERNALERROR, this.errorString("send", action, "Internal plugin error"));
    }

    public Status removeAllFlows(Node node) {
        if (!this.connectionOutService.isLocal(node)) {
            log.debug("Remove all flows will not be processed in a non-master controller for node " + node);
            return new Status(StatusCode.NOTALLOWED, "This is not the master controller for " + node);
        }
        return new Status(StatusCode.SUCCESS);
    }

    private String errorString(String phase, String action, String cause) {
        return "Failed to " + (phase != null ? phase + " the " + action + " flow message: " : action + " the flow: ") + cause;
    }

    @Override
    public void receive(ISwitch sw, OFMessage msg) {
        if (msg instanceof OFFlowRemoved) {
            this.handleFlowRemovedMessage(sw, (OFFlowRemoved)msg);
        } else if (msg instanceof OFError) {
            this.handleErrorMessage(sw, (OFError)msg);
        }
    }

    private void handleFlowRemovedMessage(ISwitch sw, OFFlowRemoved msg) {
        Node node = NodeCreator.createOFNode((Long)sw.getId());
        Flow flow = new FlowConverter(msg.getMatch(), new ArrayList<OFAction>(0)).getFlow(node);
        flow.setPriority(msg.getPriority());
        flow.setIdleTimeout(msg.getIdleTimeout());
        flow.setId(msg.getCookie());
        Match match = flow.getMatch();
        NodeConnector inPort = match.isPresent(MatchType.IN_PORT) ? (NodeConnector)match.getField(MatchType.IN_PORT).getValue() : null;
        for (Map.Entry containerNotifier : this.flowProgrammerNotifiers.entrySet()) {
            String container = (String)containerNotifier.getKey();
            IFlowProgrammerNotifier notifier = (IFlowProgrammerNotifier)containerNotifier.getValue();
            if (inPort != null && !container.equals(GlobalConstants.DEFAULT.toString()) && (!this.containerToNc.containsKey(container) || !this.containerToNc.get(container).contains(inPort))) continue;
            notifier.flowRemoved(node, flow);
        }
    }

    private void handleErrorMessage(ISwitch sw, OFError errorMsg) {
        Node node = NodeCreator.createOFNode((Long)sw.getId());
        OFMessage offendingMsg = errorMsg.getOffendingMsg();
        Integer xid = offendingMsg != null ? Integer.valueOf(offendingMsg.getXid()) : Integer.valueOf(errorMsg.getXid());
        Long rid = this.getMessageRid(sw.getId(), xid);
        if (rid == null || rid == 0L) {
            return;
        }
        for (Map.Entry containerNotifier : this.flowProgrammerNotifiers.entrySet()) {
            IFlowProgrammerNotifier notifier = (IFlowProgrammerNotifier)containerNotifier.getValue();
            notifier.flowErrorReported(node, rid, Utils.getOFErrorString(errorMsg));
        }
    }

    public void tagUpdated(String containerName, Node n, short oldTag, short newTag, UpdateType t) {
    }

    public void containerFlowUpdated(String containerName, ContainerFlow previousFlow, ContainerFlow currentFlow, UpdateType t) {
    }

    public void nodeConnectorUpdated(String containerName, NodeConnector p, UpdateType type) {
        switch (type) {
            case ADDED: {
                if (!this.containerToNc.containsKey(containerName)) {
                    this.containerToNc.put(containerName, new HashSet());
                }
                this.containerToNc.get(containerName).add(p);
                break;
            }
            case CHANGED: {
                break;
            }
            case REMOVED: {
                Set<NodeConnector> target = this.containerToNc.get(containerName);
                if (target == null) break;
                target.remove(p);
                break;
            }
        }
    }

    public void containerModeUpdated(UpdateType t) {
    }

    public Status syncSendBarrierMessage(Node node) {
        if (!this.connectionOutService.isLocal(node)) {
            log.debug("Sync Send Barrier will not be processed in a non-master controller for node " + node);
            return new Status(StatusCode.NOTALLOWED, "This is not the master controller for " + node);
        }
        if (!node.getType().equals(Node.NodeIDType.OPENFLOW)) {
            return new Status(StatusCode.NOTACCEPTABLE, "The node does not support Barrier message.");
        }
        if (this.controller != null) {
            long swid = (Long)node.getID();
            ISwitch sw = this.controller.getSwitch(swid);
            if (sw != null) {
                sw.syncSendBarrierMessage();
                this.clearXid2Rid(swid);
                return new Status(StatusCode.SUCCESS);
            }
            return new Status(StatusCode.GONE, "The node does not have a valid Switch reference.");
        }
        return new Status(StatusCode.INTERNALERROR, "Failed to send Barrier message.");
    }

    public Status asyncSendBarrierMessage(Node node) {
        if (!this.connectionOutService.isLocal(node)) {
            log.debug("ASync Send Barrier will not be processed in a non-master controller for node " + node);
            return new Status(StatusCode.NOTALLOWED, "This is not the master controller for " + node);
        }
        if (!node.getType().equals(Node.NodeIDType.OPENFLOW)) {
            return new Status(StatusCode.NOTACCEPTABLE, "The node does not support Barrier message.");
        }
        if (this.controller != null) {
            long swid = (Long)node.getID();
            ISwitch sw = this.controller.getSwitch(swid);
            if (sw != null) {
                sw.asyncSendBarrierMessage();
                this.clearXid2Rid(swid);
                return new Status(StatusCode.SUCCESS);
            }
            return new Status(StatusCode.GONE, "The node does not have a valid Switch reference.");
        }
        return new Status(StatusCode.INTERNALERROR, "Failed to send Barrier message.");
    }

    private Object asyncMsgSend(Node node, ISwitch sw, OFMessage msg, long rid) {
        Boolean result = Boolean.TRUE;
        long swid = (Long)node.getID();
        int xid = sw.asyncSend(msg);
        this.addXid2Rid(swid, xid, rid);
        Map swxid2rid = (Map)this.xid2rid.get(swid);
        if (swxid2rid == null) {
            return result;
        }
        int size = swxid2rid.size();
        if (size % this.barrierMessagePriorCount == 0) {
            result = this.asyncSendBarrierMessage(node);
        }
        return result;
    }

    private int getBarrierMessagePriorCount() {
        String count = System.getProperty("of.barrierMessagePriorCount");
        int rv = 100;
        if (count != null) {
            try {
                rv = Integer.parseInt(count);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rv;
    }

    private Long getMessageRid(long swid, Integer xid) {
        Long rid = null;
        if (xid == null) {
            return rid;
        }
        Map swxid2rid = (Map)this.xid2rid.get(swid);
        if (swxid2rid != null) {
            rid = (Long)swxid2rid.get(xid);
        }
        return rid;
    }

    public Map<Integer, Long> getSwXid2Rid(long swid) {
        Map swxid2rid = (Map)this.xid2rid.get(swid);
        if (swxid2rid != null) {
            return new HashMap<Integer, Long>(swxid2rid);
        }
        return new HashMap<Integer, Long>();
    }

    private void addXid2Rid(long swid, int xid, long rid) {
        Map swxid2rid = (Map)this.xid2rid.get(swid);
        if (swxid2rid != null) {
            swxid2rid.put(xid, rid);
        }
    }

    private void removeXid2Rid(long swid, int xid) {
        Map swxid2rid = (Map)this.xid2rid.get(swid);
        if (swxid2rid != null) {
            swxid2rid.remove(xid);
        }
    }

    private Status getStatusInternal(Object result, String action, long rid) {
        if (result instanceof Boolean) {
            return (Boolean)result == Boolean.TRUE ? new Status(StatusCode.SUCCESS, rid) : new Status(StatusCode.TIMEOUT, this.errorString(null, action, "Request Timed Out"));
        }
        if (result instanceof Status) {
            return (Status)result;
        }
        if (result instanceof OFError) {
            OFError res = (OFError)result;
            return new Status(StatusCode.INTERNALERROR, this.errorString("program", action, Utils.getOFErrorString(res)));
        }
        return new Status(StatusCode.INTERNALERROR, this.errorString("send", action, "Internal Error"));
    }

    private void clearXid2Rid(long swid) {
        Map swxid2rid = (Map)this.xid2rid.get(swid);
        if (swxid2rid != null) {
            swxid2rid.clear();
        }
    }

    @Override
    public void updateNode(Node node, UpdateType type, Set<Property> props) {
        long swid = (Long)node.getID();
        switch (type) {
            case ADDED: {
                HashMap swxid2rid = new HashMap();
                this.xid2rid.put(swid, swxid2rid);
                break;
            }
            case CHANGED: {
                break;
            }
            case REMOVED: {
                this.xid2rid.remove(swid);
                break;
            }
        }
    }

    @Override
    public void updateNodeConnector(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("-- Flow Programmer Service --\n");
        help.append("\t px2r <node id>          - Print outstanding xid2rid mappings for a given node id\n");
        help.append("\t px2rc                   - Print max num of async msgs prior to the Barrier\n");
        return help.toString();
    }

    public void _px2r(CommandInterpreter ci) {
        long sid;
        String st = ci.nextArgument();
        if (st == null) {
            ci.println((Object)"Please enter a valid node id");
            return;
        }
        try {
            sid = HexEncode.stringToLong((String)st);
        }
        catch (NumberFormatException e) {
            ci.println((Object)"Please enter a valid node id");
            return;
        }
        Map swxid2rid = (Map)this.xid2rid.get(sid);
        if (swxid2rid == null) {
            ci.println((Object)"The node id entered does not exist");
            return;
        }
        ci.println((Object)"xid             rid");
        Set xidSet = swxid2rid.keySet();
        if (xidSet == null) {
            return;
        }
        for (Integer xid : xidSet) {
            ci.println((Object)(xid + "       " + swxid2rid.get(xid)));
        }
    }

    public void _px2rc(CommandInterpreter ci) {
        ci.println((Object)("Max num of async messages sent prior to the Barrier message is " + this.barrierMessagePriorCount));
    }

    public void containerCreate(String containerName) {
    }

    public void containerDestroy(String containerName) {
        this.containerToNc.remove(containerName);
    }
}

